/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.redisson.RedissonReference;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonSetMultimap;
import org.redisson.api.RFuture;
import org.redisson.api.RLiveObject;
import org.redisson.api.RMap;
import org.redisson.api.RObject;
import org.redisson.api.annotation.REntity;
import org.redisson.api.annotation.RIndex;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.liveobject.misc.Introspectior;
import org.redisson.liveobject.resolver.NamingScheme;

public class AccessorInterceptor {
    private final CommandAsyncExecutor commandExecutor;
    private final ConnectionManager connectionManager;

    public AccessorInterceptor(CommandAsyncExecutor commandExecutor, ConnectionManager connectionManager) {
        this.commandExecutor = commandExecutor;
        this.connectionManager = connectionManager;
    }

    @RuntimeType
    public Object intercept(@Origin Method method, @SuperCall Callable<?> superMethod, @AllArguments Object[] args, @This Object me, @FieldValue(value="liveObjectLiveMap") RMap<String, Object> liveMap) throws Exception {
        if (this.isGetter(method, AccessorInterceptor.getREntityIdFieldName(me))) {
            return ((RLiveObject)me).getLiveObjectId();
        }
        if (this.isSetter(method, AccessorInterceptor.getREntityIdFieldName(me))) {
            ((RLiveObject)me).setLiveObjectId(args[0]);
            return null;
        }
        String fieldName = this.getFieldName(me.getClass().getSuperclass(), method);
        Field field = ClassUtils.getDeclaredField(me.getClass().getSuperclass(), fieldName);
        Class<?> fieldType = field.getType();
        if (this.isGetter(method, fieldName)) {
            RObject ar;
            Object result = liveMap.get(fieldName);
            if (result == null && (ar = this.commandExecutor.getObjectBuilder().createObject(((RLiveObject)me).getLiveObjectId(), me.getClass().getSuperclass(), fieldType, fieldName)) != null) {
                this.commandExecutor.getObjectBuilder().store(ar, fieldName, liveMap);
                return ar;
            }
            if (result != null && fieldType.isEnum()) {
                if (result instanceof String) {
                    return Enum.valueOf(fieldType, (String)result);
                }
                return result;
            }
            if (result instanceof RedissonReference) {
                return this.commandExecutor.getObjectBuilder().fromReference((RedissonReference)result);
            }
            return result;
        }
        if (this.isSetter(method, fieldName)) {
            Object arg = args[0];
            if (arg != null && ClassUtils.isAnnotationPresent(arg.getClass(), REntity.class)) {
                throw new IllegalStateException("REntity object should be attached to Redisson first");
            }
            if (arg instanceof RLiveObject) {
                RLiveObject liveObject = (RLiveObject)arg;
                this.storeIndex(field, me, liveObject.getLiveObjectId());
                Class<?> rEntity = liveObject.getClass().getSuperclass();
                NamingScheme ns = this.commandExecutor.getObjectBuilder().getNamingScheme(rEntity);
                if (this.commandExecutor instanceof CommandBatchService) {
                    liveMap.fastPutAsync(fieldName, new RedissonReference(rEntity, ns.getName(rEntity, liveObject.getLiveObjectId())));
                } else {
                    liveMap.fastPut(fieldName, new RedissonReference(rEntity, ns.getName(rEntity, liveObject.getLiveObjectId())));
                }
                return me;
            }
            if (!(arg instanceof RObject) && (arg instanceof Collection || arg instanceof Map) && REntity.TransformationMode.ANNOTATION_BASED.equals((Object)ClassUtils.getAnnotation(me.getClass().getSuperclass(), REntity.class).fieldTransformation())) {
                RObject rObject = this.commandExecutor.getObjectBuilder().createObject(((RLiveObject)me).getLiveObjectId(), me.getClass().getSuperclass(), arg.getClass(), fieldName);
                if (arg != null) {
                    if (rObject instanceof Collection) {
                        Collection c = (Collection)((Object)rObject);
                        c.clear();
                        c.addAll((Collection)arg);
                    } else {
                        Map m = (Map)((Object)rObject);
                        m.clear();
                        m.putAll((Map)arg);
                    }
                }
                if (rObject != null) {
                    arg = rObject;
                }
            }
            if (arg instanceof RObject) {
                if (this.commandExecutor instanceof CommandBatchService) {
                    this.commandExecutor.getObjectBuilder().storeAsync((RObject)arg, fieldName, liveMap);
                } else {
                    this.commandExecutor.getObjectBuilder().store((RObject)arg, fieldName, liveMap);
                }
                return me;
            }
            this.removeIndex(liveMap, me, field);
            if (arg != null) {
                this.storeIndex(field, me, arg);
                if (this.commandExecutor instanceof CommandBatchService) {
                    liveMap.fastPutAsync(fieldName, arg);
                } else {
                    liveMap.fastPut(fieldName, arg);
                }
            }
            return me;
        }
        return superMethod.call();
    }

    private void removeIndex(RMap<String, Object> liveMap, Object me, Field field) {
        if (field.getAnnotation(RIndex.class) == null) {
            return;
        }
        NamingScheme namingScheme = this.commandExecutor.getObjectBuilder().getNamingScheme(me.getClass().getSuperclass());
        String indexName = namingScheme.getIndexName(me.getClass().getSuperclass(), field.getName());
        CommandBatchService ce = this.commandExecutor instanceof CommandBatchService ? (CommandBatchService)this.commandExecutor : new CommandBatchService(this.connectionManager);
        if (Number.class.isAssignableFrom(field.getType())) {
            RedissonScoredSortedSet<Object> set = new RedissonScoredSortedSet<Object>(namingScheme.getCodec(), ce, indexName, null);
            set.removeAsync(((RLiveObject)me).getLiveObjectId());
        } else if (ClassUtils.isAnnotationPresent(field.getType(), REntity.class)) {
            Object value = liveMap.remove(field.getName());
            RedissonSetMultimap map = new RedissonSetMultimap(namingScheme.getCodec(), ce, indexName);
            map.removeAsync(((RLiveObject)value).getLiveObjectId(), ((RLiveObject)me).getLiveObjectId());
        } else {
            this.removeAsync(ce, indexName, liveMap.getName(), namingScheme.getCodec(), ((RLiveObject)me).getLiveObjectId(), field.getName());
        }
        ce.execute();
    }

    private RFuture<Boolean> removeAsync(CommandBatchService ce, String name, String mapName, Codec codec, Object value, String fieldName) {
        ByteBuf valueState = ce.encodeMapValue(codec, value);
        return ce.evalWriteAsync(name, codec, RedisCommands.EVAL_VOID, "local oldArg = redis.call('hget', KEYS[2], ARGV[2]);if oldArg == false then return; end;redis.call('hdel', KEYS[2], ARGV[2]); local hash = redis.call('hget', KEYS[1], oldArg); local setName = KEYS[1] .. ':' .. hash; local res = redis.call('srem', setName, ARGV[1]); if res == 1 and redis.call('scard', setName) == 0 then redis.call('hdel', KEYS[1], oldArg); end; ", Arrays.asList(name, mapName), valueState, ce.encodeMapKey(codec, fieldName));
    }

    private void storeIndex(Field field, Object me, Object arg) {
        CommandBatchService ce;
        if (field.getAnnotation(RIndex.class) == null) {
            return;
        }
        NamingScheme namingScheme = this.commandExecutor.getObjectBuilder().getNamingScheme(me.getClass().getSuperclass());
        String indexName = namingScheme.getIndexName(me.getClass().getSuperclass(), field.getName());
        boolean skipExecution = false;
        if (this.commandExecutor instanceof CommandBatchService) {
            ce = (CommandBatchService)this.commandExecutor;
            skipExecution = true;
        } else {
            ce = new CommandBatchService(this.connectionManager);
        }
        if (arg instanceof Number) {
            RedissonScoredSortedSet<Object> set = new RedissonScoredSortedSet<Object>(namingScheme.getCodec(), ce, indexName, null);
            set.addAsync(((Number)arg).doubleValue(), ((RLiveObject)me).getLiveObjectId());
        } else {
            RedissonSetMultimap<Object, Object> map = new RedissonSetMultimap<Object, Object>(namingScheme.getCodec(), ce, indexName);
            map.putAsync(arg, ((RLiveObject)me).getLiveObjectId());
        }
        if (!skipExecution) {
            ce.execute();
        }
    }

    private String getFieldName(Class<?> clazz, Method method) {
        String name = method.getName();
        int i = 4;
        if (name.startsWith("is")) {
            i = 3;
        }
        try {
            String fieldName = name.substring(i - 1, i).toLowerCase() + name.substring(i);
            ClassUtils.getDeclaredField(clazz, fieldName);
            return fieldName;
        }
        catch (NoSuchFieldException e) {
            return name.substring(i - 1);
        }
    }

    private boolean isGetter(Method method, String fieldName) {
        return method.getName().equals("get" + AccessorInterceptor.getFieldNameSuffix(fieldName)) || method.getName().equals("is" + AccessorInterceptor.getFieldNameSuffix(fieldName));
    }

    private boolean isSetter(Method method, String fieldName) {
        return method.getName().equals("set" + AccessorInterceptor.getFieldNameSuffix(fieldName));
    }

    private static String getFieldNameSuffix(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static String getREntityIdFieldName(Object o) {
        return Introspectior.getREntityIdFieldName(o.getClass().getSuperclass());
    }
}

