/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.resolver.AddressResolver;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.redisson.api.NatMapper;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisAuthRequiredException;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.SentinelServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.CountableListener;
import org.redisson.misc.RedisURI;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<RedisURI> sentinelHosts = new HashSet<RedisURI>();
    private final ConcurrentMap<RedisURI, RedisClient> sentinels = new ConcurrentHashMap<RedisURI, RedisClient>();
    private final AtomicReference<RedisURI> currentMaster = new AtomicReference();
    private final Set<RedisURI> disconnectedSlaves = new HashSet<RedisURI>();
    private ScheduledFuture<?> monitorFuture;
    private AddressResolver<InetSocketAddress> sentinelResolver;
    private final NatMapper natMapper;
    private boolean usePassword = false;
    private String scheme;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SentinelConnectionManager(SentinelServersConfig cfg, Config config, UUID id) {
        super(config, id);
        if (cfg.getMasterName() == null) {
            throw new IllegalArgumentException("masterName parameter is not defined!");
        }
        if (cfg.getSentinelAddresses().isEmpty()) {
            throw new IllegalArgumentException("At least one sentinel node should be defined!");
        }
        this.config = this.create(cfg);
        this.initTimer(this.config);
        this.natMapper = cfg.getNatMapper();
        this.sentinelResolver = this.resolverGroup.getResolver(this.getGroup().next());
        this.checkAuth(cfg);
        for (String address : cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            if (NetUtil.createByteArrayFromIpAddressString((addr = this.applyNatMap(addr)).getHost()) != null || addr.getHost().equals("localhost")) continue;
            this.sentinelHosts.add(addr);
        }
        Exception lastException = null;
        for (String address : cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            addr = this.applyNatMap(addr);
            RedisClient client = this.createClient(NodeType.SENTINEL, addr, this.config.getConnectTimeout(), this.config.getTimeout(), null);
            try {
                RedisConnection connection = null;
                try {
                    connection = client.connect();
                    if (!connection.isActive()) continue;
                }
                catch (RedisConnectionException e) {}
                continue;
                InetSocketAddress master = connection.sync(RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME, cfg.getMasterName());
                if (master == null) {
                    throw new RedisConnectionException("Master node is undefined! SENTINEL GET-MASTER-ADDR-BY-NAME command returns empty result!");
                }
                RedisURI masterHost = this.toURI(master.getHostString(), String.valueOf(master.getPort()));
                this.config.setMasterAddress(masterHost.toString());
                this.currentMaster.set(masterHost);
                this.log.info("master: {} added", (Object)masterHost);
                List sentinelSlaves = (List)connection.sync(StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, cfg.getMasterName());
                for (Map map : sentinelSlaves) {
                    if (map.isEmpty()) continue;
                    String ip = (String)map.get("ip");
                    String port = (String)map.get("port");
                    String string = (String)map.get("flags");
                    RedisURI host = this.toURI(ip, port);
                    this.config.addSlaveAddress(host.toString());
                    this.log.debug("slave {} state: {}", (Object)host, (Object)map);
                    this.log.info("slave: {} added", (Object)host);
                    if (!string.contains("s_down") && !string.contains("disconnected")) continue;
                    this.disconnectedSlaves.add(host);
                    this.log.warn("slave: {} is down", (Object)host);
                }
                List sentinelSentinels = (List)connection.sync(StringCodec.INSTANCE, RedisCommands.SENTINEL_SENTINELS, cfg.getMasterName());
                ArrayList<RFuture<Void>> connectionFutures = new ArrayList<RFuture<Void>>(sentinelSentinels.size());
                for (Map map : sentinelSentinels) {
                    if (map.isEmpty()) continue;
                    String string = (String)map.get("ip");
                    String port = (String)map.get("port");
                    RedisURI sentinelAddr = this.toURI(string, port);
                    RFuture<Void> future = this.registerSentinel(sentinelAddr, this.config, null);
                    connectionFutures.add(future);
                }
                RFuture<Void> f = this.registerSentinel(addr, this.config, null);
                connectionFutures.add(f);
                for (RFuture rFuture : connectionFutures) {
                    rFuture.awaitUninterruptibly(this.config.getConnectTimeout());
                }
                break;
            }
            catch (RedisConnectionException e) {
                this.stopThreads();
                throw e;
            }
            catch (Exception e) {
                lastException = e;
                this.log.warn(e.getMessage());
            }
            finally {
                client.shutdownAsync();
            }
        }
        if (cfg.isCheckSentinelsList()) {
            if (this.sentinels.isEmpty()) {
                this.stopThreads();
                throw new RedisConnectionException("SENTINEL SENTINELS command returns empty result! Set checkSentinelsList = false to avoid this check.", lastException);
            }
            if (this.sentinels.size() < 2) {
                this.stopThreads();
                throw new RedisConnectionException("SENTINEL SENTINELS command returns less than 2 nodes! At least two sentinels should be defined in Redis configuration. Set checkSentinelsList = false to avoid this check.", lastException);
            }
        }
        if (this.currentMaster.get() == null) {
            this.stopThreads();
            throw new RedisConnectionException("Can't connect to servers!", lastException);
        }
        if (this.config.getReadMode() != ReadMode.MASTER && this.config.getSlaveAddresses().isEmpty()) {
            this.log.warn("ReadMode = " + (Object)((Object)this.config.getReadMode()) + ", but slave nodes are not found!");
        }
        this.initSingleEntry();
        this.scheduleChangeCheck(cfg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAuth(SentinelServersConfig cfg) {
        boolean connected = false;
        for (String address : cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            this.scheme = addr.getScheme();
            addr = this.applyNatMap(addr);
            RedisClient client = this.createClient(NodeType.SENTINEL, addr, this.config.getConnectTimeout(), this.config.getTimeout(), null);
            try {
                RedisConnection c = client.connect();
                connected = true;
                try {
                    c.sync(RedisCommands.PING, new Object[0]);
                }
                catch (RedisAuthRequiredException e) {
                    this.usePassword = true;
                }
                break;
            }
            catch (RedisConnectionException e) {
                this.log.warn("Can't connect to sentinel server. {}", (Object)e.getMessage());
            }
            catch (Exception exception) {}
            continue;
            finally {
                client.shutdown();
            }
        }
        if (!connected) {
            this.stopThreads();
            StringBuilder list = new StringBuilder();
            for (String address : cfg.getSentinelAddresses()) {
                list.append(address).append(", ");
            }
            throw new RedisConnectionException("Unable to connect to Redis sentinel servers: " + list);
        }
    }

    @Override
    protected void startDNSMonitoring(RedisClient masterHost) {
        if (this.config.getDnsMonitoringInterval() == -1L || this.sentinelHosts.isEmpty()) {
            return;
        }
        this.scheduleSentinelDNSCheck();
    }

    @Override
    protected RedisClientConfig createRedisConfig(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig result = super.createRedisConfig(type, address, timeout, commandTimeout, sslHostname);
        if (type == NodeType.SENTINEL && !this.usePassword) {
            result.setPassword(null);
        }
        return result;
    }

    private void scheduleSentinelDNSCheck() {
        this.monitorFuture = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                final AtomicInteger sentinelsCounter = new AtomicInteger(SentinelConnectionManager.this.sentinelHosts.size());
                FutureListener<List<InetSocketAddress>> commonListener = new FutureListener<List<InetSocketAddress>>(){

                    @Override
                    public void operationComplete(Future<List<InetSocketAddress>> future) throws Exception {
                        if (sentinelsCounter.decrementAndGet() == 0) {
                            SentinelConnectionManager.this.scheduleSentinelDNSCheck();
                        }
                    }
                };
                SentinelConnectionManager.this.performSentinelDNSCheck(commonListener);
            }
        }, this.config.getDnsMonitoringInterval(), TimeUnit.MILLISECONDS);
    }

    private void performSentinelDNSCheck(FutureListener<List<InetSocketAddress>> commonListener) {
        for (final RedisURI host : this.sentinelHosts) {
            Future<List<InetSocketAddress>> allNodes = this.sentinelResolver.resolveAll(InetSocketAddress.createUnresolved(host.getHost(), host.getPort()));
            allNodes.addListener((GenericFutureListener<Future<List<InetSocketAddress>>>)new FutureListener<List<InetSocketAddress>>(){

                @Override
                public void operationComplete(Future<List<InetSocketAddress>> future) throws Exception {
                    if (!future.isSuccess()) {
                        SentinelConnectionManager.this.log.error("Unable to resolve " + host.getHost(), future.cause());
                        return;
                    }
                    Set newUris = future.getNow().stream().map(addr -> SentinelConnectionManager.this.toURI(addr.getAddress().getHostAddress(), "" + addr.getPort())).collect(Collectors.toSet());
                    for (RedisURI uri : newUris) {
                        if (SentinelConnectionManager.this.sentinels.containsKey(uri)) continue;
                        SentinelConnectionManager.this.registerSentinel(uri, SentinelConnectionManager.this.getConfig(), host.getHost());
                    }
                }
            });
            if (commonListener == null) continue;
            allNodes.addListener(commonListener);
        }
    }

    private void scheduleChangeCheck(final SentinelServersConfig cfg, final Iterator<RedisClient> iterator) {
        this.monitorFuture = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                AtomicReference lastException = new AtomicReference();
                Iterator iter = iterator;
                if (iter == null) {
                    ArrayList clients = new ArrayList(SentinelConnectionManager.this.sentinels.values());
                    Collections.shuffle(clients);
                    iter = clients.iterator();
                }
                SentinelConnectionManager.this.checkState(cfg, iter, lastException);
            }
        }, (long)cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private void checkState(SentinelServersConfig cfg, Iterator<RedisClient> iterator, AtomicReference<Throwable> lastException) {
        if (!iterator.hasNext()) {
            if (lastException.get() != null) {
                this.log.error("Can't update cluster state", lastException.get());
            }
            this.performSentinelDNSCheck(null);
            this.scheduleChangeCheck(cfg, null);
            return;
        }
        if (!this.getShutdownLatch().acquire()) {
            return;
        }
        RedisClient client = iterator.next();
        RFuture<RedisConnection> connectionFuture = this.connectToNode(null, null, client, null);
        connectionFuture.onComplete((connection, e) -> {
            if (e != null) {
                lastException.set((Throwable)e);
                this.getShutdownLatch().release();
                this.checkState(cfg, iterator, lastException);
                return;
            }
            this.updateState(cfg, (RedisConnection)connection, iterator);
        });
    }

    private void updateState(final SentinelServersConfig cfg, final RedisConnection connection, final Iterator<RedisClient> iterator) {
        final AtomicInteger commands = new AtomicInteger(2);
        BiConsumer<Object, Throwable> commonListener = new BiConsumer<Object, Throwable>(){
            private final AtomicBoolean failed = new AtomicBoolean();

            @Override
            public void accept(Object t, Throwable u) {
                if (commands.decrementAndGet() == 0) {
                    SentinelConnectionManager.this.getShutdownLatch().release();
                    if (this.failed.get()) {
                        SentinelConnectionManager.this.scheduleChangeCheck(cfg, iterator);
                    } else {
                        SentinelConnectionManager.this.scheduleChangeCheck(cfg, null);
                    }
                }
                if (u != null && this.failed.compareAndSet(false, true)) {
                    SentinelConnectionManager.this.log.error("Can't execute SENTINEL commands on " + connection.getRedisClient().getAddr(), u);
                    SentinelConnectionManager.this.closeNodeConnection(connection);
                }
            }
        };
        RFuture masterFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME, cfg.getMasterName());
        masterFuture.onComplete((master, e) -> {
            if (e != null) {
                return;
            }
            RedisURI current = this.currentMaster.get();
            RedisURI newMaster = this.toURI(master.getHostString(), String.valueOf(master.getPort()));
            if (!newMaster.equals(current) && this.currentMaster.compareAndSet(current, newMaster)) {
                RFuture<RedisClient> changeFuture = this.changeMaster(this.singleSlotRange.getStartSlot(), newMaster);
                changeFuture.onComplete((res, ex) -> {
                    if (ex != null) {
                        this.currentMaster.compareAndSet(newMaster, current);
                    }
                });
            }
        });
        masterFuture.onComplete(commonListener);
        if (!this.config.checkSkipSlavesInit()) {
            RFuture slavesFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, cfg.getMasterName());
            commands.incrementAndGet();
            slavesFuture.onComplete((slavesMap, e) -> {
                if (e != null) {
                    return;
                }
                final HashSet<RedisURI> currentSlaves = new HashSet<RedisURI>(slavesMap.size());
                ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>();
                for (Map map : slavesMap) {
                    if (map.isEmpty()) continue;
                    String string = (String)map.get("ip");
                    String port = (String)map.get("port");
                    String flags = (String)map.get("flags");
                    String masterHost = (String)map.get("master-host");
                    String masterPort = (String)map.get("master-port");
                    RedisURI slaveAddr = this.toURI(string, port);
                    if (flags.contains("s_down") || flags.contains("disconnected")) {
                        this.slaveDown(slaveAddr);
                        continue;
                    }
                    if ("?".equals(masterHost) || !this.isUseSameMaster(slaveAddr, masterHost, masterPort)) continue;
                    currentSlaves.add(slaveAddr);
                    RFuture<Void> slaveFuture = this.addSlave(slaveAddr);
                    futures.add(slaveFuture);
                }
                CountableListener<Void> listener = new CountableListener<Void>(){

                    @Override
                    protected void onSuccess(Void value) {
                        MasterSlaveEntry entry = SentinelConnectionManager.this.getEntry(SentinelConnectionManager.this.singleSlotRange.getStartSlot());
                        HashSet<RedisURI> removedSlaves = new HashSet<RedisURI>();
                        for (ClientConnectionsEntry e : entry.getAllEntries()) {
                            InetSocketAddress addr = e.getClient().getAddr();
                            RedisURI slaveAddr = SentinelConnectionManager.this.toURI(addr.getAddress().getHostAddress(), String.valueOf(addr.getPort()));
                            removedSlaves.add(slaveAddr);
                        }
                        removedSlaves.removeAll(currentSlaves);
                        for (RedisURI slave : removedSlaves) {
                            if (slave.equals(SentinelConnectionManager.this.currentMaster.get())) continue;
                            SentinelConnectionManager.this.slaveDown(slave);
                        }
                    }
                };
                listener.setCounter(futures.size());
                for (RFuture rFuture : futures) {
                    rFuture.onComplete(listener);
                }
            });
            slavesFuture.onComplete(commonListener);
        }
        RFuture sentinelsFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_SENTINELS, cfg.getMasterName());
        sentinelsFuture.onComplete((list, e) -> {
            if (e != null || list.isEmpty()) {
                return;
            }
            Set<RedisURI> newUris = list.stream().filter(m -> {
                String flags = (String)m.get("flags");
                return !m.isEmpty() && !flags.contains("disconnected") && !flags.contains("s_down");
            }).map(m -> {
                String ip = (String)m.get("ip");
                String port = (String)m.get("port");
                return this.toURI(ip, port);
            }).collect(Collectors.toSet());
            InetSocketAddress addr = connection.getRedisClient().getAddr();
            RedisURI currentAddr = this.toURI(addr.getAddress().getHostAddress(), "" + addr.getPort());
            newUris.add(currentAddr);
            this.updateSentinels(newUris);
        });
        sentinelsFuture.onComplete(commonListener);
    }

    private void updateSentinels(Set<RedisURI> newUris) {
        HashSet currentUris = new HashSet(this.sentinels.keySet());
        HashSet<RedisURI> addedUris = new HashSet<RedisURI>(newUris);
        addedUris.removeAll(currentUris);
        for (RedisURI uri : addedUris) {
            this.registerSentinel(uri, this.getConfig(), null);
        }
        currentUris.removeAll(newUris);
        for (RedisURI uri : currentUris) {
            RedisClient sentinel = (RedisClient)this.sentinels.remove(uri);
            if (sentinel == null) continue;
            this.disconnectNode(sentinel);
            sentinel.shutdownAsync();
            this.log.warn("sentinel: {} is down", (Object)uri);
        }
    }

    private RedisURI toURI(String host, String port) {
        RedisURI uri = new RedisURI(this.scheme + "://" + host + ":" + port);
        return this.applyNatMap(uri);
    }

    @Override
    protected Collection<RedisURI> getDisconnectedNodes() {
        return this.disconnectedSlaves;
    }

    private RFuture<Void> registerSentinel(RedisURI addr, MasterSlaveServersConfig c, String sslHostname) {
        RedisClient sentinel;
        boolean isHostname;
        boolean bl = isHostname = NetUtil.createByteArrayFromIpAddressString(addr.getHost()) == null;
        if (!isHostname && (sentinel = (RedisClient)this.sentinels.get(addr)) != null) {
            return RedissonPromise.newSucceededFuture(null);
        }
        RedisClient client = this.createClient(NodeType.SENTINEL, addr, c.getConnectTimeout(), c.getTimeout(), sslHostname);
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<InetSocketAddress> future = client.resolveAddr();
        future.onComplete((res, e) -> {
            RedisClient sentinel;
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            RedisURI ipAddr = this.toURI(client.getAddr().getAddress().getHostAddress(), "" + client.getAddr().getPort());
            if (isHostname && (sentinel = (RedisClient)this.sentinels.get(ipAddr)) != null) {
                result.trySuccess(null);
                return;
            }
            RFuture<RedisConnection> f = client.connectAsync();
            f.onComplete((connection, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                RFuture r = connection.async(RedisCommands.PING, new Object[0]);
                r.onComplete((resp, exc) -> {
                    if (exc != null) {
                        result.tryFailure((Throwable)exc);
                        return;
                    }
                    if (this.sentinels.putIfAbsent(ipAddr, client) == null) {
                        this.log.info("sentinel: {} added", (Object)ipAddr);
                    }
                    result.trySuccess(null);
                });
            });
        });
        return result;
    }

    private RFuture<Void> addSlave(RedisURI uri) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
        if (!entry.hasSlave(uri) && !this.config.checkSkipSlavesInit()) {
            RFuture<Void> future = entry.addSlave(uri);
            future.onComplete((res, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)e);
                    this.log.error("Can't add slave: " + uri, (Throwable)e);
                    return;
                }
                if (entry.isSlaveUnfreezed(uri) || entry.slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
                    this.log.info("slave: {} added", (Object)uri);
                    result.trySuccess(null);
                }
            });
        } else {
            if (entry.hasSlave(uri)) {
                this.slaveUp(uri);
            }
            result.trySuccess(null);
        }
        return result;
    }

    private void slaveDown(RedisURI uri) {
        if (this.config.checkSkipSlavesInit()) {
            this.log.warn("slave: {} is down", (Object)uri);
        } else {
            MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
            if (entry.slaveDown(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
                this.log.warn("slave: {} is down", (Object)uri);
            }
        }
    }

    private boolean isUseSameMaster(RedisURI slaveAddr, String slaveMasterHost, String slaveMasterPort) {
        RedisURI slaveMaster;
        RedisURI master = this.currentMaster.get();
        return master.equals(slaveMaster = this.toURI(slaveMasterHost, slaveMasterPort));
    }

    private void slaveUp(RedisURI uri) {
        if (this.config.checkSkipSlavesInit()) {
            this.log.info("slave: {} is up", (Object)uri);
            return;
        }
        if (this.getEntry(this.singleSlotRange.getStartSlot()).slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
            this.log.info("slave: {} is up", (Object)uri);
        }
    }

    @Override
    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig res = super.create(cfg);
        res.setDatabase(((SentinelServersConfig)cfg).getDatabase());
        return res;
    }

    public Collection<RedisClient> getSentinels() {
        return this.sentinels.values();
    }

    @Override
    public void shutdown() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>();
        for (RedisClient redisClient : this.sentinels.values()) {
            RFuture<Void> future = redisClient.shutdownAsync();
            futures.add(future);
        }
        for (RFuture rFuture : futures) {
            rFuture.syncUninterruptibly();
        }
        super.shutdown();
    }

    @Override
    public RedisURI applyNatMap(RedisURI address) {
        RedisURI result = this.natMapper.map(address);
        this.log.debug("nat mapped uri: {} to {}", (Object)address, (Object)result);
        return result;
    }
}

