/*
 * Decompiled with CFR 0.152.
 */
package jodd.system;

import jodd.system.JvmInfo;
import jodd.system.SystemUtil;
import jodd.util.ClassLoaderUtil;

abstract class OsInfo
extends JvmInfo {
    private final String OS_VERSION = SystemUtil.get("os.version");
    private final String OS_ARCH = SystemUtil.get("os.arch");
    private final String OS_NAME = SystemUtil.get("os.name");
    private final boolean IS_ANDROID = OsInfo.isAndroid0();
    private final boolean IS_OS_AIX = this.matchOS("AIX");
    private final boolean IS_OS_HP_UX = this.matchOS("HP-UX");
    private final boolean IS_OS_IRIX = this.matchOS("Irix");
    private final boolean IS_OS_LINUX = this.matchOS("Linux") || this.matchOS("LINUX");
    private final boolean IS_OS_MAC = this.matchOS("Mac");
    private final boolean IS_OS_MAC_OSX = this.matchOS("Mac OS X");
    private final boolean IS_OS_OS2 = this.matchOS("OS/2");
    private final boolean IS_OS_SOLARIS = this.matchOS("Solaris");
    private final boolean IS_OS_SUN_OS = this.matchOS("SunOS");
    private final boolean IS_OS_WINDOWS = this.matchOS("Windows");
    private final boolean IS_OS_WINDOWS_2000 = this.matchOS("Windows", "5.0");
    private final boolean IS_OS_WINDOWS_95 = this.matchOS("Windows 9", "4.0");
    private final boolean IS_OS_WINDOWS_98 = this.matchOS("Windows 9", "4.1");
    private final boolean IS_OS_WINDOWS_ME = this.matchOS("Windows", "4.9");
    private final boolean IS_OS_WINDOWS_NT = this.matchOS("Windows NT");
    private final boolean IS_OS_WINDOWS_XP = this.matchOS("Windows", "5.1");
    private final String FILE_SEPARATOR = SystemUtil.get("file.separator");
    private final String LINE_SEPARATOR = SystemUtil.get("line.separator");
    private final String PATH_SEPARATOR = SystemUtil.get("path.separator");
    private final String FILE_ENCODING = SystemUtil.get("file.encoding");

    OsInfo() {
    }

    public final String getOsArchitecture() {
        return this.OS_ARCH;
    }

    public final String getOsName() {
        return this.OS_NAME;
    }

    public final String getOsVersion() {
        return this.OS_VERSION;
    }

    public boolean isAndroid() {
        return this.IS_ANDROID;
    }

    private static boolean isAndroid0() {
        try {
            Class.forName("android.app.Application", false, ClassLoaderUtil.getSystemClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean isAix() {
        return this.IS_OS_AIX;
    }

    public final boolean isHpUx() {
        return this.IS_OS_HP_UX;
    }

    public final boolean isIrix() {
        return this.IS_OS_IRIX;
    }

    public final boolean isLinux() {
        return this.IS_OS_LINUX;
    }

    public final boolean isMac() {
        return this.IS_OS_MAC;
    }

    public final boolean isMacOsX() {
        return this.IS_OS_MAC_OSX;
    }

    public final boolean isOs2() {
        return this.IS_OS_OS2;
    }

    public final boolean isSolaris() {
        return this.IS_OS_SOLARIS;
    }

    public final boolean isSunOS() {
        return this.IS_OS_SUN_OS;
    }

    public final boolean isWindows() {
        return this.IS_OS_WINDOWS;
    }

    public final boolean isWindows2000() {
        return this.IS_OS_WINDOWS_2000;
    }

    public final boolean isWindows95() {
        return this.IS_OS_WINDOWS_95;
    }

    public final boolean isWindows98() {
        return this.IS_OS_WINDOWS_98;
    }

    public final boolean isWindowsME() {
        return this.IS_OS_WINDOWS_ME;
    }

    public final boolean isWindowsNT() {
        return this.IS_OS_WINDOWS_NT;
    }

    public final boolean isWindowsXP() {
        return this.IS_OS_WINDOWS_XP;
    }

    public final String getFileSeparator() {
        return this.FILE_SEPARATOR;
    }

    public final String getLineSeparator() {
        return this.LINE_SEPARATOR;
    }

    public final String getPathSeparator() {
        return this.PATH_SEPARATOR;
    }

    public final String getFileEncoding() {
        return this.FILE_ENCODING;
    }

    private boolean matchOS(String osNamePrefix) {
        if (this.OS_NAME == null) {
            return false;
        }
        return this.OS_NAME.startsWith(osNamePrefix);
    }

    private boolean matchOS(String osNamePrefix, String osVersionPrefix) {
        if (this.OS_NAME == null || this.OS_VERSION == null) {
            return false;
        }
        return this.OS_NAME.startsWith(osNamePrefix) && this.OS_VERSION.startsWith(osVersionPrefix);
    }
}

