/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.Single;
import java.nio.ByteBuffer;
import org.redisson.RedissonBinaryStream;
import org.redisson.api.RBinaryStream;
import org.redisson.api.RFuture;
import org.redisson.rx.CommandRxExecutor;

public class RedissonBinaryStreamRx {
    private final CommandRxExecutor commandExecutor;
    private final RedissonBinaryStream.RedissonAsynchronousByteChannel channel;

    public RedissonBinaryStreamRx(CommandRxExecutor commandExecutor, RBinaryStream stream) {
        this.commandExecutor = commandExecutor;
        this.channel = (RedissonBinaryStream.RedissonAsynchronousByteChannel)stream.getAsynchronousChannel();
    }

    public long position() {
        return this.channel.position();
    }

    public void position(long newPosition) {
        this.channel.position(newPosition);
    }

    public Single<Integer> read(ByteBuffer buf) {
        return this.commandExecutor.flowable(() -> (RFuture)this.channel.read(buf)).singleOrError();
    }

    public Single<Integer> write(ByteBuffer buf) {
        return this.commandExecutor.flowable(() -> (RFuture)this.channel.write(buf)).singleOrError();
    }
}

