/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateLimiterConfig;
import org.redisson.api.RateType;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class RedissonRateLimiter
extends RedissonExpirable
implements RRateLimiter {
    private static final RedisCommand HGETALL = new RedisCommand<RateLimiterConfig>("HGETALL", new MultiDecoder<RateLimiterConfig>(){

        @Override
        public Decoder<Object> getDecoder(int paramNum, State state) {
            return null;
        }

        @Override
        public RateLimiterConfig decode(List<Object> parts, State state) {
            HashMap<String, String> map = new HashMap<String, String>(parts.size() / 2);
            for (int i = 0; i < parts.size(); ++i) {
                if (i % 2 == 0) continue;
                map.put(parts.get(i - 1).toString(), parts.get(i).toString());
            }
            RateType type = RateType.values()[Integer.valueOf((String)map.get("type"))];
            Long rateInterval = Long.valueOf((String)map.get("interval"));
            Long rate = Long.valueOf((String)map.get("rate"));
            return new RateLimiterConfig(type, rateInterval, rate);
        }
    }, RedisCommand.ValueType.MAP);

    public RedissonRateLimiter(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    String getPermitsName() {
        return RedissonRateLimiter.suffixName(this.getName(), "permits");
    }

    String getClientPermitsName() {
        return RedissonRateLimiter.suffixName(this.getPermitsName(), this.commandExecutor.getConnectionManager().getId());
    }

    String getValueName() {
        return RedissonRateLimiter.suffixName(this.getName(), "value");
    }

    String getClientValueName() {
        return RedissonRateLimiter.suffixName(this.getValueName(), this.commandExecutor.getConnectionManager().getId());
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1L);
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync() {
        return this.tryAcquireAsync(1L);
    }

    @Override
    public boolean tryAcquire(long permits) {
        return this.get(this.tryAcquireAsync(RedisCommands.EVAL_NULL_BOOLEAN, permits));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long permits) {
        return this.tryAcquireAsync(RedisCommands.EVAL_NULL_BOOLEAN, permits);
    }

    @Override
    public void acquire() {
        this.get(this.acquireAsync());
    }

    @Override
    public RFuture<Void> acquireAsync() {
        return this.acquireAsync(1L);
    }

    @Override
    public void acquire(long permits) {
        this.get(this.acquireAsync(permits));
    }

    @Override
    public RFuture<Void> acquireAsync(long permits) {
        RedissonPromise<Void> promise = new RedissonPromise<Void>();
        this.tryAcquireAsync(permits, -1L, null).onComplete((res, e) -> {
            if (e != null) {
                promise.tryFailure((Throwable)e);
                return;
            }
            promise.trySuccess(null);
        });
        return promise;
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return this.get(this.tryAcquireAsync(timeout, unit));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long timeout, TimeUnit unit) {
        return this.tryAcquireAsync(1L, timeout, unit);
    }

    @Override
    public boolean tryAcquire(long permits, long timeout, TimeUnit unit) {
        return this.get(this.tryAcquireAsync(permits, timeout, unit));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long permits, long timeout, TimeUnit unit) {
        RedissonPromise<Boolean> promise = new RedissonPromise<Boolean>();
        long timeoutInMillis = -1L;
        if (timeout >= 0L) {
            timeoutInMillis = unit.toMillis(timeout);
        }
        this.tryAcquireAsync(permits, promise, timeoutInMillis);
        return promise;
    }

    private void tryAcquireAsync(long permits, RPromise<Boolean> promise, long timeoutInMillis) {
        long s = System.currentTimeMillis();
        RFuture<Long> future = this.tryAcquireAsync(RedisCommands.EVAL_LONG, permits);
        future.onComplete((delay, e) -> {
            if (e != null) {
                promise.tryFailure((Throwable)e);
                return;
            }
            if (delay == null) {
                promise.trySuccess(true);
                return;
            }
            if (timeoutInMillis == -1L) {
                this.commandExecutor.getConnectionManager().getGroup().schedule(() -> this.tryAcquireAsync(permits, promise, timeoutInMillis), (long)delay, TimeUnit.MILLISECONDS);
                return;
            }
            long el = System.currentTimeMillis() - s;
            long remains = timeoutInMillis - el;
            if (remains <= 0L) {
                promise.trySuccess(false);
                return;
            }
            if (remains < delay) {
                this.commandExecutor.getConnectionManager().getGroup().schedule(() -> promise.trySuccess(false), remains, TimeUnit.MILLISECONDS);
            } else {
                long start = System.currentTimeMillis();
                this.commandExecutor.getConnectionManager().getGroup().schedule(() -> {
                    long elapsed = System.currentTimeMillis() - start;
                    if (remains <= elapsed) {
                        promise.trySuccess(false);
                        return;
                    }
                    this.tryAcquireAsync(permits, promise, remains - elapsed);
                }, (long)delay, TimeUnit.MILLISECONDS);
            }
        });
    }

    private <T> RFuture<T> tryAcquireAsync(RedisCommand<T> command, Long value) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, command, "local rate = redis.call('hget', KEYS[1], 'rate');local interval = redis.call('hget', KEYS[1], 'interval');local type = redis.call('hget', KEYS[1], 'type');assert(rate ~= false and interval ~= false and type ~= false, 'RateLimiter is not initialized')local valueName = KEYS[2];local permitsName = KEYS[4];if type == '1' then valueName = KEYS[3];permitsName = KEYS[5];end;local currentValue = redis.call('get', valueName); if currentValue ~= false then local expiredValues = redis.call('zrangebyscore', permitsName, 0, tonumber(ARGV[2]) - interval); local released = 0; for i, v in ipairs(expiredValues) do local random, permits = struct.unpack('fI', v);released = released + permits;end; if released > 0 then redis.call('zrem', permitsName, unpack(expiredValues)); currentValue = tonumber(currentValue) + released; redis.call('set', valueName, currentValue);end;if tonumber(currentValue) < tonumber(ARGV[1]) then local nearest = redis.call('zrangebyscore', permitsName, '(' .. (tonumber(ARGV[2]) - interval), tonumber(ARGV[2]), 'withscores', 'limit', 0, 1); local random, permits = struct.unpack('fI', nearest[1]);return tonumber(nearest[2]) - (tonumber(ARGV[2]) - interval);else redis.call('zadd', permitsName, ARGV[2], struct.pack('fI', ARGV[3], ARGV[1])); redis.call('decrby', valueName, ARGV[1]); return nil; end; else assert(tonumber(rate) >= tonumber(ARGV[1]), 'Requested permits amount could not exceed defined rate'); redis.call('set', valueName, rate); redis.call('zadd', permitsName, ARGV[2], struct.pack('fI', ARGV[3], ARGV[1])); redis.call('decrby', valueName, ARGV[1]); return nil; end;", Arrays.asList(this.getName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName()), value, System.currentTimeMillis(), ThreadLocalRandom.current().nextLong());
    }

    @Override
    public boolean trySetRate(RateType type, long rate, long rateInterval, RateIntervalUnit unit) {
        return this.get(this.trySetRateAsync(type, rate, rateInterval, unit));
    }

    @Override
    public RFuture<Boolean> trySetRateAsync(RateType type, long rate, long rateInterval, RateIntervalUnit unit) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('hsetnx', KEYS[1], 'rate', ARGV[1]);redis.call('hsetnx', KEYS[1], 'interval', ARGV[2]);return redis.call('hsetnx', KEYS[1], 'type', ARGV[3]);", Collections.singletonList(this.getName()), rate, unit.toMillis(rateInterval), type.ordinal());
    }

    @Override
    public RateLimiterConfig getConfig() {
        return this.get(this.getConfigAsync());
    }

    @Override
    public RFuture<RateLimiterConfig> getConfigAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, HGETALL, this.getName());
    }

    @Override
    public long availablePermits() {
        return this.get(this.availablePermitsAsync());
    }

    @Override
    public RFuture<Long> availablePermitsAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LONG, "local rate = redis.call('hget', KEYS[1], 'rate');local interval = redis.call('hget', KEYS[1], 'interval');local type = redis.call('hget', KEYS[1], 'type');assert(rate ~= false and interval ~= false and type ~= false, 'RateLimiter is not initialized')local valueName = KEYS[2];local permitsName = KEYS[4];if type == '1' then valueName = KEYS[3];permitsName = KEYS[5];end;local currentValue = redis.call('get', valueName); if currentValue == false then redis.call('set', valueName, rate); return rate; else local expiredValues = redis.call('zrangebyscore', permitsName, 0, tonumber(ARGV[1]) - interval); local released = 0; for i, v in ipairs(expiredValues) do local random, permits = struct.unpack('dI', v);released = released + permits;end; if released > 0 then redis.call('zrem', permitsName, unpack(expiredValues)); currentValue = tonumber(currentValue) + released; redis.call('set', valueName, currentValue);end;return currentValue; end;", Arrays.asList(this.getName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName()), System.currentTimeMillis());
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.expireAsync(timeToLive, timeUnit, this.getName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName());
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.expireAtAsync(timestamp, this.getName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName());
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName());
    }
}

