/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.redisson.misc.CompositeIterator;

public class CompositeIterable<T>
implements Iterable<T> {
    private List<Iterable<T>> iterablesList;
    private Iterable<T>[] iterables;

    public CompositeIterable(List<Iterable<T>> iterables) {
        this.iterablesList = iterables;
    }

    public CompositeIterable(Iterable<T> ... iterables) {
        this.iterables = iterables;
    }

    public CompositeIterable(CompositeIterable<T> iterable) {
        this.iterables = iterable.iterables;
        this.iterablesList = iterable.iterablesList;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList iterators = new ArrayList();
        if (this.iterables != null) {
            for (Iterable<T> iterable : this.iterables) {
                iterators.add(iterable.iterator());
            }
        } else {
            for (Iterable iterable : this.iterablesList) {
                iterators.add(iterable.iterator());
            }
        }
        Iterator listIterator = iterators.iterator();
        return new CompositeIterator(listIterator);
    }
}

