/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonObject;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

abstract class RedissonExpirable
extends RedissonObject
implements RExpirable {
    RedissonExpirable(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    RedissonExpirable(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public boolean expire(long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.get(this.expireAsync(timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIRE, this.getName(), timeUnit.toMillis(timeToLive));
    }

    @Override
    public boolean expireAt(long timestamp) {
        return this.commandExecutor.get(this.expireAtAsync(timestamp));
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIREAT, this.getName(), timestamp);
    }

    @Override
    public boolean expireAt(Date timestamp) {
        return this.expireAt(timestamp.getTime());
    }

    @Override
    public RFuture<Boolean> expireAtAsync(Date timestamp) {
        return this.expireAtAsync(timestamp.getTime());
    }

    @Override
    public boolean clearExpire() {
        return this.commandExecutor.get(this.clearExpireAsync());
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.PERSIST, this.getName());
    }

    @Override
    public long remainTimeToLive() {
        return this.commandExecutor.get(this.remainTimeToLiveAsync());
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.PTTL, this.getName());
    }

    protected RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String ... keys) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('pexpire', KEYS[1], ARGV[1]); return redis.call('pexpire', KEYS[2], ARGV[1]); ", Arrays.asList(keys), timeUnit.toMillis(timeToLive));
    }

    protected RFuture<Boolean> expireAtAsync(long timestamp, String ... keys) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('pexpireat', KEYS[1], ARGV[1]); return redis.call('pexpireat', KEYS[2], ARGV[1]); ", Arrays.asList(keys), timestamp);
    }

    protected RFuture<Boolean> clearExpireAsync(String ... keys) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('persist', KEYS[1]); return redis.call('persist', KEYS[2]); ", Arrays.asList(keys), new Object[0]);
    }
}

