/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.redisson.SlotCallback;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.RedissonRxClient;
import org.redisson.cache.LRUCacheMap;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisException;
import org.redisson.client.RedisRedirectException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.ReferenceCodecProvider;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.command.RedisExecutor;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandAsyncService
implements CommandAsyncExecutor {
    static final Logger log = LoggerFactory.getLogger(CommandAsyncService.class);
    final ConnectionManager connectionManager;
    protected RedissonObjectBuilder objectBuilder;
    private static final Map<String, String> SHA_CACHE = new LRUCacheMap<String, String>(500, 0L, 0L);

    public CommandAsyncService(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public CommandAsyncExecutor enableRedissonReferenceSupport(RedissonClient redisson) {
        this.enableRedissonReferenceSupport(redisson.getConfig(), redisson, null, null);
        return this;
    }

    @Override
    public CommandAsyncExecutor enableRedissonReferenceSupport(RedissonReactiveClient redissonReactive) {
        this.enableRedissonReferenceSupport(redissonReactive.getConfig(), null, redissonReactive, null);
        return this;
    }

    @Override
    public CommandAsyncExecutor enableRedissonReferenceSupport(RedissonRxClient redissonRx) {
        this.enableRedissonReferenceSupport(redissonRx.getConfig(), null, null, redissonRx);
        return this;
    }

    private void enableRedissonReferenceSupport(Config config, RedissonClient redisson, RedissonReactiveClient redissonReactive, RedissonRxClient redissonRx) {
        Codec codec = config.getCodec();
        this.objectBuilder = new RedissonObjectBuilder(config, redisson, redissonReactive, redissonRx);
        ReferenceCodecProvider codecProvider = this.objectBuilder.getReferenceCodecProvider();
        codecProvider.registerCodec(codec.getClass(), codec);
    }

    @Override
    public boolean isRedissonReferenceSupportEnabled() {
        return this.objectBuilder != null;
    }

    @Override
    public void syncSubscription(RFuture<?> future) {
        MasterSlaveServersConfig config = this.connectionManager.getConfig();
        try {
            int timeout = config.getTimeout() + config.getRetryInterval() * config.getRetryAttempts();
            if (!future.await(timeout)) {
                ((RPromise)future).tryFailure(new RedisTimeoutException("Subscribe timeout: (" + timeout + "ms). Increase 'subscriptionsPerConnection' and/or 'subscriptionConnectionPoolSize' parameters."));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        future.syncUninterruptibly();
    }

    @Override
    public void syncSubscriptionInterrupted(RFuture<?> future) throws InterruptedException {
        MasterSlaveServersConfig config = this.connectionManager.getConfig();
        int timeout = config.getTimeout() + config.getRetryInterval() * config.getRetryAttempts();
        if (!future.await(timeout)) {
            ((RPromise)future).tryFailure(new RedisTimeoutException("Subscribe timeout: (" + timeout + "ms). Increase 'subscriptionsPerConnection' and/or 'subscriptionConnectionPoolSize' parameters."));
        }
        future.sync();
    }

    @Override
    public <V> V get(RFuture<V> future) {
        try {
            future.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (future.isSuccess()) {
            return future.getNow();
        }
        throw this.convertException(future);
    }

    @Override
    public <V> V getInterrupted(RFuture<V> future) throws InterruptedException {
        try {
            future.await();
        }
        catch (InterruptedException e) {
            ((RPromise)future).tryFailure(e);
            throw e;
        }
        if (future.isSuccess()) {
            return future.getNow();
        }
        throw this.convertException(future);
    }

    protected <R> RPromise<R> createPromise() {
        return new RedissonPromise();
    }

    @Override
    public <T, R> RFuture<R> readAsync(RedisClient client, MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        this.async(true, new NodeSource(entry, client), codec, command, params, mainPromise, false);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(RedisClient client, String name, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        int slot = this.connectionManager.calcSlot(name);
        this.async(true, new NodeSource(slot, client), codec, command, params, mainPromise, false);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(RedisClient client, byte[] key, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        int slot = this.connectionManager.calcSlot(key);
        this.async(true, new NodeSource(slot, client), codec, command, params, mainPromise, false);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(RedisClient client, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        this.async(true, new NodeSource(client), codec, command, params, mainPromise, false);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<Collection<R>> readAllAsync(Codec codec, RedisCommand<T> command, Object ... params) {
        ArrayList results = new ArrayList();
        return this.readAllAsync(results, codec, command, params);
    }

    @Override
    public <T, R> RFuture<Collection<R>> readAllAsync(RedisCommand<T> command, Object ... params) {
        ArrayList results = new ArrayList();
        return this.readAllAsync(results, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> RFuture<Collection<R>> readAllAsync(final Collection<R> results, Codec codec, RedisCommand<T> command, Object ... params) {
        final RPromise<Collection<R>> mainPromise = this.createPromise();
        Collection<MasterSlaveEntry> nodes = this.connectionManager.getEntrySet();
        final AtomicInteger counter = new AtomicInteger(nodes.size());
        BiConsumer<Object, Throwable> listener = new BiConsumer<Object, Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Object result, Throwable u) {
                if (u != null && !(u instanceof RedisRedirectException)) {
                    mainPromise.tryFailure(u);
                    return;
                }
                if (result instanceof Collection) {
                    Collection collection = results;
                    synchronized (collection) {
                        results.addAll((Collection)result);
                    }
                }
                Collection collection = results;
                synchronized (collection) {
                    results.add(result);
                }
                if (counter.decrementAndGet() == 0 && !mainPromise.isDone()) {
                    mainPromise.trySuccess(results);
                }
            }
        };
        for (MasterSlaveEntry entry : nodes) {
            RedissonPromise promise = new RedissonPromise();
            promise.onComplete(listener);
            this.async(true, new NodeSource(entry), codec, command, params, promise, true);
        }
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readRandomAsync(Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        ArrayList<MasterSlaveEntry> nodes = new ArrayList<MasterSlaveEntry>(this.connectionManager.getEntrySet());
        Collections.shuffle(nodes);
        this.retryReadRandomAsync(codec, command, mainPromise, nodes, params);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readRandomAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        this.retryReadRandomAsync(codec, command, mainPromise, Collections.singletonList(entry), params);
        return mainPromise;
    }

    private <R, T> void retryReadRandomAsync(Codec codec, RedisCommand<T> command, RPromise<R> mainPromise, List<MasterSlaveEntry> nodes, Object ... params) {
        RedissonPromise attemptPromise = new RedissonPromise();
        attemptPromise.onComplete((res, e) -> {
            if (e == null) {
                if (res == null) {
                    if (nodes.isEmpty()) {
                        mainPromise.trySuccess(null);
                    } else {
                        this.retryReadRandomAsync(codec, command, mainPromise, nodes, params);
                    }
                } else {
                    mainPromise.trySuccess(res);
                }
            } else {
                mainPromise.tryFailure((Throwable)e);
            }
        });
        MasterSlaveEntry entry = nodes.remove(0);
        this.async(true, new NodeSource(entry), codec, command, params, attemptPromise, false);
    }

    @Override
    public <T> RFuture<Void> writeAllAsync(RedisCommand<T> command, Object ... params) {
        return this.writeAllAsync(command, null, params);
    }

    @Override
    public <R, T> RFuture<R> writeAllAsync(RedisCommand<T> command, SlotCallback<T, R> callback, Object ... params) {
        return this.allAsync(false, this.connectionManager.getCodec(), command, callback, params);
    }

    @Override
    public <R, T> RFuture<R> writeAllAsync(Codec codec, RedisCommand<T> command, SlotCallback<T, R> callback, Object ... params) {
        return this.allAsync(false, codec, command, callback, params);
    }

    @Override
    public <R, T> RFuture<R> readAllAsync(RedisCommand<T> command, SlotCallback<T, R> callback, Object ... params) {
        return this.allAsync(true, this.connectionManager.getCodec(), command, callback, params);
    }

    private <T, R> RFuture<R> allAsync(boolean readOnlyMode, Codec codec, final RedisCommand<T> command, final SlotCallback<T, R> callback, Object ... params) {
        final RedissonPromise mainPromise = new RedissonPromise();
        Collection<MasterSlaveEntry> nodes = this.connectionManager.getEntrySet();
        final AtomicInteger counter = new AtomicInteger(nodes.size());
        BiConsumer listener = new BiConsumer<T, Throwable>(){

            @Override
            public void accept(T result, Throwable u) {
                if (u != null && !(u instanceof RedisRedirectException)) {
                    mainPromise.tryFailure(u);
                    return;
                }
                if (u instanceof RedisRedirectException) {
                    result = command.getConvertor().convert(result);
                }
                if (callback != null) {
                    callback.onSlotResult(result);
                }
                if (counter.decrementAndGet() == 0) {
                    if (callback != null) {
                        mainPromise.trySuccess(callback.onFinish());
                    } else {
                        mainPromise.trySuccess(null);
                    }
                }
            }
        };
        for (MasterSlaveEntry entry : nodes) {
            RedissonPromise promise = new RedissonPromise();
            promise.onComplete(listener);
            this.async(readOnlyMode, new NodeSource(entry), codec, command, params, promise, true);
        }
        return mainPromise;
    }

    @Override
    public <V> RedisException convertException(RFuture<V> future) {
        if (future.cause() instanceof RedisException) {
            return (RedisException)future.cause();
        }
        return new RedisException("Unexpected exception while processing command", future.cause());
    }

    private NodeSource getNodeSource(String key) {
        int slot = this.connectionManager.calcSlot(key);
        return new NodeSource(slot);
    }

    private NodeSource getNodeSource(byte[] key) {
        int slot = this.connectionManager.calcSlot(key);
        return new NodeSource(slot);
    }

    @Override
    public <T, R> RFuture<R> readAsync(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        NodeSource source = this.getNodeSource(key);
        this.async(true, source, codec, command, params, mainPromise, false);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(byte[] key, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        NodeSource source = this.getNodeSource(key);
        this.async(true, source, codec, command, params, mainPromise, false);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        this.async(true, new NodeSource(entry), codec, command, params, mainPromise, false);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> writeAsync(RedisClient client, Codec codec, RedisCommand<T> command, Object ... params) {
        MasterSlaveEntry entry = this.getConnectionManager().getEntry(client);
        return this.writeAsync(entry, codec, command, params);
    }

    @Override
    public <T, R> RFuture<R> writeAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        this.async(false, new NodeSource(entry), codec, command, params, mainPromise, false);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(String key, RedisCommand<T> command, Object ... params) {
        return this.readAsync(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.evalAsync(source, true, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(new NodeSource(entry), true, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(RedisClient client, String name, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        int slot = this.connectionManager.calcSlot(name);
        return this.evalAsync(new NodeSource(slot, client), true, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.evalAsync(source, false, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(new NodeSource(entry), false, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAllAsync(RedisCommand<T> command, SlotCallback<T, R> callback, String script, List<Object> keys, Object ... params) {
        return this.evalAllAsync(false, command, callback, script, keys, params);
    }

    public <T, R> RFuture<R> evalAllAsync(boolean readOnlyMode, RedisCommand<T> command, final SlotCallback<T, R> callback, String script, List<Object> keys, Object ... params) {
        final RedissonPromise mainPromise = new RedissonPromise();
        Collection<MasterSlaveEntry> entries = this.connectionManager.getEntrySet();
        final AtomicInteger counter = new AtomicInteger(entries.size());
        BiConsumer listener = new BiConsumer<T, Throwable>(){

            @Override
            public void accept(T t, Throwable u) {
                if (u != null && !(u instanceof RedisRedirectException)) {
                    mainPromise.tryFailure(u);
                    return;
                }
                callback.onSlotResult(t);
                if (counter.decrementAndGet() == 0 && !mainPromise.isDone()) {
                    mainPromise.trySuccess(callback.onFinish());
                }
            }
        };
        ArrayList<Object> args = new ArrayList<Object>(2 + keys.size() + params.length);
        args.add(script);
        args.add(keys.size());
        args.addAll(keys);
        args.addAll(Arrays.asList(params));
        for (MasterSlaveEntry entry : entries) {
            RedissonPromise promise = new RedissonPromise();
            promise.onComplete(listener);
            this.async(readOnlyMode, new NodeSource(entry), this.connectionManager.getCodec(), command, args.toArray(), promise, true);
        }
        return mainPromise;
    }

    private RFuture<String> loadScript(List<Object> keys, String script) {
        if (!keys.isEmpty()) {
            Object key = keys.get(0);
            if (key instanceof byte[]) {
                return this.writeAsync((byte[])key, (Codec)StringCodec.INSTANCE, RedisCommands.SCRIPT_LOAD, script);
            }
            return this.writeAsync((String)key, (Codec)StringCodec.INSTANCE, RedisCommands.SCRIPT_LOAD, script);
        }
        return this.writeAllAsync(RedisCommands.SCRIPT_LOAD, new SlotCallback<String, String>(){
            volatile String result;

            @Override
            public void onSlotResult(String result) {
                this.result = result;
            }

            @Override
            public String onFinish() {
                return this.result;
            }
        }, script);
    }

    protected boolean isEvalCacheActive() {
        return this.getConnectionManager().getCfg().isUseScriptCache();
    }

    private String calcSHA(String script) {
        String digest = SHA_CACHE.get(script);
        if (digest == null) {
            try {
                MessageDigest mdigest = MessageDigest.getInstance("SHA-1");
                byte[] s = mdigest.digest(script.getBytes());
                digest = ByteBufUtil.hexDump(s);
                SHA_CACHE.put(script, digest);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return digest;
    }

    private Object[] copy(Object[] params) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : params) {
            if (object instanceof ByteBuf) {
                ByteBuf b = (ByteBuf)object;
                ByteBuf nb = ByteBufAllocator.DEFAULT.buffer(b.readableBytes());
                int ri = b.readerIndex();
                nb.writeBytes(b);
                b.readerIndex(ri);
                result.add(nb);
                continue;
            }
            result.add(object);
        }
        return result.toArray();
    }

    private <T, R> RFuture<R> evalAsync(NodeSource nodeSource, boolean readOnlyMode, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        if (this.isEvalCacheActive() && evalCommandType.getName().equals("EVAL")) {
            RedissonPromise mainPromise = new RedissonPromise();
            Object[] pps = this.copy(params);
            RedissonPromise promise = new RedissonPromise();
            String sha1 = this.calcSHA(script);
            RedisCommand<T> cmd = new RedisCommand<T>(evalCommandType, "EVALSHA");
            ArrayList<Object> args = new ArrayList<Object>(2 + keys.size() + params.length);
            args.add(sha1);
            args.add(keys.size());
            args.addAll(keys);
            args.addAll(Arrays.asList(params));
            this.async(false, nodeSource, codec, cmd, args.toArray(), promise, false);
            promise.onComplete((res, e) -> {
                if (e != null) {
                    if (e.getMessage().startsWith("NOSCRIPT")) {
                        RFuture<String> loadFuture = this.loadScript(keys, script);
                        loadFuture.onComplete((r, ex) -> {
                            if (ex != null) {
                                this.free(pps);
                                mainPromise.tryFailure((Throwable)ex);
                                return;
                            }
                            RedisCommand command = new RedisCommand(evalCommandType, "EVALSHA");
                            ArrayList<Object> newargs = new ArrayList<Object>(2 + keys.size() + params.length);
                            newargs.add(sha1);
                            newargs.add(keys.size());
                            newargs.addAll(keys);
                            newargs.addAll(Arrays.asList(pps));
                            this.async(false, nodeSource, codec, command, newargs.toArray(), mainPromise, false);
                        });
                    } else {
                        this.free(pps);
                        mainPromise.tryFailure((Throwable)e);
                    }
                    return;
                }
                this.free(pps);
                mainPromise.trySuccess(res);
            });
            return mainPromise;
        }
        RPromise<R> mainPromise = this.createPromise();
        ArrayList<Object> args = new ArrayList<Object>(2 + keys.size() + params.length);
        args.add(script);
        args.add(keys.size());
        args.addAll(keys);
        args.addAll(Arrays.asList(params));
        this.async(readOnlyMode, nodeSource, codec, evalCommandType, args.toArray(), mainPromise, false);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> writeAsync(String key, RedisCommand<T> command, Object ... params) {
        return this.writeAsync(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> RFuture<R> writeAsync(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        NodeSource source = this.getNodeSource(key);
        this.async(false, source, codec, command, params, mainPromise, false);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> writeAsync(byte[] key, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise<R> mainPromise = this.createPromise();
        NodeSource source = this.getNodeSource(key);
        this.async(false, source, codec, command, params, mainPromise, false);
        return mainPromise;
    }

    public <V, R> void async(boolean readOnlyMode, NodeSource source, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, boolean ignoreRedirect) {
        RedisExecutor<V, R> executor = new RedisExecutor<V, R>(readOnlyMode, source, codec, command, params, mainPromise, ignoreRedirect, this.connectionManager, this.objectBuilder);
        executor.execute();
    }

    private void free(Object[] params) {
        for (Object obj : params) {
            ReferenceCountUtil.safeRelease(obj);
        }
    }

    @Override
    public <T, R> RFuture<R> readBatchedAsync(Codec codec, RedisCommand<T> command, SlotCallback<T, R> callback, String ... keys) {
        return this.executeBatchedAsync(true, codec, command, callback, keys);
    }

    @Override
    public <T, R> RFuture<R> writeBatchedAsync(Codec codec, RedisCommand<T> command, SlotCallback<T, R> callback, String ... keys) {
        return this.executeBatchedAsync(false, codec, command, callback, keys);
    }

    private <T, R> RFuture<R> executeBatchedAsync(boolean readOnly, Codec codec, RedisCommand<T> command, SlotCallback<T, R> callback, String ... keys) {
        if (!this.connectionManager.isClusterMode()) {
            if (readOnly) {
                return this.readAsync((String)null, codec, command, (Object[])keys);
            }
            return this.writeAsync((String)null, codec, command, (Object[])keys);
        }
        HashMap<MasterSlaveEntry, ArrayList<String>> range2key = new HashMap<MasterSlaveEntry, ArrayList<String>>();
        for (String key : keys) {
            int slot = this.connectionManager.calcSlot(key);
            MasterSlaveEntry masterSlaveEntry = this.connectionManager.getEntry(slot);
            ArrayList<String> list = (ArrayList<String>)range2key.get(masterSlaveEntry);
            if (list == null) {
                list = new ArrayList<String>();
                range2key.put(masterSlaveEntry, list);
            }
            list.add(key);
        }
        RedissonPromise result = new RedissonPromise();
        AtomicReference failed = new AtomicReference();
        AtomicLong executed = new AtomicLong(range2key.size());
        BiConsumer<BatchResult, Throwable> listener = (t, u) -> {
            if (u == null) {
                for (Object res : t.getResponses()) {
                    if (res == null) continue;
                    callback.onSlotResult(res);
                }
            } else {
                failed.set(u);
            }
            if (executed.decrementAndGet() == 0L) {
                if (failed.get() != null) {
                    result.tryFailure((Throwable)failed.get());
                } else {
                    result.trySuccess(callback.onFinish());
                }
            }
        };
        for (Map.Entry entry : range2key.entrySet()) {
            CommandBatchService executorService = new CommandBatchService(this.connectionManager);
            for (String key : (List)entry.getValue()) {
                RedisCommand<T> c = command;
                RedisCommand<T> newCommand = callback.createCommand(key);
                if (newCommand != null) {
                    c = newCommand;
                }
                if (readOnly) {
                    executorService.readAsync((MasterSlaveEntry)entry.getKey(), codec, c, key);
                    continue;
                }
                executorService.writeAsync((MasterSlaveEntry)entry.getKey(), codec, c, key);
            }
            RFuture<BatchResult<?>> future = executorService.executeAsync();
            future.onComplete(listener);
        }
        return result;
    }

    @Override
    public RedissonObjectBuilder getObjectBuilder() {
        return this.objectBuilder;
    }

    @Override
    public <V> RFuture<V> pollFromAnyAsync(String name, Codec codec, RedisCommand<Object> command, long secondsTimeout, String ... queueNames) {
        if (this.connectionManager.isClusterMode() && queueNames.length > 0) {
            RedissonPromise result = new RedissonPromise();
            AtomicReference<Iterator<String>> ref = new AtomicReference<Iterator<String>>();
            ArrayList<String> names = new ArrayList<String>();
            names.add(name);
            names.addAll(Arrays.asList(queueNames));
            ref.set(names.iterator());
            AtomicLong counter = new AtomicLong(secondsTimeout);
            this.poll(name, codec, result, ref, names, counter, command);
            return result;
        }
        ArrayList<Object> params = new ArrayList<Object>(queueNames.length + 1);
        params.add(name);
        for (String queueName : queueNames) {
            params.add(queueName);
        }
        params.add(secondsTimeout);
        return this.writeAsync(name, codec, command, params.toArray());
    }

    private <V> void poll(String name, Codec codec, RPromise<V> result, AtomicReference<Iterator<String>> ref, List<String> names, AtomicLong counter, RedisCommand<Object> command) {
        if (ref.get().hasNext()) {
            String currentName = ref.get().next().toString();
            RFuture future = this.writeAsync(currentName, codec, command, currentName, 1);
            future.onComplete((res, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)e);
                    return;
                }
                if (res != null) {
                    result.trySuccess(res);
                } else {
                    if (counter.decrementAndGet() == 0L) {
                        result.trySuccess(null);
                        return;
                    }
                    this.poll(name, codec, result, ref, names, counter, command);
                }
            });
        } else {
            ref.set(names.iterator());
            this.poll(name, codec, result, ref, names, counter, command);
        }
    }
}

