/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.session;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RBatch;
import org.redisson.api.RMap;
import org.redisson.api.RPatternTopic;
import org.redisson.api.RSet;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.PatternMessageListener;
import org.redisson.client.codec.StringCodec;
import org.redisson.codec.CompositeCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.springframework.util.StringUtils;

public class RedissonSessionRepository
implements FindByIndexNameSessionRepository<RedissonSession>,
PatternMessageListener<String> {
    static final String SESSION_ATTR_PREFIX = "session-attr:";
    private static final Logger log = LoggerFactory.getLogger(RedissonSessionRepository.class);
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    private static final SpelExpressionParser SPEL_PARSER = new SpelExpressionParser();
    private RedissonClient redisson;
    private ApplicationEventPublisher eventPublisher;
    private RPatternTopic deletedTopic;
    private RPatternTopic expiredTopic;
    private RPatternTopic createdTopic;
    private String keyPrefix = "spring:session:";
    private Integer defaultMaxInactiveInterval;

    public RedissonSessionRepository(RedissonClient redissonClient, ApplicationEventPublisher eventPublisher, String keyPrefix) {
        this.redisson = redissonClient;
        this.eventPublisher = eventPublisher;
        if (StringUtils.hasText((String)keyPrefix)) {
            this.keyPrefix = keyPrefix;
        }
        this.deletedTopic = this.redisson.getPatternTopic("__keyevent@*:del", StringCodec.INSTANCE);
        this.expiredTopic = this.redisson.getPatternTopic("__keyevent@*:expired", StringCodec.INSTANCE);
        this.createdTopic = this.redisson.getPatternTopic(this.getEventsChannelPrefix() + "*", StringCodec.INSTANCE);
        this.deletedTopic.addListener(String.class, this);
        this.expiredTopic.addListener(String.class, this);
        this.createdTopic.addListener(String.class, this);
    }

    public RedissonSessionRepository(RedissonClient redissonClient, ApplicationEventPublisher eventPublisher) {
        this(redissonClient, eventPublisher, null);
    }

    private MapSession loadSession(String sessionId) {
        RMap map = this.redisson.getMap(this.keyPrefix + sessionId, new CompositeCodec(StringCodec.INSTANCE, this.redisson.getConfig().getCodec()));
        Set entrySet = map.readAllEntrySet();
        if (entrySet.isEmpty()) {
            return null;
        }
        MapSession delegate = new MapSession(sessionId);
        for (Map.Entry entry : entrySet) {
            if ("session:creationTime".equals(entry.getKey())) {
                delegate.setCreationTime(Instant.ofEpochMilli((Long)entry.getValue()));
                continue;
            }
            if ("session:lastAccessedTime".equals(entry.getKey())) {
                delegate.setLastAccessedTime(Instant.ofEpochMilli((Long)entry.getValue()));
                continue;
            }
            if ("session:maxInactiveInterval".equals(entry.getKey())) {
                delegate.setMaxInactiveInterval(Duration.ofSeconds((Long)entry.getValue()));
                continue;
            }
            if (!((String)entry.getKey()).startsWith(SESSION_ATTR_PREFIX)) continue;
            delegate.setAttribute(((String)entry.getKey()).substring(SESSION_ATTR_PREFIX.length()), entry.getValue());
        }
        return delegate;
    }

    @Override
    public void onMessage(CharSequence pattern, CharSequence channel, String body) {
        if (this.createdTopic.getPatternNames().contains(pattern.toString())) {
            RedissonSession session = this.findById(body);
            if (session != null) {
                this.publishEvent((ApplicationEvent)new SessionCreatedEvent((Object)this, (Session)session));
            }
        } else if (this.deletedTopic.getPatternNames().contains(pattern.toString())) {
            if (!body.startsWith(this.getExpiredKeyPrefix())) {
                return;
            }
            String id = body.split(this.getExpiredKeyPrefix())[1];
            MapSession mapSession = this.loadSession(id);
            if (mapSession != null) {
                RedissonSession session = new RedissonSession(mapSession);
                session.clearPrincipal();
                this.publishEvent((ApplicationEvent)new SessionDeletedEvent((Object)this, (Session)session));
            }
        } else if (this.expiredTopic.getPatternNames().contains(pattern.toString())) {
            if (!body.startsWith(this.getExpiredKeyPrefix())) {
                return;
            }
            String id = body.split(this.getExpiredKeyPrefix())[1];
            MapSession mapSession = this.loadSession(id);
            if (mapSession != null) {
                RedissonSession session = new RedissonSession(mapSession);
                session.clearPrincipal();
                this.publishEvent((ApplicationEvent)new SessionExpiredEvent((Object)this, (Session)session));
            }
        }
    }

    private void publishEvent(ApplicationEvent event) {
        try {
            this.eventPublisher.publishEvent(event);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    public void setDefaultMaxInactiveInterval(int defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public RedissonSession createSession() {
        RedissonSession session = new RedissonSession();
        if (this.defaultMaxInactiveInterval != null) {
            session.setMaxInactiveInterval(Duration.ofSeconds(this.defaultMaxInactiveInterval.intValue()));
        }
        return session;
    }

    public void save(RedissonSession session) {
    }

    public RedissonSession findById(String id) {
        MapSession mapSession = this.loadSession(id);
        if (mapSession == null || mapSession.isExpired()) {
            return null;
        }
        return new RedissonSession(mapSession);
    }

    public void deleteById(String id) {
        RedissonSession session = this.findById(id);
        if (session == null) {
            return;
        }
        this.redisson.getBucket(this.getExpiredKey(id)).delete();
        session.clearPrincipal();
        session.setMaxInactiveInterval(Duration.ZERO);
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    String resolvePrincipal(Session session) {
        String principalName = (String)session.getAttribute(PRINCIPAL_NAME_INDEX_NAME);
        if (principalName != null) {
            return principalName;
        }
        Object auth = session.getAttribute(SPRING_SECURITY_CONTEXT);
        if (auth == null) {
            return null;
        }
        Expression expression = SPEL_PARSER.parseExpression("authentication?.name");
        return (String)expression.getValue(auth, String.class);
    }

    String getEventsChannelName(String sessionId) {
        return this.getEventsChannelPrefix() + sessionId;
    }

    String getExpiredKey(String sessionId) {
        return this.getExpiredKeyPrefix() + sessionId;
    }

    String getExpiredKeyPrefix() {
        return this.keyPrefix + "sessions:expires:";
    }

    String getEventsChannelPrefix() {
        return this.keyPrefix + "created:event:";
    }

    String getPrincipalKey(String principalName) {
        return this.keyPrefix + "index:" + FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME + ":" + principalName;
    }

    String getSessionAttrNameKey(String name) {
        return SESSION_ATTR_PREFIX + name;
    }

    public Map<String, RedissonSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        RSet<String> set = this.getPrincipalSet(indexValue);
        Set<String> sessionIds = set.readAll();
        HashMap<String, RedissonSession> result = new HashMap<String, RedissonSession>();
        for (String id : sessionIds) {
            RedissonSession session = this.findById(id);
            if (session == null) continue;
            result.put(id, session);
        }
        return result;
    }

    private RSet<String> getPrincipalSet(String indexValue) {
        String principalKey = this.getPrincipalKey(indexValue);
        return this.redisson.getSet(principalKey, StringCodec.INSTANCE);
    }

    final class RedissonSession
    implements Session {
        private String principalName;
        private final MapSession delegate;
        private RMap<String, Object> map;

        RedissonSession() {
            this.delegate = new MapSession();
            this.map = RedissonSessionRepository.this.redisson.getMap(RedissonSessionRepository.this.keyPrefix + this.delegate.getId(), new CompositeCodec(StringCodec.INSTANCE, RedissonSessionRepository.this.redisson.getConfig().getCodec()));
            HashMap<String, Long> newMap = new HashMap<String, Long>(3);
            newMap.put("session:creationTime", this.delegate.getCreationTime().toEpochMilli());
            newMap.put("session:lastAccessedTime", this.delegate.getLastAccessedTime().toEpochMilli());
            newMap.put("session:maxInactiveInterval", this.delegate.getMaxInactiveInterval().getSeconds());
            this.map.putAll(newMap);
            this.updateExpiration();
            String channelName = RedissonSessionRepository.this.getEventsChannelName(this.delegate.getId());
            RTopic topic = RedissonSessionRepository.this.redisson.getTopic(channelName, StringCodec.INSTANCE);
            topic.publish(this.delegate.getId());
        }

        private void updateExpiration() {
            if (this.delegate.getMaxInactiveInterval().getSeconds() > 0L) {
                RedissonSessionRepository.this.redisson.getBucket(RedissonSessionRepository.this.getExpiredKey(this.delegate.getId())).set("", this.delegate.getMaxInactiveInterval().getSeconds(), TimeUnit.SECONDS);
                this.map.expire(this.delegate.getMaxInactiveInterval().getSeconds() + 60L, TimeUnit.SECONDS);
            }
        }

        RedissonSession(MapSession session) {
            this.delegate = session;
            this.map = RedissonSessionRepository.this.redisson.getMap(RedissonSessionRepository.this.keyPrefix + session.getId(), new CompositeCodec(StringCodec.INSTANCE, RedissonSessionRepository.this.redisson.getConfig().getCodec()));
            this.principalName = RedissonSessionRepository.this.resolvePrincipal(this);
        }

        public String getId() {
            return this.delegate.getId();
        }

        public <T> T getAttribute(String attributeName) {
            return (T)this.delegate.getAttribute(attributeName);
        }

        public Set<String> getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            if (attributeValue == null) {
                this.removeAttribute(attributeName);
                return;
            }
            this.delegate.setAttribute(attributeName, attributeValue);
            if (this.map != null) {
                this.map.fastPut(RedissonSessionRepository.this.getSessionAttrNameKey(attributeName), attributeValue);
                if (attributeName.equals(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME) || attributeName.equals(RedissonSessionRepository.SPRING_SECURITY_CONTEXT)) {
                    RSet set;
                    if (this.principalName != null) {
                        set = RedissonSessionRepository.this.getPrincipalSet(this.principalName);
                        set.remove(this.getId());
                    }
                    this.principalName = RedissonSessionRepository.this.resolvePrincipal(this);
                    if (this.principalName != null) {
                        set = RedissonSessionRepository.this.getPrincipalSet(this.principalName);
                        set.add(this.getId());
                    }
                }
            }
        }

        public void clearPrincipal() {
            this.principalName = RedissonSessionRepository.this.resolvePrincipal(this);
            if (this.principalName != null) {
                RSet set = RedissonSessionRepository.this.getPrincipalSet(this.principalName);
                set.remove(this.getId());
            }
        }

        public void removeAttribute(String attributeName) {
            this.delegate.removeAttribute(attributeName);
            if (this.map != null) {
                this.map.fastRemove((String[])new String[]{RedissonSessionRepository.this.getSessionAttrNameKey(attributeName)});
            }
        }

        public Instant getCreationTime() {
            return this.delegate.getCreationTime();
        }

        public void setLastAccessedTime(Instant lastAccessedTime) {
            this.delegate.setLastAccessedTime(lastAccessedTime);
            if (this.map != null) {
                this.map.fastPut("session:lastAccessedTime", lastAccessedTime.toEpochMilli());
                this.updateExpiration();
            }
        }

        public Instant getLastAccessedTime() {
            return this.delegate.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(Duration interval) {
            this.delegate.setMaxInactiveInterval(interval);
            if (this.map != null) {
                this.map.fastPut("session:maxInactiveInterval", interval.getSeconds());
                this.updateExpiration();
            }
        }

        public Duration getMaxInactiveInterval() {
            return this.delegate.getMaxInactiveInterval();
        }

        public boolean isExpired() {
            return this.delegate.isExpired();
        }

        public String changeSessionId() {
            String oldId = this.delegate.getId();
            String id = this.delegate.changeSessionId();
            RBatch batch = RedissonSessionRepository.this.redisson.createBatch(BatchOptions.defaults());
            batch.getBucket(RedissonSessionRepository.this.getExpiredKey(oldId)).remainTimeToLiveAsync();
            batch.getBucket(RedissonSessionRepository.this.getExpiredKey(oldId)).deleteAsync();
            batch.getMap(this.map.getName(), this.map.getCodec()).readAllMapAsync();
            batch.getMap(this.map.getName()).deleteAsync();
            BatchResult<?> res = batch.execute();
            List<?> list = res.getResponses();
            Long remainTTL = (Long)list.get(0);
            Map oldState = (Map)list.get(2);
            if (remainTTL == -2L) {
                remainTTL = this.delegate.getMaxInactiveInterval().toMillis();
            }
            RBatch batchNew = RedissonSessionRepository.this.redisson.createBatch();
            batchNew.getMap(RedissonSessionRepository.this.keyPrefix + id, this.map.getCodec()).putAllAsync(oldState);
            if (remainTTL > 0L) {
                batchNew.getBucket(RedissonSessionRepository.this.getExpiredKey(id)).setAsync("", remainTTL, TimeUnit.MILLISECONDS);
            }
            batchNew.execute();
            this.map = RedissonSessionRepository.this.redisson.getMap(RedissonSessionRepository.this.keyPrefix + id, this.map.getCodec());
            return id;
        }
    }
}

