/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RTimeSeries;
import org.redisson.api.TimeSeriesEntry;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.TimeSeriesEntryReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.iterator.RedissonBaseIterator;
import org.redisson.misc.RedissonPromise;

public class RedissonTimeSeries<V>
extends RedissonExpirable
implements RTimeSeries<V> {
    private EvictionScheduler evictionScheduler;
    private static final RedisCommand<List<TimeSeriesEntry<Object>>> ENTRIES = new RedisCommand("EVAL", new TimeSeriesEntryReplayDecoder());

    public RedissonTimeSeries(EvictionScheduler evictionScheduler, CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
        if (evictionScheduler != null) {
            evictionScheduler.scheduleTimeSeries(this.getName(), this.getTimeoutSetName());
        }
    }

    public RedissonTimeSeries(Codec codec, EvictionScheduler evictionScheduler, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
        if (evictionScheduler != null) {
            evictionScheduler.scheduleTimeSeries(this.getName(), this.getTimeoutSetName());
        }
    }

    String getTimeoutSetName() {
        return RedissonTimeSeries.prefixName("redisson__ts_ttl", this.name);
    }

    @Override
    public void add(long timestamp, V value) {
        this.addAll(Collections.singletonMap(timestamp, value));
    }

    @Override
    public RFuture<Void> addAsync(long timestamp, V object) {
        return this.addAllAsync(Collections.singletonMap(timestamp, object));
    }

    @Override
    public void addAll(Map<Long, V> objects) {
        this.addAll(objects, 0L, null);
    }

    @Override
    public void add(long timestamp, V value, long timeToLive, TimeUnit timeUnit) {
        this.addAll(Collections.singletonMap(timestamp, value), timeToLive, timeUnit);
    }

    @Override
    public RFuture<Void> addAsync(long timestamp, V object, long timeToLive, TimeUnit timeUnit) {
        return this.addAllAsync(Collections.singletonMap(timestamp, object), timeToLive, timeUnit);
    }

    @Override
    public void addAll(Map<Long, V> objects, long timeToLive, TimeUnit timeUnit) {
        this.get(this.addAllAsync(objects, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> addAllAsync(Map<Long, V> objects) {
        return this.addAllAsync(objects, 0L, null);
    }

    @Override
    public RFuture<Void> addAllAsync(Map<Long, V> objects, long timeToLive, TimeUnit timeUnit) {
        long expirationTime = 92233720368547758L;
        if (timeToLive > 0L) {
            expirationTime = System.currentTimeMillis() + timeUnit.toMillis(timeToLive);
        }
        ArrayList<Comparable<Long>> params = new ArrayList<Comparable<Long>>();
        for (Map.Entry<Long, V> entry : objects.entrySet()) {
            params.add(Long.valueOf(expirationTime));
            params.add(entry.getKey());
            params.add(this.encode((Object)entry.getValue()));
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_VOID, "for i = 1, #ARGV, 3 do local val = struct.pack('LLc0', tonumber(ARGV[i+1]), string.len(ARGV[i+2]), ARGV[i+2]); redis.call('zadd', KEYS[1], ARGV[i+1], val); redis.call('zadd', KEYS[2], ARGV[i], val); end; ", Arrays.asList(this.getName(), this.getTimeoutSetName()), params.toArray());
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local values = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1]);return redis.call('zcard', KEYS[1]) - #values;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis());
    }

    @Override
    public V get(long timestamp) {
        return this.get(this.getAsync(timestamp));
    }

    @Override
    public RFuture<V> getAsync(long timestamp) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[2], ARGV[2]);if #values == 0 then return nil;end;local expirationDate = redis.call('zscore', KEYS[2], values[1]); if expirationDate ~= false and tonumber(expirationDate) <= tonumber(ARGV[1]) then return nil;end;local t, val = struct.unpack('LLc0', values[1]); return val;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), timestamp);
    }

    @Override
    public boolean remove(long timestamp) {
        return this.get(this.removeAsync(timestamp));
    }

    @Override
    public RFuture<Boolean> removeAsync(long timestamp) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[2], ARGV[2]);if #values == 0 then return 0;end;local expirationDate = redis.call('zscore', KEYS[2], values[1]); if expirationDate ~= false and tonumber(expirationDate) <= tonumber(ARGV[1]) then return 0;end;redis.call('zrem', KEYS[2], values[1]); redis.call('zrem', KEYS[1], values[1]); return 1;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), timestamp);
    }

    @Override
    public V last() {
        return this.get(this.lastAsync());
    }

    @Override
    public RFuture<V> lastAsync() {
        return this.listAsync(-1, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    @Override
    public RFuture<Collection<V>> lastAsync(int count) {
        return this.listAsync(-1, count, RedisCommands.EVAL_LIST);
    }

    @Override
    public V first() {
        return this.get(this.firstAsync());
    }

    @Override
    public RFuture<V> firstAsync() {
        return this.listAsync(0, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    @Override
    public RFuture<Collection<V>> firstAsync(int count) {
        return this.listAsync(0, count, RedisCommands.EVAL_LIST);
    }

    @Override
    public Collection<V> first(int count) {
        return (Collection)this.get(this.listAsync(0, count, RedisCommands.EVAL_LIST));
    }

    @Override
    public Collection<V> last(int count) {
        return (Collection)this.get(this.listAsync(-1, count, RedisCommands.EVAL_LIST_REVERSE));
    }

    @Override
    public Long firstTimestamp() {
        return this.get(this.firstTimestampAsync());
    }

    @Override
    public RFuture<Long> firstTimestampAsync() {
        return this.listTimestampAsync(0, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    @Override
    public Long lastTimestamp() {
        return this.get(this.lastTimestampAsync());
    }

    @Override
    public RFuture<Long> lastTimestampAsync() {
        return this.listTimestampAsync(-1, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    private <T> RFuture<T> listTimestampAsync(int startScore, int limit, RedisCommand<?> evalCommandType) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, evalCommandType, "local values;if ARGV[2] == '0' then values = redis.call('zrangebyscore', KEYS[2], ARGV[1], '+inf', 'limit', 0, ARGV[3]);else values = redis.call('zrevrangebyscore', KEYS[2], '+inf', ARGV[1], 'limit', 0, ARGV[3]);end; local result = {}; for i, v in ipairs(values) do local t, val = struct.unpack('LLc0', v); table.insert(result, t);end;return result;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), startScore, limit);
    }

    private <T> RFuture<T> listAsync(int startScore, int limit, RedisCommand<?> evalCommandType) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, evalCommandType, "local values;if ARGV[2] == '0' then values = redis.call('zrangebyscore', KEYS[2], ARGV[1], '+inf', 'limit', 0, ARGV[3]);else values = redis.call('zrevrangebyscore', KEYS[2], '+inf', ARGV[1], 'limit', 0, ARGV[3]);end; local result = {}; for i, v in ipairs(values) do local t, val = struct.unpack('LLc0', v); table.insert(result, val);end;return result;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), startScore, limit);
    }

    @Override
    public int removeRange(long startTimestamp, long endTimestamp) {
        return this.get(this.removeRangeAsync(startTimestamp, endTimestamp));
    }

    @Override
    public RFuture<Integer> removeRangeAsync(long startTimestamp, long endTimestamp) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[2], ARGV[3]);if #values == 0 then return nil;end;local counter = 0; for i, v in ipairs(values) do local expirationDate = redis.call('zscore', KEYS[2], v); if tonumber(expirationDate) > tonumber(ARGV[1]) then local t, val = struct.unpack('LLc0', v); counter = counter + 1; redis.call('zrem', KEYS[2], v); redis.call('zrem', KEYS[1], v); end;end;return counter;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), startTimestamp, endTimestamp);
    }

    @Override
    public Collection<V> range(long startTimestamp, long endTimestamp) {
        return this.get(this.rangeAsync(startTimestamp, endTimestamp));
    }

    @Override
    public Collection<TimeSeriesEntry<V>> entryRange(long startTimestamp, long endTimestamp) {
        return this.get(this.entryRangeAsync(false, startTimestamp, endTimestamp));
    }

    @Override
    public Collection<TimeSeriesEntry<V>> entryRangeReversed(long startTimestamp, long endTimestamp) {
        return this.get(this.entryRangeAsync(true, startTimestamp, endTimestamp));
    }

    @Override
    public RFuture<Collection<TimeSeriesEntry<V>>> entryRangeReversedAsync(long startTimestamp, long endTimestamp) {
        return this.entryRangeAsync(true, startTimestamp, endTimestamp);
    }

    @Override
    public RFuture<Collection<TimeSeriesEntry<V>>> entryRangeAsync(long startTimestamp, long endTimestamp) {
        return this.entryRangeAsync(false, startTimestamp, endTimestamp);
    }

    public RFuture<Collection<TimeSeriesEntry<V>>> entryRangeAsync(boolean reverse, long startTimestamp, long endTimestamp) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, ENTRIES, "local result = {}; local values;if ARGV[4] == '0' then values = redis.call('zrangebyscore', KEYS[1], ARGV[2], ARGV[3], 'withscores');else values = redis.call('zrevrangebyscore', KEYS[1], ARGV[3], ARGV[2], 'withscores');end;if #values == 0 then return result;end;for i = 1, #values, 2 do local expirationDate = redis.call('zscore', KEYS[2], values[i]); if tonumber(expirationDate) > tonumber(ARGV[1]) then local t, val = struct.unpack('LLc0', values[i]); table.insert(result, val);table.insert(result, values[i+1]);end;end;return result;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), startTimestamp, endTimestamp, Boolean.compare(reverse, false));
    }

    @Override
    public RFuture<Collection<V>> rangeAsync(long startTimestamp, long endTimestamp) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_LIST, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[2], ARGV[3]);if #values == 0 then return nil;end;local result = {}; for i, v in ipairs(values) do local expirationDate = redis.call('zscore', KEYS[2], v); if tonumber(expirationDate) > tonumber(ARGV[1]) then local t, val = struct.unpack('LLc0', v); table.insert(result, val);end;end;return result;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), startTimestamp, endTimestamp);
    }

    @Override
    public Collection<V> rangeReversed(long startTimestamp, long endTimestamp) {
        return this.get(this.rangeReversedAsync(startTimestamp, endTimestamp));
    }

    @Override
    public RFuture<Collection<V>> rangeReversedAsync(long startTimestamp, long endTimestamp) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_LIST, "local values = redis.call('zrevrangebyscore', KEYS[1], ARGV[3], ARGV[2]);if #values == 0 then return nil;end;local result = {}; for i, v in ipairs(values) do local expirationDate = redis.call('zscore', KEYS[2], v); if tonumber(expirationDate) > tonumber(ARGV[1]) then local t, val = struct.unpack('LLc0', v); table.insert(result, val);end;end;return result;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), startTimestamp, endTimestamp);
    }

    @Override
    public Collection<V> pollFirst(int count) {
        return this.get(this.pollFirstAsync(count));
    }

    @Override
    public Collection<V> pollLast(int count) {
        return this.get(this.pollLastAsync(count));
    }

    @Override
    public RFuture<Collection<V>> pollFirstAsync(int count) {
        if (count <= 0) {
            return RedissonPromise.newSucceededFuture(Collections.emptyList());
        }
        return this.pollAsync(0, count, RedisCommands.EVAL_LIST);
    }

    @Override
    public RFuture<Collection<V>> pollLastAsync(int count) {
        if (count <= 0) {
            return RedissonPromise.newSucceededFuture(Collections.emptyList());
        }
        return this.pollAsync(-1, count, RedisCommands.EVAL_LIST_REVERSE);
    }

    @Override
    public V pollFirst() {
        return this.get(this.pollFirstAsync());
    }

    @Override
    public V pollLast() {
        return this.get(this.pollLastAsync());
    }

    @Override
    public RFuture<V> pollFirstAsync() {
        return this.pollAsync(0, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    @Override
    public RFuture<V> pollLastAsync() {
        return this.pollAsync(-1, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    private <T> RFuture<T> pollAsync(int startScore, int limit, RedisCommand<?> command) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, command, "local values;if ARGV[2] == '0' then values = redis.call('zrangebyscore', KEYS[2], ARGV[1], '+inf', 'limit', 0, ARGV[3]);else values = redis.call('zrevrangebyscore', KEYS[2], '+inf', ARGV[1], 'limit', 0, ARGV[3]);end; local result = {}; for i, v in ipairs(values) do redis.call('zrem', KEYS[2], v); redis.call('zrem', KEYS[1], v); local t, val = struct.unpack('LLc0', v); table.insert(result, val);end;return result;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), startScore, limit);
    }

    public ListScanResult<Object> scanIterator(String name, RedisClient client, long startPos, String pattern, int count) {
        RFuture<ListScanResult<Object>> f = this.scanIteratorAsync(name, client, startPos, pattern, count);
        return this.get(f);
    }

    public RFuture<ListScanResult<Object>> scanIteratorAsync(String name, RedisClient client, long startPos, String pattern, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(startPos);
        params.add(System.currentTimeMillis());
        if (pattern != null) {
            params.add(pattern);
        }
        params.add(count);
        return this.commandExecutor.evalReadAsync(client, name, this.codec, RedisCommands.EVAL_ZSCAN, "local result = {}; local res; if (#ARGV == 4) then  res = redis.call('zscan', KEYS[1], ARGV[1], 'match', ARGV[3], 'count', ARGV[4]); else  res = redis.call('zscan', KEYS[1], ARGV[1], 'count', ARGV[3]); end;for i, value in ipairs(res[2]) do if i % 2 ~= 0 then local expirationDate = redis.call('zscore', KEYS[2], value); if tonumber(expirationDate) > tonumber(ARGV[2]) then local t, val = struct.unpack('LLc0', value); table.insert(result, val);end;end;end;return {res[1], result};", Arrays.asList(name, this.getTimeoutSetName()), params.toArray());
    }

    @Override
    public Iterator<V> iterator(int count) {
        return this.iterator(null, count);
    }

    @Override
    public Iterator<V> iterator(String pattern) {
        return this.iterator(pattern, 10);
    }

    @Override
    public Iterator<V> iterator(final String pattern, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ListScanResult<Object> iterator(RedisClient client, long nextIterPos) {
                return RedissonTimeSeries.this.scanIterator(RedissonTimeSeries.this.getName(), client, nextIterPos, pattern, count);
            }

            @Override
            protected void remove(Object value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null);
    }

    @Override
    public Stream<V> stream() {
        return this.toStream(this.iterator());
    }

    @Override
    public Stream<V> stream(int count) {
        return this.toStream(this.iterator(count));
    }

    @Override
    public Stream<V> stream(String pattern, int count) {
        return this.toStream(this.iterator(pattern, count));
    }

    @Override
    public Stream<V> stream(String pattern) {
        return this.toStream(this.iterator(pattern));
    }

    @Override
    public void destroy() {
        if (this.evictionScheduler != null) {
            this.evictionScheduler.remove(this.getName());
        }
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getName(), this.getTimeoutSetName());
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.expireAsync(timeToLive, timeUnit, this.getName(), this.getTimeoutSetName());
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.expireAtAsync(timestamp, this.getName(), this.getTimeoutSetName());
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getName(), this.getTimeoutSetName());
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getName(), this.getTimeoutSetName());
        return super.sizeInMemoryAsync(keys);
    }
}

