/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class MonoIgnoreThen<T>
extends Mono<T>
implements Fuseable,
Scannable {
    final Publisher<?>[] ignore;
    final Mono<T> last;

    MonoIgnoreThen(Publisher<?>[] ignore, Mono<T> last) {
        this.ignore = Objects.requireNonNull(ignore, "ignore");
        this.last = Objects.requireNonNull(last, "last");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        ThenIgnoreMain<T> manager = new ThenIgnoreMain<T>(actual, this.ignore, this.last);
        actual.onSubscribe(manager);
        manager.drain();
    }

    <U> MonoIgnoreThen<U> shift(Mono<U> newLast) {
        Objects.requireNonNull(newLast, "newLast");
        Publisher<?>[] a = this.ignore;
        int n = a.length;
        Publisher[] b = new Publisher[n + 1];
        System.arraycopy(a, 0, b, 0, n);
        b[n] = this.last;
        return new MonoIgnoreThen<U>(b, newLast);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }

    static final class ThenAcceptInner<T>
    implements InnerConsumer<T> {
        final ThenIgnoreMain<T> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<ThenAcceptInner, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ThenAcceptInner.class, Subscription.class, "s");
        boolean done;

        ThenAcceptInner(ThenIgnoreMain<T> parent) {
            this.parent = parent;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.parent;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.s == Operators.cancelledSubscription();
            }
            return null;
        }

        @Override
        public Context currentContext() {
            return this.parent.currentContext();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.parent.currentContext());
                return;
            }
            this.done = true;
            this.parent.complete(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.parent.currentContext());
                return;
            }
            this.done = true;
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.parent.onComplete();
        }

        void cancel() {
            Operators.terminate(S, this);
        }
    }

    static final class ThenIgnoreInner
    implements InnerConsumer<Object> {
        final ThenIgnoreMain<?> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<ThenIgnoreInner, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ThenIgnoreInner.class, Subscription.class, "s");

        ThenIgnoreInner(ThenIgnoreMain<?> parent) {
            this.parent = parent;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.parent;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.s == Operators.cancelledSubscription();
            }
            return null;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.replace(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public Context currentContext() {
            return this.parent.currentContext();
        }

        @Override
        public void onNext(Object t) {
            Operators.onDiscard(t, this.parent.currentContext());
        }

        @Override
        public void onError(Throwable t) {
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            this.parent.ignoreDone();
        }

        void cancel() {
            Operators.terminate(S, this);
        }

        void clear() {
            S.lazySet(this, null);
        }
    }

    static final class ThenIgnoreMain<T>
    extends Operators.MonoSubscriber<T, T> {
        final ThenIgnoreInner ignore;
        final ThenAcceptInner<T> accept;
        final Publisher<?>[] ignoreMonos;
        final Mono<T> lastMono;
        int index;
        volatile boolean active;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ThenIgnoreMain> WIP = AtomicIntegerFieldUpdater.newUpdater(ThenIgnoreMain.class, "wip");

        ThenIgnoreMain(CoreSubscriber<? super T> subscriber, Publisher<?>[] ignoreMonos, Mono<T> lastMono) {
            super(subscriber);
            this.ignoreMonos = ignoreMonos;
            this.lastMono = lastMono;
            this.ignore = new ThenIgnoreInner(this);
            this.accept = new ThenAcceptInner(this);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.ignore, this.accept);
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            while (true) {
                if (this.isCancelled()) {
                    return;
                }
                if (!this.active) {
                    Publisher<?> m;
                    int i = this.index;
                    Publisher<?>[] a = this.ignoreMonos;
                    if (i == a.length) {
                        this.ignore.clear();
                        m = this.lastMono;
                        if (m instanceof Callable) {
                            Object v;
                            try {
                                v = ((Callable)((Object)m)).call();
                            }
                            catch (Throwable ex) {
                                this.actual.onError(Operators.onOperatorError(ex, this.actual.currentContext()));
                                return;
                            }
                            if (v == null) {
                                this.actual.onComplete();
                            } else {
                                this.complete(v);
                            }
                            return;
                        }
                        this.active = true;
                        ((Mono)m).subscribe((CoreSubscriber<?>)this.accept);
                    } else {
                        m = a[i];
                        this.index = i + 1;
                        if (m instanceof Callable) {
                            try {
                                ((Callable)((Object)m)).call();
                            }
                            catch (Throwable ex) {
                                this.actual.onError(Operators.onOperatorError(ex, this.actual.currentContext()));
                                return;
                            }
                        }
                        this.active = true;
                        m.subscribe(this.ignore);
                    }
                }
                if (WIP.decrementAndGet(this) == 0) break;
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.ignore.cancel();
            this.accept.cancel();
        }

        void ignoreDone() {
            this.active = false;
            this.drain();
        }
    }
}

