/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.map;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.transaction.operation.map.MapOperation;

public class MapCacheFastPutIfAbsentOperation
extends MapOperation {
    private long ttl;
    private TimeUnit ttlUnit;
    private long maxIdleTime;
    private TimeUnit maxIdleUnit;

    public MapCacheFastPutIfAbsentOperation(RMap<?, ?> map, Object key, Object value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit, String transactionId, long threadId) {
        super(map, key, value, transactionId, threadId);
        this.ttl = ttl;
        this.ttlUnit = ttlUnit;
        this.maxIdleTime = maxIdleTime;
        this.maxIdleUnit = maxIdleUnit;
    }

    @Override
    public void commit(RMap<Object, Object> map) {
        ((RMapCache)map).fastPutIfAbsentAsync(this.key, this.value, this.ttl, this.ttlUnit, this.maxIdleTime, this.maxIdleUnit);
    }

    public long getTTL() {
        return this.ttl;
    }

    public TimeUnit getTTLUnit() {
        return this.ttlUnit;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public TimeUnit getMaxIdleUnit() {
        return this.maxIdleUnit;
    }
}

