/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.compression.Snappy;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.FstCodec;

public class SnappyCodec
extends BaseCodec {
    private static final FastThreadLocal<Snappy> SNAPPY_DECODER = new FastThreadLocal<Snappy>(){

        @Override
        protected Snappy initialValue() {
            return new Snappy();
        }
    };
    private static final FastThreadLocal<Snappy> SNAPPY_ENCODER = new FastThreadLocal<Snappy>(){

        @Override
        protected Snappy initialValue() {
            return new Snappy();
        }
    };
    private final Codec innerCodec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                while (buf.isReadable()) {
                    int chunkSize = buf.readInt();
                    ByteBuf chunk = buf.readSlice(chunkSize);
                    ((Snappy)SNAPPY_DECODER.get()).decode(chunk, out);
                    ((Snappy)SNAPPY_DECODER.get()).reset();
                }
                Object object = SnappyCodec.this.innerCodec.getValueDecoder().decode(out, state);
                return object;
            }
            finally {
                ((Snappy)SNAPPY_DECODER.get()).reset();
                out.release();
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf buf = SnappyCodec.this.innerCodec.getValueEncoder().encode(in);
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                int chunksAmount = (int)Math.ceil((double)buf.readableBytes() / 32767.0);
                for (int i = 1; i <= chunksAmount; ++i) {
                    int chunkSize = Math.min(Short.MAX_VALUE, buf.readableBytes());
                    ByteBuf chunk = buf.readSlice(chunkSize);
                    int lenIndex = out.writerIndex();
                    out.writeInt(0);
                    ((Snappy)SNAPPY_ENCODER.get()).encode(chunk, out, chunk.readableBytes());
                    int compressedDataLength = out.writerIndex() - 4 - lenIndex;
                    out.setInt(lenIndex, compressedDataLength);
                }
                ByteBuf byteBuf = out;
                return byteBuf;
            }
            finally {
                buf.release();
                ((Snappy)SNAPPY_ENCODER.get()).reset();
            }
        }
    };

    public SnappyCodec() {
        this(new FstCodec());
    }

    public SnappyCodec(Codec innerCodec) {
        this.innerCodec = innerCodec;
    }

    public SnappyCodec(ClassLoader classLoader) {
        this(new FstCodec(classLoader));
    }

    public SnappyCodec(ClassLoader classLoader, SnappyCodec codec) throws ReflectiveOperationException {
        this(SnappyCodec.copy(classLoader, codec.innerCodec));
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.innerCodec.getClassLoader();
    }
}

