/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.RedissonMap;
import org.redisson.RedissonMultiLock;
import org.redisson.RedissonObject;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.Hash;
import org.redisson.misc.HashValue;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.DeleteOperation;
import org.redisson.transaction.operation.TouchOperation;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.UnlinkOperation;
import org.redisson.transaction.operation.map.MapAddAndGetOperation;
import org.redisson.transaction.operation.map.MapFastPutIfAbsentOperation;
import org.redisson.transaction.operation.map.MapFastPutOperation;
import org.redisson.transaction.operation.map.MapFastRemoveOperation;
import org.redisson.transaction.operation.map.MapOperation;
import org.redisson.transaction.operation.map.MapPutIfAbsentOperation;
import org.redisson.transaction.operation.map.MapPutOperation;
import org.redisson.transaction.operation.map.MapRemoveOperation;
import org.redisson.transaction.operation.map.MapReplaceOperation;

public class BaseTransactionalMap<K, V> {
    private final long timeout;
    final List<TransactionalOperation> operations;
    final Map<HashValue, MapEntry> state = new HashMap<HashValue, MapEntry>();
    final RMap<K, V> map;
    final CommandAsyncExecutor commandExecutor;
    final String transactionId;
    Boolean deleted;

    public BaseTransactionalMap(CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, RMap<K, V> map, String transactionId) {
        this.timeout = timeout;
        this.operations = operations;
        this.map = map;
        this.commandExecutor = commandExecutor;
        this.transactionId = transactionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashValue toKeyHash(Object key) {
        ByteBuf keyState = ((RedissonObject)((Object)this.map)).encodeMapKey(key);
        try {
            HashValue hashValue = new HashValue(Hash.hash128(keyState));
            return hashValue;
        }
        finally {
            keyState.release();
        }
    }

    public RFuture<Boolean> isExistsAsync() {
        if (this.deleted != null) {
            return RedissonPromise.newSucceededFuture(this.deleted == false);
        }
        return this.map.isExistsAsync();
    }

    public RFuture<Boolean> unlinkAsync(CommandAsyncExecutor commandExecutor) {
        return this.deleteAsync(commandExecutor, new UnlinkOperation(this.map.getName(), null));
    }

    public RFuture<Boolean> touchAsync(CommandAsyncExecutor commandExecutor) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        if (this.deleted != null && this.deleted.booleanValue()) {
            this.operations.add(new TouchOperation(this.map.getName()));
            result.trySuccess(false);
            return result;
        }
        this.map.isExistsAsync().onComplete((exists, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            this.operations.add(new TouchOperation(this.map.getName()));
            if (!exists.booleanValue()) {
                for (MapEntry entry : this.state.values()) {
                    if (entry == MapEntry.NULL) continue;
                    exists = true;
                    break;
                }
            }
            result.trySuccess((Boolean)exists);
        });
        return result;
    }

    public RFuture<Boolean> deleteAsync(CommandAsyncExecutor commandExecutor) {
        return this.deleteAsync(commandExecutor, new DeleteOperation(this.map.getName()));
    }

    protected RFuture<Boolean> deleteAsync(CommandAsyncExecutor commandExecutor, TransactionalOperation operation) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        if (this.deleted != null) {
            this.operations.add(operation);
            result.trySuccess(this.deleted == false);
            this.deleted = true;
            return result;
        }
        this.map.isExistsAsync().onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            this.operations.add(operation);
            this.state.replaceAll((k, v) -> MapEntry.NULL);
            this.deleted = true;
            result.trySuccess((Boolean)res);
        });
        return result;
    }

    protected MapScanResult<Object, Object> scanIterator(String name, RedisClient client, long startPos, String pattern, int count) {
        MapScanResult<Object, Object> res = ((RedissonMap)this.map).scanIterator(name, client, startPos, pattern, count);
        HashMap<HashValue, MapEntry> newstate = new HashMap<HashValue, MapEntry>(this.state);
        Iterator<Object> iterator = res.getMap().keySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            MapEntry mapEntry = (MapEntry)newstate.remove(this.toKeyHash(entry));
            if (mapEntry == null) continue;
            if (mapEntry == MapEntry.NULL) {
                iterator.remove();
                continue;
            }
            res.getMap().put(entry, mapEntry.getValue());
        }
        if (startPos == 0L) {
            for (Map.Entry entry : newstate.entrySet()) {
                if (entry.getValue() == MapEntry.NULL) continue;
                res.getMap().put(((MapEntry)entry.getValue()).getKey(), ((MapEntry)entry.getValue()).getValue());
            }
        }
        return res;
    }

    public RFuture<Boolean> containsKeyAsync(Object key) {
        HashValue keyHash = this.toKeyHash(key);
        MapEntry currentValue = this.state.get(keyHash);
        if (currentValue != null) {
            if (currentValue == MapEntry.NULL) {
                return RedissonPromise.newSucceededFuture(false);
            }
            return RedissonPromise.newSucceededFuture(true);
        }
        return this.map.containsKeyAsync(key);
    }

    public RFuture<Boolean> containsValueAsync(Object value) {
        for (MapEntry entry : this.state.values()) {
            if (entry == MapEntry.NULL || !this.isEqual(entry.getValue(), value)) continue;
            return RedissonPromise.newSucceededFuture(true);
        }
        return this.map.containsValueAsync(value);
    }

    protected RFuture<V> addAndGetOperationAsync(final K key, final Number value) {
        final RedissonPromise result = new RedissonPromise();
        this.executeLocked(result, key, new Runnable(){

            @Override
            public void run() {
                HashValue keyHash = BaseTransactionalMap.this.toKeyHash(key);
                MapEntry entry = BaseTransactionalMap.this.state.get(keyHash);
                if (entry != null) {
                    BigDecimal currentValue = BigDecimal.ZERO;
                    if (entry != MapEntry.NULL) {
                        currentValue = (BigDecimal)entry.getValue();
                    }
                    BigDecimal res = currentValue.add(new BigDecimal(value.toString()));
                    BaseTransactionalMap.this.operations.add(new MapAddAndGetOperation(BaseTransactionalMap.this.map, key, value, BaseTransactionalMap.this.transactionId));
                    BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, res));
                    if (BaseTransactionalMap.this.deleted != null) {
                        BaseTransactionalMap.this.deleted = false;
                    }
                    NumberConvertor convertor = new NumberConvertor(value.getClass());
                    result.trySuccess(convertor.convert(res.toPlainString()));
                    return;
                }
                BaseTransactionalMap.this.map.getAsync(key).onComplete((r, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    BigDecimal currentValue = new BigDecimal(r.toString());
                    BigDecimal res = currentValue.add(new BigDecimal(value.toString()));
                    BaseTransactionalMap.this.operations.add(new MapAddAndGetOperation(BaseTransactionalMap.this.map, key, value, BaseTransactionalMap.this.transactionId));
                    BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, res));
                    if (BaseTransactionalMap.this.deleted != null) {
                        BaseTransactionalMap.this.deleted = false;
                    }
                    NumberConvertor convertor = new NumberConvertor(value.getClass());
                    result.trySuccess(convertor.convert(res.toPlainString()));
                });
            }
        });
        return result;
    }

    protected RFuture<V> putIfAbsentOperationAsync(K key, V value) {
        return this.putIfAbsentOperationAsync(key, value, new MapPutIfAbsentOperation(this.map, key, value, this.transactionId));
    }

    protected RFuture<V> putIfAbsentOperationAsync(final K key, final V value, final MapOperation mapOperation) {
        final RedissonPromise result = new RedissonPromise();
        this.executeLocked(result, key, new Runnable(){

            @Override
            public void run() {
                HashValue keyHash = BaseTransactionalMap.this.toKeyHash(key);
                MapEntry entry = BaseTransactionalMap.this.state.get(keyHash);
                if (entry != null) {
                    BaseTransactionalMap.this.operations.add(mapOperation);
                    if (entry == MapEntry.NULL) {
                        BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, value));
                        if (BaseTransactionalMap.this.deleted != null) {
                            BaseTransactionalMap.this.deleted = false;
                        }
                        result.trySuccess(null);
                    } else {
                        result.trySuccess(entry.getValue());
                    }
                    return;
                }
                BaseTransactionalMap.this.map.getAsync(key).onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    BaseTransactionalMap.this.operations.add(mapOperation);
                    if (res == null) {
                        BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, value));
                        if (BaseTransactionalMap.this.deleted != null) {
                            BaseTransactionalMap.this.deleted = false;
                        }
                    }
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    protected final RFuture<V> putOperationAsync(K key, V value) {
        return this.putOperationAsync(key, value, new MapPutOperation(this.map, key, value, this.transactionId));
    }

    protected RFuture<V> putOperationAsync(final K key, final V value, final MapOperation operation) {
        final RedissonPromise result = new RedissonPromise();
        this.executeLocked(result, key, new Runnable(){

            @Override
            public void run() {
                HashValue keyHash = BaseTransactionalMap.this.toKeyHash(key);
                MapEntry entry = BaseTransactionalMap.this.state.get(keyHash);
                if (entry != null) {
                    BaseTransactionalMap.this.operations.add(operation);
                    BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, value));
                    if (BaseTransactionalMap.this.deleted != null) {
                        BaseTransactionalMap.this.deleted = false;
                    }
                    if (entry == MapEntry.NULL) {
                        result.trySuccess(null);
                    } else {
                        result.trySuccess(entry.getValue());
                    }
                    return;
                }
                BaseTransactionalMap.this.map.getAsync(key).onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    BaseTransactionalMap.this.operations.add(operation);
                    BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, value));
                    if (BaseTransactionalMap.this.deleted != null) {
                        BaseTransactionalMap.this.deleted = false;
                    }
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    protected RFuture<Boolean> fastPutIfAbsentOperationAsync(K key, V value) {
        return this.fastPutIfAbsentOperationAsync(key, value, new MapFastPutIfAbsentOperation(this.map, key, value, this.transactionId));
    }

    protected RFuture<Boolean> fastPutIfAbsentOperationAsync(final K key, final V value, final MapOperation mapOperation) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, key, new Runnable(){

            @Override
            public void run() {
                HashValue keyHash = BaseTransactionalMap.this.toKeyHash(key);
                MapEntry entry = BaseTransactionalMap.this.state.get(keyHash);
                if (entry != null) {
                    BaseTransactionalMap.this.operations.add(mapOperation);
                    if (entry == MapEntry.NULL) {
                        BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, value));
                        if (BaseTransactionalMap.this.deleted != null) {
                            BaseTransactionalMap.this.deleted = false;
                        }
                        result.trySuccess(true);
                    } else {
                        result.trySuccess(false);
                    }
                    return;
                }
                BaseTransactionalMap.this.map.getAsync(key).onComplete((res, e) -> {
                    boolean isUpdated;
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    BaseTransactionalMap.this.operations.add(mapOperation);
                    boolean bl = isUpdated = res == null;
                    if (isUpdated) {
                        BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, value));
                        if (BaseTransactionalMap.this.deleted != null) {
                            BaseTransactionalMap.this.deleted = false;
                        }
                    }
                    result.trySuccess(isUpdated);
                });
            }
        });
        return result;
    }

    protected RFuture<Boolean> fastPutOperationAsync(K key, V value) {
        return this.fastPutOperationAsync(key, value, new MapFastPutOperation(this.map, key, value, this.transactionId));
    }

    protected RFuture<Boolean> fastPutOperationAsync(final K key, final V value, final MapOperation operation) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, key, new Runnable(){

            @Override
            public void run() {
                HashValue keyHash = BaseTransactionalMap.this.toKeyHash(key);
                MapEntry entry = BaseTransactionalMap.this.state.get(keyHash);
                if (entry != null) {
                    BaseTransactionalMap.this.operations.add(operation);
                    BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, value));
                    if (BaseTransactionalMap.this.deleted != null) {
                        BaseTransactionalMap.this.deleted = false;
                    }
                    if (entry == MapEntry.NULL) {
                        result.trySuccess(true);
                    } else {
                        result.trySuccess(false);
                    }
                    return;
                }
                BaseTransactionalMap.this.map.getAsync(key).onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    BaseTransactionalMap.this.operations.add(operation);
                    BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, value));
                    if (BaseTransactionalMap.this.deleted != null) {
                        BaseTransactionalMap.this.deleted = false;
                    }
                    boolean isNew = res == null;
                    result.trySuccess(isNew);
                });
            }
        });
        return result;
    }

    protected RFuture<Long> fastRemoveOperationAsync(final K ... keys) {
        final RedissonPromise<Long> result = new RedissonPromise<Long>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                AtomicLong counter = new AtomicLong();
                List<Object> keyList = Arrays.asList(keys);
                Iterator<Object> iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    Object key = iterator.next();
                    HashValue keyHash = BaseTransactionalMap.this.toKeyHash(key);
                    MapEntry currentValue = BaseTransactionalMap.this.state.get(keyHash);
                    if (currentValue == null || currentValue == MapEntry.NULL) continue;
                    BaseTransactionalMap.this.operations.add(new MapFastRemoveOperation(BaseTransactionalMap.this.map, key, BaseTransactionalMap.this.transactionId));
                    BaseTransactionalMap.this.state.put(keyHash, MapEntry.NULL);
                    counter.incrementAndGet();
                    iterator.remove();
                }
                BaseTransactionalMap.this.map.getAllAsync(new HashSet<Object>(keyList)).onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    for (Object key : res.keySet()) {
                        HashValue keyHash = BaseTransactionalMap.this.toKeyHash(key);
                        BaseTransactionalMap.this.operations.add(new MapFastRemoveOperation(BaseTransactionalMap.this.map, key, BaseTransactionalMap.this.transactionId));
                        counter.incrementAndGet();
                        BaseTransactionalMap.this.state.put(keyHash, MapEntry.NULL);
                    }
                    result.trySuccess(counter.get());
                });
            }
        }, Arrays.asList(keys));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RFuture<Integer> valueSizeAsync(K key) {
        HashValue keyHash = this.toKeyHash(key);
        MapEntry entry = this.state.get(keyHash);
        if (entry != null) {
            if (entry == MapEntry.NULL) {
                return RedissonPromise.newSucceededFuture(null);
            }
            ByteBuf valueState = ((RedissonObject)((Object)this.map)).encodeMapValue(entry.getValue());
            try {
                RFuture<Integer> rFuture = RedissonPromise.newSucceededFuture(valueState.readableBytes());
                return rFuture;
            }
            finally {
                valueState.release();
            }
        }
        return this.map.valueSizeAsync(key);
    }

    protected RFuture<V> getOperationAsync(K key) {
        HashValue keyHash = this.toKeyHash(key);
        MapEntry entry = this.state.get(keyHash);
        if (entry != null) {
            if (entry == MapEntry.NULL) {
                return RedissonPromise.newSucceededFuture(null);
            }
            return RedissonPromise.newSucceededFuture(entry.getValue());
        }
        return ((RedissonMap)this.map).getOperationAsync(key);
    }

    public RFuture<Set<K>> readAllKeySetAsync() {
        RedissonPromise<Set<K>> result = new RedissonPromise<Set<K>>();
        RFuture future = this.map.readAllKeySetAsync();
        future.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            Set set = (Set)future.getNow();
            HashMap<HashValue, MapEntry> newstate = new HashMap<HashValue, MapEntry>(this.state);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                MapEntry value = (MapEntry)newstate.remove(this.toKeyHash(key));
                if (value != MapEntry.NULL) continue;
                iterator.remove();
            }
            for (MapEntry entry : newstate.values()) {
                if (entry == MapEntry.NULL) continue;
                set.add(entry.getKey());
            }
            result.trySuccess(set);
        });
        return result;
    }

    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        RedissonPromise result = new RedissonPromise();
        RFuture<Map<K, Map>> future = this.readAllMapAsync();
        future.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            result.trySuccess(res.entrySet());
        });
        return result;
    }

    public RFuture<Collection<V>> readAllValuesAsync() {
        RedissonPromise result = new RedissonPromise();
        RFuture<Map<K, Map>> future = this.readAllMapAsync();
        future.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            result.trySuccess(res.values());
        });
        return result;
    }

    public RFuture<Map<K, V>> readAllMapAsync() {
        RedissonPromise<Map<K, V>> result = new RedissonPromise<Map<K, V>>();
        RFuture future = this.map.readAllMapAsync();
        future.onComplete((map, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            HashMap<HashValue, MapEntry> newstate = new HashMap<HashValue, MapEntry>(this.state);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                MapEntry entry = (MapEntry)newstate.remove(this.toKeyHash(key));
                if (entry == MapEntry.NULL) {
                    iterator.remove();
                    continue;
                }
                if (entry == null) continue;
                map.put(key, entry.getValue());
            }
            for (MapEntry entry : newstate.values()) {
                if (entry == MapEntry.NULL) continue;
                map.put(entry.getKey(), entry.getValue());
            }
            result.trySuccess((Map<K, V>)map);
        });
        return result;
    }

    protected RFuture<Map<K, V>> getAllOperationAsync(Set<K> keys) {
        RedissonPromise result = new RedissonPromise();
        HashSet<K> keysToLoad = new HashSet<K>();
        HashMap map = new HashMap();
        for (K key : keys) {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                if (entry == MapEntry.NULL) continue;
                map.put(key, entry.getValue());
                continue;
            }
            keysToLoad.add(key);
        }
        if (keysToLoad.isEmpty()) {
            return RedissonPromise.newSucceededFuture(map);
        }
        RFuture future = ((RedissonMap)this.map).getAllOperationAsync(keysToLoad);
        future.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            map.putAll((Map)future.getNow());
            result.trySuccess(map);
        });
        return result;
    }

    protected RFuture<V> removeOperationAsync(final K key) {
        final RedissonPromise result = new RedissonPromise();
        this.executeLocked(result, key, new Runnable(){

            @Override
            public void run() {
                HashValue keyHash = BaseTransactionalMap.this.toKeyHash(key);
                MapEntry entry = BaseTransactionalMap.this.state.get(keyHash);
                if (entry != null) {
                    BaseTransactionalMap.this.operations.add(new MapRemoveOperation(BaseTransactionalMap.this.map, key, BaseTransactionalMap.this.transactionId));
                    if (entry == MapEntry.NULL) {
                        result.trySuccess(null);
                    } else {
                        BaseTransactionalMap.this.state.put(keyHash, MapEntry.NULL);
                        result.trySuccess(entry.getValue());
                    }
                    return;
                }
                BaseTransactionalMap.this.map.getAsync(key).onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    BaseTransactionalMap.this.operations.add(new MapRemoveOperation(BaseTransactionalMap.this.map, key, BaseTransactionalMap.this.transactionId));
                    if (res != null) {
                        BaseTransactionalMap.this.state.put(keyHash, MapEntry.NULL);
                    }
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    protected RFuture<Boolean> removeOperationAsync(final Object key, final Object value) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, key, new Runnable(){

            @Override
            public void run() {
                HashValue keyHash = BaseTransactionalMap.this.toKeyHash(key);
                MapEntry entry = BaseTransactionalMap.this.state.get(keyHash);
                if (entry != null) {
                    if (entry == MapEntry.NULL) {
                        result.trySuccess(false);
                        return;
                    }
                    BaseTransactionalMap.this.operations.add(new MapRemoveOperation(BaseTransactionalMap.this.map, key, value, BaseTransactionalMap.this.transactionId));
                    if (BaseTransactionalMap.this.isEqual(entry.getValue(), value)) {
                        BaseTransactionalMap.this.state.put(keyHash, MapEntry.NULL);
                        result.trySuccess(true);
                        return;
                    }
                    result.trySuccess(false);
                    return;
                }
                BaseTransactionalMap.this.map.getAsync(key).onComplete((r, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    BaseTransactionalMap.this.operations.add(new MapRemoveOperation(BaseTransactionalMap.this.map, key, value, BaseTransactionalMap.this.transactionId));
                    boolean res = BaseTransactionalMap.this.isEqual(r, value);
                    if (res) {
                        BaseTransactionalMap.this.state.put(keyHash, MapEntry.NULL);
                    }
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEqual(Object value, Object oldValue) {
        ByteBuf valueBuf = ((RedissonObject)((Object)this.map)).encodeMapValue(value);
        ByteBuf oldValueBuf = ((RedissonObject)((Object)this.map)).encodeMapValue(oldValue);
        try {
            boolean bl = valueBuf.equals(oldValueBuf);
            return bl;
        }
        finally {
            valueBuf.readableBytes();
            oldValueBuf.readableBytes();
        }
    }

    protected RFuture<Void> putAllOperationAsync(final Map<? extends K, ? extends V> entries) {
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : entries.entrySet()) {
                    BaseTransactionalMap.this.operations.add(new MapPutOperation(BaseTransactionalMap.this.map, entry.getKey(), entry.getValue(), BaseTransactionalMap.this.transactionId));
                    HashValue keyHash = BaseTransactionalMap.this.toKeyHash(entry.getKey());
                    BaseTransactionalMap.this.state.put(keyHash, new MapEntry(entry.getKey(), entry.getValue()));
                }
                if (BaseTransactionalMap.this.deleted != null) {
                    BaseTransactionalMap.this.deleted = false;
                }
                result.trySuccess(null);
            }
        }, entries.keySet());
        return result;
    }

    protected RFuture<Boolean> replaceOperationAsync(final K key, final V oldValue, final V newValue) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, key, new Runnable(){

            @Override
            public void run() {
                HashValue keyHash = BaseTransactionalMap.this.toKeyHash(key);
                MapEntry entry = BaseTransactionalMap.this.state.get(keyHash);
                if (entry != null) {
                    if (entry == MapEntry.NULL) {
                        result.trySuccess(false);
                        return;
                    }
                    BaseTransactionalMap.this.operations.add(new MapReplaceOperation(BaseTransactionalMap.this.map, key, newValue, oldValue, BaseTransactionalMap.this.transactionId));
                    if (BaseTransactionalMap.this.isEqual(entry.getValue(), oldValue)) {
                        BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, newValue));
                        result.trySuccess(true);
                        return;
                    }
                    result.trySuccess(false);
                    return;
                }
                BaseTransactionalMap.this.map.getAsync(key).onComplete((r, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    BaseTransactionalMap.this.operations.add(new MapReplaceOperation(BaseTransactionalMap.this.map, key, newValue, oldValue, BaseTransactionalMap.this.transactionId));
                    boolean res = BaseTransactionalMap.this.isEqual(r, oldValue);
                    if (res) {
                        BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, newValue));
                    }
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    protected RFuture<V> replaceOperationAsync(final K key, final V value) {
        final RedissonPromise result = new RedissonPromise();
        this.executeLocked(result, key, new Runnable(){

            @Override
            public void run() {
                HashValue keyHash = BaseTransactionalMap.this.toKeyHash(key);
                MapEntry entry = BaseTransactionalMap.this.state.get(keyHash);
                BaseTransactionalMap.this.operations.add(new MapReplaceOperation(BaseTransactionalMap.this.map, key, value, BaseTransactionalMap.this.transactionId));
                if (entry != null) {
                    if (entry == MapEntry.NULL) {
                        result.trySuccess(null);
                        return;
                    }
                    BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, value));
                    result.trySuccess(entry.getValue());
                    return;
                }
                BaseTransactionalMap.this.map.getAsync(key).onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    BaseTransactionalMap.this.operations.add(new MapReplaceOperation(BaseTransactionalMap.this.map, key, value, BaseTransactionalMap.this.transactionId));
                    if (res != null) {
                        BaseTransactionalMap.this.state.put(keyHash, new MapEntry(key, value));
                    }
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    protected <R> void executeLocked(RPromise<R> promise, K key, Runnable runnable) {
        RLock lock = this.getLock(key);
        this.executeLocked(promise, runnable, lock);
    }

    protected RLock getLock(K key) {
        String lockName = ((RedissonMap)this.map).getLockByMapKey(key, "lock");
        return new RedissonTransactionalLock(this.commandExecutor, lockName, this.transactionId);
    }

    protected <R> void executeLocked(RPromise<R> promise, Runnable runnable, RLock lock) {
        lock.lockAsync(this.timeout, TimeUnit.MILLISECONDS).onComplete((res, e) -> {
            if (e == null) {
                runnable.run();
            } else {
                promise.tryFailure((Throwable)e);
            }
        });
    }

    protected <R> void executeLocked(RPromise<R> promise, Runnable runnable, Collection<K> keys) {
        ArrayList<RLock> locks = new ArrayList<RLock>(keys.size());
        for (K key : keys) {
            RLock lock = this.getLock(key);
            locks.add(lock);
        }
        RedissonMultiLock multiLock = new RedissonMultiLock(locks.toArray(new RLock[locks.size()]));
        long threadId = Thread.currentThread().getId();
        multiLock.lockAsync(this.timeout, TimeUnit.MILLISECONDS).onComplete((res, e) -> {
            if (e == null) {
                runnable.run();
            } else {
                multiLock.unlockAsync(threadId);
                promise.tryFailure((Throwable)e);
            }
        });
    }

    public static class MapEntry {
        public static final MapEntry NULL = new MapEntry(null, null);
        private final Object key;
        private final Object value;

        public MapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

