/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RSet;
import org.redisson.api.RSetMultimap;
import org.redisson.api.RedissonClient;
import org.redisson.api.condition.Condition;
import org.redisson.liveobject.condition.ANDCondition;
import org.redisson.liveobject.condition.EQCondition;
import org.redisson.liveobject.condition.GECondition;
import org.redisson.liveobject.condition.GTCondition;
import org.redisson.liveobject.condition.LECondition;
import org.redisson.liveobject.condition.LTCondition;
import org.redisson.liveobject.condition.ORCondition;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.liveobject.resolver.NamingScheme;

public class LiveObjectSearch {
    private final RedissonClient redisson;
    private final RedissonObjectBuilder objectBuilder;

    public LiveObjectSearch(RedissonClient redisson, RedissonObjectBuilder objectBuilder) {
        this.redisson = redisson;
        this.objectBuilder = objectBuilder;
    }

    private Set<Object> traverseAnd(ANDCondition condition, NamingScheme namingScheme, Class<?> entityClass) {
        HashSet<Object> allIds = new HashSet<Object>();
        ArrayList<String> eqNames = new ArrayList<String>();
        HashMap<RScoredSortedSet<Object>, Number> gtNumericNames = new HashMap<RScoredSortedSet<Object>, Number>();
        HashMap<RScoredSortedSet<Object>, Number> geNumericNames = new HashMap<RScoredSortedSet<Object>, Number>();
        HashMap<RScoredSortedSet<Object>, Number> ltNumericNames = new HashMap<RScoredSortedSet<Object>, Number>();
        HashMap<RScoredSortedSet<Object>, Number> leNumericNames = new HashMap<RScoredSortedSet<Object>, Number>();
        HashMap<RScoredSortedSet<Object>, Number> eqNumericNames = new HashMap<RScoredSortedSet<Object>, Number>();
        for (Condition cond : condition.getConditions()) {
            RScoredSortedSet values;
            String indexName;
            if (cond instanceof EQCondition) {
                EQCondition eqc = (EQCondition)cond;
                indexName = namingScheme.getIndexName(entityClass, eqc.getName());
                if (eqc.getValue() instanceof Number) {
                    values = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
                    eqNumericNames.put(values, (Number)eqc.getValue());
                } else {
                    RSetMultimap map = this.redisson.getSetMultimap(indexName, namingScheme.getCodec());
                    Collection values2 = map.get(eqc.getValue());
                    eqNames.add(values2.getName());
                }
            }
            if (cond instanceof LTCondition) {
                LTCondition ltc = (LTCondition)cond;
                indexName = namingScheme.getIndexName(entityClass, ltc.getName());
                values = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
                ltNumericNames.put(values, ltc.getValue());
            }
            if (cond instanceof LECondition) {
                LECondition lec = (LECondition)cond;
                indexName = namingScheme.getIndexName(entityClass, lec.getName());
                values = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
                leNumericNames.put(values, lec.getValue());
            }
            if (cond instanceof GECondition) {
                GECondition gec = (GECondition)cond;
                indexName = namingScheme.getIndexName(entityClass, gec.getName());
                values = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
                geNumericNames.put(values, gec.getValue());
            }
            if (cond instanceof GTCondition) {
                GTCondition gtc = (GTCondition)cond;
                indexName = namingScheme.getIndexName(entityClass, gtc.getName());
                values = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
                gtNumericNames.put(values, gtc.getValue());
            }
            if (!(cond instanceof ORCondition)) continue;
            Set<Object> ids = this.traverseOr((ORCondition)cond, namingScheme, entityClass);
            if (ids.isEmpty()) {
                return Collections.emptySet();
            }
            allIds.retainAll(ids);
            if (!allIds.isEmpty()) continue;
            return Collections.emptySet();
        }
        if (!eqNames.isEmpty()) {
            RSet set = this.redisson.getSet((String)eqNames.get(0));
            Set intersect = set.readIntersection(eqNames.toArray(new String[eqNames.size()]));
            if (!allIds.isEmpty()) {
                allIds.retainAll(intersect);
                if (allIds.isEmpty()) {
                    return Collections.emptySet();
                }
            } else {
                allIds.addAll(intersect);
            }
        }
        if (!this.checkValueRange(allIds, eqNumericNames, (r, v) -> r.valueRange(v.doubleValue(), true, v.doubleValue(), true))) {
            return Collections.emptySet();
        }
        if (!this.checkValueRange(allIds, gtNumericNames, (r, v) -> r.valueRange(v.doubleValue(), false, Double.POSITIVE_INFINITY, false))) {
            return Collections.emptySet();
        }
        if (!this.checkValueRange(allIds, geNumericNames, (r, v) -> r.valueRange(v.doubleValue(), true, Double.POSITIVE_INFINITY, false))) {
            return Collections.emptySet();
        }
        if (!this.checkValueRange(allIds, ltNumericNames, (r, v) -> r.valueRange(Double.NEGATIVE_INFINITY, false, v.doubleValue(), false))) {
            return Collections.emptySet();
        }
        if (!this.checkValueRange(allIds, leNumericNames, (r, v) -> r.valueRange(Double.NEGATIVE_INFINITY, false, v.doubleValue(), true))) {
            return Collections.emptySet();
        }
        return allIds;
    }

    private boolean checkValueRange(Set<Object> allIds, Map<RScoredSortedSet<Object>, Number> numericNames, BiFunction<RScoredSortedSet<Object>, Number, Collection<Object>> func) {
        if (numericNames.isEmpty()) {
            return true;
        }
        for (Map.Entry<RScoredSortedSet<Object>, Number> e : numericNames.entrySet()) {
            Collection<Object> gtIds = func.apply(e.getKey(), e.getValue());
            if (gtIds.isEmpty()) {
                return false;
            }
            if (!allIds.isEmpty()) {
                allIds.retainAll(gtIds);
                if (!allIds.isEmpty()) continue;
                return false;
            }
            allIds.addAll(gtIds);
        }
        return true;
    }

    private Set<Object> traverseOr(ORCondition condition, NamingScheme namingScheme, Class<?> entityClass) {
        HashSet<Object> allIds = new HashSet<Object>();
        ArrayList<String> eqNames = new ArrayList<String>();
        HashMap ltNumericNames = new HashMap();
        HashMap leNumericNames = new HashMap();
        HashMap gtNumericNames = new HashMap();
        HashMap geNumericNames = new HashMap();
        HashMap eqNumericNames = new HashMap();
        for (Condition cond : condition.getConditions()) {
            RScoredSortedSet values;
            String indexName;
            if (cond instanceof EQCondition) {
                EQCondition eqc = (EQCondition)cond;
                indexName = namingScheme.getIndexName(entityClass, eqc.getName());
                if (eqc.getValue() instanceof Number) {
                    values = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
                    eqNumericNames.put(values, (Number)eqc.getValue());
                } else {
                    RSetMultimap map = this.redisson.getSetMultimap(indexName, namingScheme.getCodec());
                    Collection values2 = map.get(eqc.getValue());
                    eqNames.add(values2.getName());
                }
            }
            if (cond instanceof GTCondition) {
                GTCondition gtc = (GTCondition)cond;
                indexName = namingScheme.getIndexName(entityClass, gtc.getName());
                values = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
                gtNumericNames.put(values, gtc.getValue());
            }
            if (cond instanceof GECondition) {
                GECondition gec = (GECondition)cond;
                indexName = namingScheme.getIndexName(entityClass, gec.getName());
                values = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
                geNumericNames.put(values, gec.getValue());
            }
            if (cond instanceof LTCondition) {
                LTCondition ltc = (LTCondition)cond;
                indexName = namingScheme.getIndexName(entityClass, ltc.getName());
                values = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
                ltNumericNames.put(values, ltc.getValue());
            }
            if (cond instanceof LECondition) {
                LECondition lec = (LECondition)cond;
                indexName = namingScheme.getIndexName(entityClass, lec.getName());
                values = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
                leNumericNames.put(values, lec.getValue());
            }
            if (!(cond instanceof ANDCondition)) continue;
            Set<Object> ids = this.traverseAnd((ANDCondition)cond, namingScheme, entityClass);
            allIds.addAll(ids);
        }
        if (!eqNames.isEmpty()) {
            RSet set = this.redisson.getSet((String)eqNames.get(0));
            allIds.addAll(set.readUnion(eqNames.toArray(new String[eqNames.size()])));
        }
        for (Map.Entry entry : eqNumericNames.entrySet()) {
            Collection ids = ((RScoredSortedSet)entry.getKey()).valueRange(((Number)entry.getValue()).doubleValue(), true, ((Number)entry.getValue()).doubleValue(), true);
            allIds.addAll(ids);
        }
        for (Map.Entry entry : gtNumericNames.entrySet()) {
            Collection ids = ((RScoredSortedSet)entry.getKey()).valueRange(((Number)entry.getValue()).doubleValue(), false, Double.POSITIVE_INFINITY, false);
            allIds.addAll(ids);
        }
        for (Map.Entry entry : geNumericNames.entrySet()) {
            Collection ids = ((RScoredSortedSet)entry.getKey()).valueRange(((Number)entry.getValue()).doubleValue(), true, Double.POSITIVE_INFINITY, false);
            allIds.addAll(ids);
        }
        for (Map.Entry entry : ltNumericNames.entrySet()) {
            Collection ids = ((RScoredSortedSet)entry.getKey()).valueRange(Double.NEGATIVE_INFINITY, false, ((Number)entry.getValue()).doubleValue(), false);
            allIds.addAll(ids);
        }
        for (Map.Entry entry : leNumericNames.entrySet()) {
            Collection ids = ((RScoredSortedSet)entry.getKey()).valueRange(Double.NEGATIVE_INFINITY, false, ((Number)entry.getValue()).doubleValue(), true);
            allIds.addAll(ids);
        }
        return allIds;
    }

    public Set<Object> find(Class<?> entityClass, Condition condition) {
        NamingScheme namingScheme = this.objectBuilder.getNamingScheme(entityClass);
        if (condition instanceof EQCondition) {
            EQCondition c = (EQCondition)condition;
            String indexName = namingScheme.getIndexName(entityClass, c.getName());
            if (c.getValue() instanceof Number) {
                RScoredSortedSet set = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
                double v = ((Number)c.getValue()).doubleValue();
                Collection gtIds = set.valueRange(v, true, v, true);
                return new HashSet<Object>(gtIds);
            }
            RSetMultimap map = this.redisson.getSetMultimap(indexName, namingScheme.getCodec());
            return map.getAll(c.getValue());
        }
        if (condition instanceof GTCondition) {
            GTCondition c = (GTCondition)condition;
            String indexName = namingScheme.getIndexName(entityClass, c.getName());
            RScoredSortedSet set = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
            Collection gtIds = set.valueRange(c.getValue().doubleValue(), false, Double.POSITIVE_INFINITY, false);
            return new HashSet<Object>(gtIds);
        }
        if (condition instanceof GECondition) {
            GECondition c = (GECondition)condition;
            String indexName = namingScheme.getIndexName(entityClass, c.getName());
            RScoredSortedSet set = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
            Collection gtIds = set.valueRange(c.getValue().doubleValue(), true, Double.POSITIVE_INFINITY, false);
            return new HashSet<Object>(gtIds);
        }
        if (condition instanceof LTCondition) {
            LTCondition c = (LTCondition)condition;
            String indexName = namingScheme.getIndexName(entityClass, c.getName());
            RScoredSortedSet set = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
            Collection gtIds = set.valueRange(Double.NEGATIVE_INFINITY, false, c.getValue().doubleValue(), false);
            return new HashSet<Object>(gtIds);
        }
        if (condition instanceof LECondition) {
            LECondition c = (LECondition)condition;
            String indexName = namingScheme.getIndexName(entityClass, c.getName());
            RScoredSortedSet set = this.redisson.getScoredSortedSet(indexName, namingScheme.getCodec());
            Collection gtIds = set.valueRange(Double.NEGATIVE_INFINITY, false, c.getValue().doubleValue(), true);
            return new HashSet<Object>(gtIds);
        }
        if (condition instanceof ORCondition) {
            return this.traverseOr((ORCondition)condition, namingScheme, entityClass);
        }
        if (condition instanceof ANDCondition) {
            return this.traverseAnd((ANDCondition)condition, namingScheme, entityClass);
        }
        throw new IllegalArgumentException();
    }
}

