/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.api.RMap;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.executor.RemoteExecutorService;
import org.redisson.executor.RemotePromise;
import org.redisson.executor.params.TaskParameters;
import org.redisson.misc.RedissonPromise;
import org.redisson.remote.BaseRemoteService;
import org.redisson.remote.RemoteServiceCancelRequest;
import org.redisson.remote.RemoteServiceCancelResponse;
import org.redisson.remote.RemoteServiceRequest;
import org.redisson.remote.RequestId;
import org.redisson.remote.ResponseEntry;

public class TasksService
extends BaseRemoteService {
    protected String terminationTopicName;
    protected String tasksCounterName;
    protected String statusName;
    protected String tasksName;
    protected String schedulerQueueName;
    protected String schedulerChannelName;
    protected String tasksRetryIntervalName;
    protected long tasksRetryInterval;

    public TasksService(Codec codec, String name, CommandAsyncExecutor commandExecutor, String executorId, ConcurrentMap<String, ResponseEntry> responses) {
        super(codec, name, commandExecutor, executorId, responses);
    }

    public void setTasksRetryIntervalName(String tasksRetryIntervalName) {
        this.tasksRetryIntervalName = tasksRetryIntervalName;
    }

    public void setTasksRetryInterval(long tasksRetryInterval) {
        this.tasksRetryInterval = tasksRetryInterval;
    }

    public void setTerminationTopicName(String terminationTopicName) {
        this.terminationTopicName = terminationTopicName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public void setTasksCounterName(String tasksCounterName) {
        this.tasksCounterName = tasksCounterName;
    }

    public void setTasksName(String tasksName) {
        this.tasksName = tasksName;
    }

    public void setSchedulerChannelName(String schedulerChannelName) {
        this.schedulerChannelName = schedulerChannelName;
    }

    public void setSchedulerQueueName(String scheduledQueueName) {
        this.schedulerQueueName = scheduledQueueName;
    }

    @Override
    protected final RFuture<Boolean> addAsync(String requestQueueName, RemoteServiceRequest request, RemotePromise<Object> result) {
        RedissonPromise<Boolean> promise = new RedissonPromise<Boolean>();
        RFuture<Boolean> future = this.addAsync(requestQueueName, request);
        result.setAddFuture(future);
        future.onComplete((res, e) -> {
            if (e != null) {
                promise.tryFailure((Throwable)e);
                return;
            }
            if (!res.booleanValue()) {
                promise.cancel(true);
                return;
            }
            promise.trySuccess(true);
        });
        return promise;
    }

    protected CommandAsyncExecutor getAddCommandExecutor() {
        return this.commandExecutor;
    }

    protected RFuture<Boolean> addAsync(String requestQueueName, RemoteServiceRequest request) {
        TaskParameters params = (TaskParameters)request.getArgs()[0];
        params.setRequestId(request.getId());
        long retryStartTime = 0L;
        if (this.tasksRetryInterval > 0L) {
            retryStartTime = System.currentTimeMillis() + this.tasksRetryInterval;
        }
        return this.getAddCommandExecutor().evalWriteAsync(this.name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[2]) == 0 then redis.call('hset', KEYS[5], ARGV[2], ARGV[3]);redis.call('rpush', KEYS[6], ARGV[2]); redis.call('incr', KEYS[1]);if tonumber(ARGV[1]) > 0 then redis.call('set', KEYS[7], ARGV[4]);redis.call('zadd', KEYS[3], ARGV[1], 'ff' .. ARGV[2]);local v = redis.call('zrange', KEYS[3], 0, 0); if v[1] == ARGV[2] then redis.call('publish', KEYS[4], ARGV[1]); end end;return 1;end;return 0;", Arrays.asList(this.tasksCounterName, this.statusName, this.schedulerQueueName, this.schedulerChannelName, this.tasksName, requestQueueName, this.tasksRetryIntervalName), retryStartTime, request.getId(), this.encode(request), this.tasksRetryInterval);
    }

    @Override
    protected RFuture<Boolean> removeAsync(String requestQueueName, RequestId taskId) {
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('zrem', KEYS[2], 'ff' .. ARGV[1]); local task = redis.call('hget', KEYS[6], ARGV[1]); redis.call('hdel', KEYS[6], ARGV[1]); if task ~= false and redis.call('exists', KEYS[3]) == 1 and redis.call('lrem', KEYS[1], 1, ARGV[1]) > 0 then if redis.call('decr', KEYS[3]) == 0 then redis.call('del', KEYS[3]);if redis.call('get', KEYS[4]) == ARGV[2] then redis.call('del', KEYS[7]);redis.call('set', KEYS[4], ARGV[3]);redis.call('publish', KEYS[5], ARGV[3]);end;end;return 1;end;if task == false then return 1; end;return 0;", Arrays.asList(requestQueueName, this.schedulerQueueName, this.tasksCounterName, this.statusName, this.terminationTopicName, this.tasksName, this.tasksRetryIntervalName), taskId.toString(), 1, 2);
    }

    public RFuture<Boolean> cancelExecutionAsync(RequestId requestId) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        String requestQueueName = this.getRequestQueueName(RemoteExecutorService.class);
        RFuture<Boolean> removeFuture = this.removeAsync(requestQueueName, requestId);
        removeFuture.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                result.trySuccess(true);
                return;
            }
            RMap<String, RemoteServiceCancelRequest> canceledRequests = this.getMap(this.cancelRequestMapName);
            canceledRequests.putAsync(requestId.toString(), new RemoteServiceCancelRequest(true, true));
            canceledRequests.expireAsync(60L, TimeUnit.SECONDS);
            RedissonPromise response = new RedissonPromise();
            this.scheduleCheck(this.cancelResponseMapName, requestId, response);
            response.onComplete((r, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                if (response.getNow() == null) {
                    result.trySuccess(false);
                    return;
                }
                result.trySuccess(((RemoteServiceCancelResponse)response.getNow()).isCanceled());
            });
        });
        return result;
    }
}

