/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.redisson.config.BaseMasterSlaveServersConfig;

public class SentinelServersConfig
extends BaseMasterSlaveServersConfig<SentinelServersConfig> {
    private List<String> sentinelAddresses = new ArrayList<String>();
    private Map<String, String> natMap = Collections.emptyMap();
    private String masterName;
    private int database = 0;
    private int scanInterval = 1000;

    public SentinelServersConfig() {
    }

    SentinelServersConfig(SentinelServersConfig config) {
        super(config);
        this.setSentinelAddresses(config.getSentinelAddresses());
        this.setMasterName(config.getMasterName());
        this.setDatabase(config.getDatabase());
        this.setScanInterval(config.getScanInterval());
        this.setNatMap(new HashMap<String, String>(config.getNatMap()));
    }

    public SentinelServersConfig setMasterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public SentinelServersConfig addSentinelAddress(String ... addresses) {
        this.sentinelAddresses.addAll(Arrays.asList(addresses));
        return this;
    }

    public List<String> getSentinelAddresses() {
        return this.sentinelAddresses;
    }

    void setSentinelAddresses(List<String> sentinelAddresses) {
        this.sentinelAddresses = sentinelAddresses;
    }

    public SentinelServersConfig setDatabase(int database) {
        this.database = database;
        return this;
    }

    public int getDatabase() {
        return this.database;
    }

    public int getScanInterval() {
        return this.scanInterval;
    }

    public SentinelServersConfig setScanInterval(int scanInterval) {
        this.scanInterval = scanInterval;
        return this;
    }

    public Map<String, String> getNatMap() {
        return this.natMap;
    }

    public SentinelServersConfig setNatMap(Map<String, String> natMap) {
        this.natMap = natMap;
        return this;
    }
}

