/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import java.lang.reflect.Method;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.FieldProxy;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import org.redisson.api.RBatch;
import org.redisson.api.RFuture;
import org.redisson.api.RLiveObject;
import org.redisson.api.RMap;
import org.redisson.api.RMultimapAsync;
import org.redisson.api.RedissonClient;
import org.redisson.api.annotation.RIndex;
import org.redisson.client.RedisException;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.liveobject.misc.Introspectior;
import org.redisson.liveobject.resolver.NamingScheme;

public class LiveObjectInterceptor {
    private final RedissonClient redisson;
    private final Class<?> originalClass;
    private final String idFieldName;
    private final Class<?> idFieldType;
    private final NamingScheme namingScheme;
    private final RedissonObjectBuilder objectBuilder;

    public LiveObjectInterceptor(RedissonClient redisson, Class<?> entityClass, String idFieldName, RedissonObjectBuilder objectBuilder) {
        this.redisson = redisson;
        this.originalClass = entityClass;
        this.idFieldName = idFieldName;
        this.objectBuilder = objectBuilder;
        this.namingScheme = objectBuilder.getNamingScheme(entityClass);
        try {
            this.idFieldType = ClassUtils.getDeclaredField(this.originalClass, idFieldName).getType();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @RuntimeType
    public Object intercept(@Origin Method method, @AllArguments Object[] args, @This Object me, @FieldValue(value="liveObjectId") Object id, @FieldProxy(value="liveObjectId") Setter idSetter, @FieldProxy(value="liveObjectId") Getter idGetter, @FieldValue(value="liveObjectLiveMap") RMap<?, ?> map, @FieldProxy(value="liveObjectLiveMap") Setter mapSetter, @FieldProxy(value="liveObjectLiveMap") Getter mapGetter) throws Exception {
        if ("setLiveObjectId".equals(method.getName())) {
            String idKey;
            block10: {
                if (args[0].getClass().isArray()) {
                    throw new UnsupportedOperationException("RId value cannot be an array.");
                }
                idKey = this.getMapKey(args[0]);
                if (map != null) {
                    if (map.getName().equals(idKey)) {
                        return null;
                    }
                    try {
                        map.rename(this.getMapKey(args[0]));
                    }
                    catch (RedisException e) {
                        if (e.getMessage() != null && e.getMessage().startsWith("ERR no such key")) break block10;
                        throw e;
                    }
                }
            }
            RMap liveMap = this.redisson.getMap(idKey, this.namingScheme.getCodec());
            mapSetter.setValue(liveMap);
            return null;
        }
        if ("getLiveObjectId".equals(method.getName())) {
            if (map == null) {
                return null;
            }
            return this.namingScheme.resolveId(map.getName());
        }
        if ("delete".equals(method.getName())) {
            FieldList<FieldDescription.InDefinedShape> fields = Introspectior.getFieldsWithAnnotation(me.getClass().getSuperclass(), RIndex.class);
            RBatch batch = this.redisson.createBatch();
            for (FieldDescription.InDefinedShape field : fields) {
                String fieldName = field.getName();
                Object value = map.get(fieldName);
                NamingScheme namingScheme = this.objectBuilder.getNamingScheme(me.getClass().getSuperclass());
                String indexName = namingScheme.getIndexName(me.getClass().getSuperclass(), fieldName);
                RMultimapAsync idsMultimap = batch.getSetMultimap(indexName, namingScheme.getCodec());
                idsMultimap.removeAsync(value, ((RLiveObject)me).getLiveObjectId());
            }
            RFuture<Long> deleteFuture = batch.getKeys().deleteAsync(map.getName());
            batch.execute();
            return deleteFuture.getNow() > 0L;
        }
        return method.invoke(map, args);
    }

    private String getMapKey(Object id) {
        return this.namingScheme.getName(this.originalClass, this.idFieldType, this.idFieldName, id);
    }

    public static interface Setter {
        public void setValue(Object var1);
    }

    public static interface Getter {
        public Object getValue();
    }
}

