/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import org.redisson.Version;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.RedisNodeNotFoundException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.command.CommandSyncService;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.TransportMode;
import org.redisson.connection.ConnectionEventsHub;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.DNSMonitor;
import org.redisson.connection.IdleConnectionWatcher;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.connection.SingleEntry;
import org.redisson.misc.CountableListener;
import org.redisson.misc.InfinitySemaphoreLatch;
import org.redisson.misc.RedisURI;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.PublishSubscribeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveConnectionManager
implements ConnectionManager {
    public static final Timeout DUMMY_TIMEOUT = new Timeout(){

        @Override
        public Timer timer() {
            return null;
        }

        @Override
        public TimerTask task() {
            return null;
        }

        @Override
        public boolean isExpired() {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean cancel() {
            return true;
        }
    };
    protected final UUID id;
    public static final int MAX_SLOT = 16384;
    protected final ClusterSlotRange singleSlotRange = new ClusterSlotRange(0, 16383);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private HashedWheelTimer timer;
    protected Codec codec;
    protected final EventLoopGroup group;
    protected final Class<? extends SocketChannel> socketChannelClass;
    protected DNSMonitor dnsMonitor;
    protected MasterSlaveServersConfig config;
    private final AtomicReferenceArray<MasterSlaveEntry> slot2entry = new AtomicReferenceArray(16384);
    private final Map<RedisClient, MasterSlaveEntry> client2entry = new ConcurrentHashMap<RedisClient, MasterSlaveEntry>();
    private final Promise<Void> shutdownPromise = ImmediateEventExecutor.INSTANCE.newPromise();
    private final InfinitySemaphoreLatch shutdownLatch = new InfinitySemaphoreLatch();
    private IdleConnectionWatcher connectionWatcher;
    private final ConnectionEventsHub connectionEventsHub = new ConnectionEventsHub();
    private final ExecutorService executor;
    private final CommandSyncService commandExecutor;
    private final Config cfg;
    protected final AddressResolverGroup<InetSocketAddress> resolverGroup;
    private PublishSubscribeService subscribeService;
    private final Map<Object, RedisConnection> nodeConnections = new ConcurrentHashMap<Object, RedisConnection>();

    public MasterSlaveConnectionManager(MasterSlaveServersConfig cfg, Config config, UUID id) {
        this(config, id);
        this.config = cfg;
        this.initTimer(cfg);
        this.initSingleEntry();
    }

    protected MasterSlaveConnectionManager(Config cfg, UUID id) {
        this.id = id;
        Version.logVersion();
        if (cfg.getTransportMode() == TransportMode.EPOLL) {
            this.group = cfg.getEventLoopGroup() == null ? new EpollEventLoopGroup(cfg.getNettyThreads(), new DefaultThreadFactory("redisson-netty")) : cfg.getEventLoopGroup();
            this.socketChannelClass = EpollSocketChannel.class;
            this.resolverGroup = PlatformDependent.isAndroid() ? DefaultAddressResolverGroup.INSTANCE : cfg.getAddressResolverGroupFactory().create(EpollDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault());
        } else if (cfg.getTransportMode() == TransportMode.KQUEUE) {
            this.group = cfg.getEventLoopGroup() == null ? new KQueueEventLoopGroup(cfg.getNettyThreads(), new DefaultThreadFactory("redisson-netty")) : cfg.getEventLoopGroup();
            this.socketChannelClass = KQueueSocketChannel.class;
            this.resolverGroup = PlatformDependent.isAndroid() ? DefaultAddressResolverGroup.INSTANCE : cfg.getAddressResolverGroupFactory().create(KQueueDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault());
        } else {
            this.group = cfg.getEventLoopGroup() == null ? new NioEventLoopGroup(cfg.getNettyThreads(), new DefaultThreadFactory("redisson-netty")) : cfg.getEventLoopGroup();
            this.socketChannelClass = NioSocketChannel.class;
            this.resolverGroup = PlatformDependent.isAndroid() ? DefaultAddressResolverGroup.INSTANCE : cfg.getAddressResolverGroupFactory().create(NioDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault());
        }
        if (cfg.getExecutor() == null) {
            int threads = Runtime.getRuntime().availableProcessors() * 2;
            if (cfg.getThreads() != 0) {
                threads = cfg.getThreads();
            }
            this.executor = Executors.newFixedThreadPool(threads, new DefaultThreadFactory("redisson"));
        } else {
            this.executor = cfg.getExecutor();
        }
        this.cfg = cfg;
        this.codec = cfg.getCodec();
        this.commandExecutor = new CommandSyncService(this);
    }

    protected void closeNodeConnections() {
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>();
        for (RedisConnection redisConnection : this.nodeConnections.values()) {
            RFuture<Void> future = redisConnection.getRedisClient().shutdownAsync();
            futures.add(future);
        }
        for (RFuture rFuture : futures) {
            rFuture.syncUninterruptibly();
        }
    }

    protected void closeNodeConnection(RedisConnection conn) {
        if (this.nodeConnections.values().remove(conn)) {
            conn.closeAsync();
        }
    }

    protected RFuture<RedisConnection> connectToNode(BaseMasterSlaveServersConfig<?> cfg, RedisURI addr, RedisClient client, String sslHostname) {
        Object key = client != null ? client : addr;
        RedisConnection conn = this.nodeConnections.get(key);
        if (conn != null) {
            if (!conn.isActive()) {
                this.nodeConnections.remove(key);
                conn.closeAsync();
            } else {
                return RedissonPromise.newSucceededFuture(conn);
            }
        }
        if (addr != null) {
            client = this.createClient(NodeType.MASTER, addr, cfg.getConnectTimeout(), cfg.getTimeout(), sslHostname);
        }
        RedissonPromise<RedisConnection> result = new RedissonPromise<RedisConnection>();
        RFuture<RedisConnection> future = client.connectAsync();
        future.onComplete((connection, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (connection.isActive()) {
                this.nodeConnections.put(key, (RedisConnection)connection);
                result.trySuccess((RedisConnection)connection);
            } else {
                connection.closeAsync();
                result.tryFailure(new RedisException("Connection to " + connection.getRedisClient().getAddr() + " is not active!"));
            }
        });
        return result;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public boolean isClusterMode() {
        return false;
    }

    @Override
    public CommandSyncService getCommandExecutor() {
        return this.commandExecutor;
    }

    @Override
    public IdleConnectionWatcher getConnectionWatcher() {
        return this.connectionWatcher;
    }

    @Override
    public Config getCfg() {
        return this.cfg;
    }

    @Override
    public MasterSlaveServersConfig getConfig() {
        return this.config;
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    @Override
    public Collection<MasterSlaveEntry> getEntrySet() {
        return this.client2entry.values();
    }

    protected void initTimer(MasterSlaveServersConfig config) {
        int[] timeouts = new int[]{config.getRetryInterval(), config.getTimeout()};
        Arrays.sort(timeouts);
        int minTimeout = timeouts[0];
        minTimeout = minTimeout % 100 != 0 ? minTimeout % 100 / 2 : (minTimeout == 100 ? 50 : 100);
        this.timer = new HashedWheelTimer(Executors.defaultThreadFactory(), minTimeout, TimeUnit.MILLISECONDS, 1024, false);
        this.connectionWatcher = new IdleConnectionWatcher(this, config);
        this.subscribeService = new PublishSubscribeService(this, config);
    }

    protected void initSingleEntry() {
        try {
            MasterSlaveEntry entry = this.config.checkSkipSlavesInit() ? new SingleEntry(this, this.config) : this.createMasterSlaveEntry(this.config);
            RFuture<RedisClient> f = entry.setupMasterEntry(new RedisURI(this.config.getMasterAddress()));
            f.syncUninterruptibly();
            for (int slot = this.singleSlotRange.getStartSlot(); slot < this.singleSlotRange.getEndSlot() + 1; ++slot) {
                this.addEntry(slot, entry);
            }
            this.startDNSMonitoring(f.getNow());
        }
        catch (Exception e) {
            this.stopThreads();
            throw e;
        }
    }

    protected void startDNSMonitoring(RedisClient masterHost) {
        if (this.config.getDnsMonitoringInterval() != -1L) {
            Set<RedisURI> slaveAddresses = this.config.getSlaveAddresses().stream().map(r -> new RedisURI((String)r)).collect(Collectors.toSet());
            this.dnsMonitor = new DNSMonitor(this, masterHost, slaveAddresses, this.config.getDnsMonitoringInterval(), this.resolverGroup);
            this.dnsMonitor.start();
        }
    }

    protected MasterSlaveEntry createMasterSlaveEntry(MasterSlaveServersConfig config) {
        MasterSlaveEntry entry = new MasterSlaveEntry(this, config);
        List<RFuture<Void>> fs = entry.initSlaveBalancer(Collections.emptySet());
        for (RFuture<Void> future : fs) {
            future.syncUninterruptibly();
        }
        return entry;
    }

    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig c = new MasterSlaveServersConfig();
        c.setPingConnectionInterval(cfg.getPingConnectionInterval());
        c.setSslEnableEndpointIdentification(cfg.isSslEnableEndpointIdentification());
        c.setSslProvider(cfg.getSslProvider());
        c.setSslTruststore(cfg.getSslTruststore());
        c.setSslTruststorePassword(cfg.getSslTruststorePassword());
        c.setSslKeystore(cfg.getSslKeystore());
        c.setSslKeystorePassword(cfg.getSslKeystorePassword());
        c.setRetryInterval(cfg.getRetryInterval());
        c.setRetryAttempts(cfg.getRetryAttempts());
        c.setTimeout(cfg.getTimeout());
        c.setPingTimeout(cfg.getPingTimeout());
        c.setLoadBalancer(cfg.getLoadBalancer());
        c.setPassword(cfg.getPassword());
        c.setClientName(cfg.getClientName());
        c.setMasterConnectionPoolSize(cfg.getMasterConnectionPoolSize());
        c.setSlaveConnectionPoolSize(cfg.getSlaveConnectionPoolSize());
        c.setSubscriptionConnectionPoolSize(cfg.getSubscriptionConnectionPoolSize());
        c.setSubscriptionsPerConnection(cfg.getSubscriptionsPerConnection());
        c.setConnectTimeout(cfg.getConnectTimeout());
        c.setIdleConnectionTimeout(cfg.getIdleConnectionTimeout());
        c.setFailedSlaveCheckInterval(cfg.getFailedSlaveCheckInterval());
        c.setFailedSlaveReconnectionInterval(cfg.getFailedSlaveReconnectionInterval());
        c.setMasterConnectionMinimumIdleSize(cfg.getMasterConnectionMinimumIdleSize());
        c.setSlaveConnectionMinimumIdleSize(cfg.getSlaveConnectionMinimumIdleSize());
        c.setSubscriptionConnectionMinimumIdleSize(cfg.getSubscriptionConnectionMinimumIdleSize());
        c.setReadMode(cfg.getReadMode());
        c.setSubscriptionMode(cfg.getSubscriptionMode());
        c.setDnsMonitoringInterval(cfg.getDnsMonitoringInterval());
        c.setKeepAlive(cfg.isKeepAlive());
        return c;
    }

    @Override
    public RedisClient createClient(NodeType type, RedisURI address, String sslHostname) {
        RedisClient client = this.createClient(type, address, this.config.getConnectTimeout(), this.config.getTimeout(), sslHostname);
        return client;
    }

    @Override
    public RedisClient createClient(NodeType type, InetSocketAddress address, RedisURI uri, String sslHostname) {
        RedisClient client = this.createClient(type, address, uri, this.config.getConnectTimeout(), this.config.getTimeout(), sslHostname);
        return client;
    }

    @Override
    public RedisClient createClient(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig redisConfig = this.createRedisConfig(type, address, timeout, commandTimeout, sslHostname);
        return RedisClient.create(redisConfig);
    }

    private RedisClient createClient(NodeType type, InetSocketAddress address, RedisURI uri, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig redisConfig = this.createRedisConfig(type, null, timeout, commandTimeout, sslHostname);
        redisConfig.setAddress(address, uri);
        return RedisClient.create(redisConfig);
    }

    protected RedisClientConfig createRedisConfig(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig redisConfig = new RedisClientConfig();
        redisConfig.setAddress(address).setTimer(this.timer).setExecutor(this.executor).setResolverGroup(this.resolverGroup).setGroup(this.group).setSocketChannelClass(this.socketChannelClass).setConnectTimeout(timeout).setCommandTimeout(commandTimeout).setSslHostname(sslHostname).setSslEnableEndpointIdentification(this.config.isSslEnableEndpointIdentification()).setSslProvider(this.config.getSslProvider()).setSslTruststore(this.config.getSslTruststore()).setSslTruststorePassword(this.config.getSslTruststorePassword()).setSslKeystore(this.config.getSslKeystore()).setSslKeystorePassword(this.config.getSslKeystorePassword()).setClientName(this.config.getClientName()).setDecodeInExecutor(this.cfg.isDecodeInExecutor()).setKeepPubSubOrder(this.cfg.isKeepPubSubOrder()).setPingConnectionInterval(this.config.getPingConnectionInterval()).setKeepAlive(this.config.isKeepAlive()).setTcpNoDelay(this.config.isTcpNoDelay()).setPassword(this.config.getPassword());
        if (type != NodeType.SENTINEL) {
            redisConfig.setDatabase(this.config.getDatabase());
        }
        return redisConfig;
    }

    @Override
    public int calcSlot(String key) {
        return this.singleSlotRange.getStartSlot();
    }

    @Override
    public int calcSlot(byte[] key) {
        return this.singleSlotRange.getStartSlot();
    }

    @Override
    public MasterSlaveEntry getEntry(InetSocketAddress address) {
        for (MasterSlaveEntry entry : this.client2entry.values()) {
            InetSocketAddress addr = entry.getClient().getAddr();
            if (!addr.getAddress().equals(address.getAddress()) || addr.getPort() != address.getPort()) continue;
            return entry;
        }
        return null;
    }

    private MasterSlaveEntry getEntry(RedisURI addr) {
        for (MasterSlaveEntry entry : this.client2entry.values()) {
            if (RedisURI.compare(entry.getClient().getAddr(), addr)) {
                return entry;
            }
            if (!entry.hasSlave(addr)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public MasterSlaveEntry getEntry(RedisClient redisClient) {
        MasterSlaveEntry entry = this.client2entry.get(redisClient);
        if (entry != null) {
            return entry;
        }
        for (MasterSlaveEntry mentry : this.client2entry.values()) {
            if (!mentry.hasSlave(redisClient)) continue;
            return mentry;
        }
        return null;
    }

    @Override
    public MasterSlaveEntry getEntry(int slot) {
        return this.slot2entry.get(slot);
    }

    protected final RFuture<RedisClient> changeMaster(int slot, RedisURI address) {
        MasterSlaveEntry entry = this.getEntry(slot);
        RedisClient oldClient = entry.getClient();
        RFuture<RedisClient> future = entry.changeMaster(address);
        future.onComplete((res, e) -> {
            if (e == null) {
                this.client2entry.remove(oldClient);
                this.client2entry.put(entry.getClient(), entry);
            }
        });
        return future;
    }

    protected final void addEntry(Integer slot, MasterSlaveEntry entry) {
        MasterSlaveEntry oldEntry = this.slot2entry.getAndSet(slot, entry);
        if (oldEntry != entry) {
            entry.incReference();
        }
        this.client2entry.put(entry.getClient(), entry);
    }

    protected final MasterSlaveEntry removeEntry(Integer slot) {
        MasterSlaveEntry entry = this.slot2entry.getAndSet(slot, null);
        if (entry.decReference() == 0) {
            this.client2entry.remove(entry.getClient());
        }
        return entry;
    }

    @Override
    public RFuture<RedisConnection> connectionWriteOp(NodeSource source, RedisCommand<?> command) {
        MasterSlaveEntry entry = this.getEntry(source);
        if (entry == null) {
            RedisNodeNotFoundException ex = new RedisNodeNotFoundException("Node: " + source + " hasn't been discovered yet");
            return RedissonPromise.newFailedFuture(ex);
        }
        if (source.getRedirect() != null && !RedisURI.compare(entry.getClient().getAddr(), source.getAddr()) && entry.hasSlave(source.getAddr())) {
            return entry.redirectedConnectionWriteOp(command, source.getAddr());
        }
        return entry.connectionWriteOp(command);
    }

    private MasterSlaveEntry getEntry(NodeSource source) {
        if (source.getRedirect() != null) {
            return this.getEntry(source.getAddr());
        }
        MasterSlaveEntry entry = source.getEntry();
        if (source.getRedisClient() != null) {
            entry = this.getEntry(source.getRedisClient());
        }
        if (entry == null && source.getSlot() != null) {
            entry = this.getEntry(source.getSlot());
        }
        return entry;
    }

    @Override
    public RFuture<RedisConnection> connectionReadOp(NodeSource source, RedisCommand<?> command) {
        MasterSlaveEntry entry = this.getEntry(source);
        if (entry == null) {
            RedisNodeNotFoundException ex = new RedisNodeNotFoundException("Node: " + source + " hasn't been discovered yet");
            return RedissonPromise.newFailedFuture(ex);
        }
        if (source.getRedirect() != null) {
            return entry.connectionReadOp(command, source.getAddr());
        }
        if (source.getRedisClient() != null) {
            return entry.connectionReadOp(command, source.getRedisClient());
        }
        return entry.connectionReadOp(command);
    }

    @Override
    public void releaseWrite(NodeSource source, RedisConnection connection) {
        MasterSlaveEntry entry = this.getEntry(source);
        if (entry == null) {
            this.log.error("Node: " + source + " can't be found");
        } else {
            entry.releaseWrite(connection);
        }
    }

    @Override
    public void releaseRead(NodeSource source, RedisConnection connection) {
        MasterSlaveEntry entry = this.getEntry(source);
        if (entry == null) {
            this.log.error("Node: " + source + " can't be found");
        } else {
            entry.releaseRead(connection);
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(0L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown(long quietPeriod, long timeout, TimeUnit unit) {
        if (this.dnsMonitor != null) {
            this.dnsMonitor.stop();
        }
        this.connectionWatcher.stop();
        if (this.cfg.getExecutor() == null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        RedissonPromise result = new RedissonPromise();
        CountableListener<Object> listener = new CountableListener<Object>(result, null, this.getEntrySet().size());
        for (MasterSlaveEntry entry : this.getEntrySet()) {
            entry.shutdownAsync().onComplete(listener);
        }
        result.awaitUninterruptibly(timeout, unit);
        this.resolverGroup.close();
        this.timer.stop();
        this.shutdownLatch.close();
        this.shutdownPromise.trySuccess(null);
        this.shutdownLatch.awaitUninterruptibly();
        if (this.cfg.getEventLoopGroup() == null) {
            this.group.shutdownGracefully(quietPeriod, timeout, unit).syncUninterruptibly();
        }
    }

    @Override
    public boolean isShuttingDown() {
        return this.shutdownLatch.isClosed();
    }

    @Override
    public boolean isShutdown() {
        return this.group.isTerminated();
    }

    @Override
    public EventLoopGroup getGroup() {
        return this.group;
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        try {
            return this.timer.newTimeout(task, delay, unit);
        }
        catch (IllegalStateException e) {
            return DUMMY_TIMEOUT;
        }
    }

    @Override
    public InfinitySemaphoreLatch getShutdownLatch() {
        return this.shutdownLatch;
    }

    @Override
    public Future<Void> getShutdownPromise() {
        return this.shutdownPromise;
    }

    @Override
    public ConnectionEventsHub getConnectionEventsHub() {
        return this.connectionEventsHub;
    }

    protected void stopThreads() {
        this.shutdown();
    }

    @Override
    public PublishSubscribeService getSubscribeService() {
        return this.subscribeService;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public RedisURI getLastClusterNode() {
        return null;
    }

    @Override
    public RedisURI applyNatMap(RedisURI address) {
        return address;
    }
}

