/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.set;

import org.redisson.RedissonSet;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.set.SetOperation;

public class RemoveOperation
extends SetOperation {
    private Object value;

    public RemoveOperation(RObject set, Object value, String transactionId) {
        this(set.getName(), set.getCodec(), value, transactionId);
    }

    public RemoveOperation(String name, Codec codec, Object value, String transactionId) {
        super(name, codec, transactionId);
        this.value = value;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonSet set = new RedissonSet(this.codec, commandExecutor, this.name, null);
        set.removeAsync(this.value);
        this.getLock(set, commandExecutor, this.value).unlockAsync();
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonSet set = new RedissonSet(this.codec, commandExecutor, this.name, null);
        this.getLock(set, commandExecutor, this.value).unlockAsync();
    }

    public Object getValue() {
        return this.value;
    }
}

