/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.decoder.DecoderState;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class ListMultiDecoder<T>
implements MultiDecoder<Object> {
    public static final Decoder<Object> RESET = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            return null;
        }
    };
    public static final Decoder<Object> RESET_1 = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            return null;
        }
    };
    public static final Decoder<Object> RESET_INDEX = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            return null;
        }
    };
    private final MultiDecoder<?>[] decoders;
    private Integer fixedIndex;

    protected final NestedDecoderState getDecoder(State state) {
        NestedDecoderState ds = (NestedDecoderState)state.getDecoderState();
        if (ds == null) {
            ds = new NestedDecoderState();
            state.setDecoderState(ds);
        }
        return ds;
    }

    public ListMultiDecoder(MultiDecoder<?> ... decoders) {
        this.decoders = decoders;
    }

    public ListMultiDecoder(Integer fixedIndex, MultiDecoder<?> ... decoders) {
        this.fixedIndex = fixedIndex;
        this.decoders = decoders;
    }

    @Override
    public Decoder<Object> getDecoder(int paramNum, State state) {
        Decoder<Object> decoder;
        int index;
        if (paramNum == 0) {
            NestedDecoderState s = this.getDecoder(state);
            if (this.fixedIndex != null) {
                s.setIndex(this.fixedIndex);
            } else {
                s.incIndex();
            }
            s.resetPartsIndex();
        }
        if ((index = this.getDecoder(state).getIndex()) == -1) {
            this.getDecoder(state).setIndex(0);
            index = 0;
        }
        if ((decoder = this.decoders[index].getDecoder(paramNum, state)) == RESET) {
            NestedDecoderState s = this.getDecoder(state);
            s.setIndex(0);
            int ind = s.getIndex();
            return this.decoders[ind].getDecoder(paramNum, state);
        }
        if (decoder == RESET_1) {
            NestedDecoderState s = this.getDecoder(state);
            s.setIndex(1);
            int ind = s.getIndex();
            return this.decoders[ind].getDecoder(paramNum, state);
        }
        return decoder;
    }

    @Override
    public Object decode(List<Object> parts, State state) {
        NestedDecoderState s = this.getDecoder(state);
        int index = s.getIndex();
        index += s.incPartsIndex();
        if (this.fixedIndex != null && parts.isEmpty()) {
            s.resetPartsIndex();
        }
        if (index == -1 || this.fixedIndex != null && state.getLevel() == 0) {
            return this.decoders[this.decoders.length - 1].decode(parts, state);
        }
        Object res = this.decoders[index].decode(parts, state);
        if (res == null) {
            index = s.incIndex() + s.getPartsIndex();
            return this.decoders[index].decode(parts, state);
        }
        Decoder<Object> decoder = this.decoders[index].getDecoder(0, state);
        if (decoder == RESET_INDEX) {
            s.setIndex(-1);
        }
        return res;
    }

    public static class NestedDecoderState
    implements DecoderState {
        int index = -1;
        int partsIndex = -1;

        public NestedDecoderState() {
        }

        public NestedDecoderState(int index) {
            this.index = index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void resetPartsIndex() {
            this.partsIndex = -1;
        }

        public int incPartsIndex() {
            return ++this.partsIndex;
        }

        public int getPartsIndex() {
            return this.partsIndex;
        }

        public int incIndex() {
            return ++this.index;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public DecoderState copy() {
            return new NestedDecoderState(this.index);
        }

        public String toString() {
            return "NestedDecoderState [index=" + this.index + "]";
        }
    }
}

