/*
 * Decompiled with CFR 0.152.
 */
package jodd.crypt;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import jodd.io.StreamUtil;
import jodd.util.StringUtil;

public interface DigestEngine {
    public static DigestEngine md2() {
        return new JavaDigestEngine("MD2");
    }

    public static DigestEngine md5() {
        return new JavaDigestEngine("MD5");
    }

    public static DigestEngine sha1() {
        return new JavaDigestEngine("SHA-1");
    }

    public static DigestEngine sha256() {
        return new JavaDigestEngine("SHA-256");
    }

    public static DigestEngine sha384() {
        return new JavaDigestEngine("SHA-384");
    }

    public static DigestEngine sha512() {
        return new JavaDigestEngine("SHA-512");
    }

    public byte[] digest(byte[] var1);

    default public byte[] digest(String input) {
        return this.digest(StringUtil.getBytes(input));
    }

    public byte[] digest(File var1) throws IOException;

    default public String digestString(byte[] byteArray) {
        return StringUtil.toHexString(this.digest(byteArray));
    }

    default public String digestString(String input) {
        return StringUtil.toHexString(this.digest(input));
    }

    default public String digestString(File file) throws IOException {
        return StringUtil.toHexString(this.digest(file));
    }

    public static class JavaDigestEngine
    implements DigestEngine {
        private MessageDigest messageDigest;

        JavaDigestEngine(String algorithm) {
            try {
                this.messageDigest = MessageDigest.getInstance(algorithm);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] digest(byte[] byteArray) {
            this.messageDigest.update(byteArray);
            return this.messageDigest.digest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] digest(File file) throws IOException {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            DigestInputStream dis = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                dis = new DigestInputStream(bis, this.messageDigest);
                while (dis.read() != -1) {
                }
            }
            catch (Throwable throwable) {
                StreamUtil.close(dis);
                StreamUtil.close(bis);
                StreamUtil.close(fis);
                throw throwable;
            }
            StreamUtil.close(dis);
            StreamUtil.close(bis);
            StreamUtil.close(fis);
            return this.messageDigest.digest();
        }
    }
}

