/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.bucket;

import org.redisson.RedissonBucket;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;

public class BucketGetAndDeleteOperation<V>
extends TransactionalOperation {
    private String lockName;
    private String transactionId;

    public BucketGetAndDeleteOperation(String name, String lockName, Codec codec, String transactionId) {
        super(name, codec);
        this.lockName = lockName;
        this.transactionId = transactionId;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonBucket bucket = new RedissonBucket(this.codec, commandExecutor, this.name);
        bucket.getAndDeleteAsync();
        RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
        lock.unlockAsync();
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
        lock.unlockAsync();
    }

    public String getLockName() {
        return this.lockName;
    }
}

