/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.eviction;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.command.CommandAsyncExecutor;

abstract class EvictionTask
implements Runnable {
    final Deque<Integer> sizeHistory = new LinkedList<Integer>();
    final int minDelay;
    final int maxDelay;
    final int keysLimit = 100;
    int delay = 5;
    final CommandAsyncExecutor executor;

    EvictionTask(CommandAsyncExecutor executor) {
        this.executor = executor;
        this.minDelay = executor.getConnectionManager().getCfg().getMinCleanUpDelay();
        this.maxDelay = executor.getConnectionManager().getCfg().getMaxCleanUpDelay();
    }

    public void schedule() {
        this.executor.getConnectionManager().getGroup().schedule(this, (long)this.delay, TimeUnit.SECONDS);
    }

    abstract RFuture<Integer> execute();

    @Override
    public void run() {
        if (this.executor.getConnectionManager().isShuttingDown()) {
            return;
        }
        RFuture<Integer> future = this.execute();
        future.onComplete((size, e) -> {
            if (e != null) {
                this.schedule();
                return;
            }
            if (size == -1) {
                this.schedule();
                return;
            }
            if (this.sizeHistory.size() == 2) {
                if (this.sizeHistory.peekFirst() > this.sizeHistory.peekLast() && this.sizeHistory.peekLast() > size) {
                    this.delay = Math.min(this.maxDelay, (int)((double)this.delay * 1.5));
                }
                if (this.sizeHistory.peekFirst().intValue() == this.sizeHistory.peekLast().intValue() && this.sizeHistory.peekLast().intValue() == size.intValue()) {
                    if (size >= 100) {
                        this.delay = Math.max(this.minDelay, this.delay / 4);
                    }
                    if (size == 0) {
                        this.delay = Math.min(this.maxDelay, (int)((double)this.delay * 1.5));
                    }
                }
                this.sizeHistory.pollFirst();
            }
            this.sizeHistory.add((Integer)size);
            this.schedule();
        });
    }
}

