/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.bucket;

import org.redisson.RedissonBucket;
import org.redisson.RedissonLock;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.TransactionalOperation;

public class BucketGetAndDeleteOperation<V>
extends TransactionalOperation {
    private String lockName;

    public BucketGetAndDeleteOperation(String name, String lockName, Codec codec) {
        super(name, codec);
        this.lockName = lockName;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonBucket bucket = new RedissonBucket(this.codec, commandExecutor, this.name);
        bucket.getAndDeleteAsync();
        RedissonLock lock = new RedissonLock(commandExecutor, this.lockName);
        lock.unlockAsync();
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonLock lock = new RedissonLock(commandExecutor, this.lockName);
        lock.unlockAsync();
    }

    public String getLockName() {
        return this.lockName;
    }
}

