/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.reactivex.Flowable;
import io.reactivex.functions.Action;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.ReplayProcessor;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RFuture;
import org.redisson.api.RTopic;
import org.redisson.api.listener.MessageListener;

public class RedissonTopicRx {
    private final RTopic topic;

    public RedissonTopicRx(RTopic topic) {
        this.topic = topic;
    }

    public <M> Flowable<M> getMessages(final Class<M> type) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){

            @Override
            public void accept(long n) throws Exception {
                final AtomicLong counter = new AtomicLong(n);
                RFuture<Integer> t = RedissonTopicRx.this.topic.addListenerAsync(type, new MessageListener<M>(){

                    @Override
                    public void onMessage(CharSequence channel, M msg) {
                        p.onNext(msg);
                        if (counter.decrementAndGet() == 0L) {
                            RedissonTopicRx.this.topic.removeListenerAsync(this);
                            p.onComplete();
                        }
                    }
                });
                t.addListener(new FutureListener<Integer>(){

                    @Override
                    public void operationComplete(Future<Integer> future) throws Exception {
                        if (!future.isSuccess()) {
                            p.onError(future.cause());
                            return;
                        }
                        final Integer id = future.getNow();
                        p.doOnCancel(new Action(){

                            @Override
                            public void run() throws Exception {
                                RedissonTopicRx.this.topic.removeListenerAsync(id);
                            }
                        });
                    }
                });
            }
        });
    }
}

