/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.reactivex.Flowable;
import io.reactivex.functions.Action;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.ReplayProcessor;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RFuture;

public class ElementsStream {
    public static <V> Flowable<V> takeElements(final Callable<RFuture<V>> callable) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){

            @Override
            public void accept(long n) throws Exception {
                AtomicLong counter = new AtomicLong(n);
                final AtomicReference futureRef = new AtomicReference();
                ElementsStream.take(callable, p, counter, futureRef);
                p.doOnCancel(new Action(){

                    @Override
                    public void run() throws Exception {
                        ((RFuture)futureRef.get()).cancel(true);
                    }
                });
            }
        });
    }

    private static <V> void take(final Callable<RFuture<V>> factory, final ReplayProcessor<V> p, final AtomicLong counter, final AtomicReference<RFuture<V>> futureRef) throws Exception {
        RFuture<V> future = factory.call();
        futureRef.set(future);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    p.onError(future.cause());
                    return;
                }
                p.onNext(future.getNow());
                if (counter.decrementAndGet() == 0L) {
                    p.onComplete();
                }
                ElementsStream.take(factory, p, counter, futureRef);
            }
        });
    }
}

