/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.handler.CommandDecoder;
import org.redisson.client.handler.PubSubEntry;
import org.redisson.client.handler.PubSubKey;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListObjectDecoder;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.pubsub.Message;
import org.redisson.client.protocol.pubsub.PubSubMessage;
import org.redisson.client.protocol.pubsub.PubSubPatternMessage;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;
import org.redisson.misc.LogHelper;

public class CommandPubSubDecoder
extends CommandDecoder {
    private static final Set<String> MESSAGES = new HashSet<String>(Arrays.asList("subscribe", "psubscribe", "punsubscribe", "unsubscribe"));
    private final Map<ChannelName, PubSubEntry> entries = new HashMap<ChannelName, PubSubEntry>();
    private final Map<PubSubKey, CommandData<Object, Object>> commands = PlatformDependent.newConcurrentHashMap();
    private final boolean keepOrder;

    public CommandPubSubDecoder(ExecutorService executor, boolean keepOrder, boolean decodeInExecutor) {
        super(executor, decodeInExecutor);
        this.keepOrder = keepOrder;
    }

    public void addPubSubCommand(ChannelName channel, CommandData<Object, Object> data) {
        String operation = data.getCommand().getName().toLowerCase();
        this.commands.put(new PubSubKey(channel, operation), data);
    }

    @Override
    protected void decodeCommand(Channel channel, ByteBuf in, QueueCommand data) throws Exception {
        if (data == null) {
            try {
                while (in.writerIndex() > in.readerIndex()) {
                    this.decode(in, null, null, channel, false, null);
                }
                this.sendNext(channel);
            }
            catch (Exception e) {
                this.log.error("Unable to decode data. channel: " + channel + ", reply: " + LogHelper.toString(in), e);
                this.sendNext(channel);
                throw e;
            }
        }
        if (data instanceof CommandData) {
            CommandData cmd = (CommandData)data;
            try {
                while (in.writerIndex() > in.readerIndex()) {
                    this.decode(in, cmd, null, channel, false, null);
                }
                this.sendNext(channel, data);
            }
            catch (Exception e) {
                this.log.error("Unable to decode data. channel: " + channel + ", reply: " + LogHelper.toString(in), e);
                cmd.tryFailure(e);
                this.sendNext(channel);
                throw e;
            }
        }
    }

    @Override
    protected void decodeResult(CommandData<Object, Object> data, List<Object> parts, Channel channel, final Object result) throws IOException {
        if (this.executor.isShutdown()) {
            return;
        }
        if (result instanceof Message) {
            this.checkpoint();
            final RedisPubSubConnection pubSubConnection = (RedisPubSubConnection)RedisPubSubConnection.getFrom(channel);
            ChannelName channelName = ((Message)result).getChannel();
            if (result instanceof PubSubStatusMessage) {
                String operation = ((PubSubStatusMessage)result).getType().name().toLowerCase();
                PubSubKey key = new PubSubKey(channelName, operation);
                CommandData<Object, Object> d = this.commands.get(key);
                if (Arrays.asList(RedisCommands.PSUBSCRIBE.getName(), RedisCommands.SUBSCRIBE.getName()).contains(d.getCommand().getName())) {
                    this.commands.remove(key);
                    this.entries.put(channelName, new PubSubEntry(d.getMessageDecoder()));
                }
                if (Arrays.asList(RedisCommands.PUNSUBSCRIBE.getName(), RedisCommands.UNSUBSCRIBE.getName()).contains(d.getCommand().getName())) {
                    this.commands.remove(key);
                    if (result instanceof PubSubPatternMessage) {
                        channelName = ((PubSubPatternMessage)result).getPattern();
                    }
                    PubSubEntry entry = this.entries.remove(channelName);
                    if (this.keepOrder) {
                        this.enqueueMessage(result, pubSubConnection, entry);
                    }
                }
            }
            if (this.keepOrder) {
                PubSubEntry entry;
                if (result instanceof PubSubPatternMessage) {
                    channelName = ((PubSubPatternMessage)result).getPattern();
                }
                if ((entry = this.entries.get(channelName)) != null) {
                    this.enqueueMessage(result, pubSubConnection, entry);
                }
            } else {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (result instanceof PubSubStatusMessage) {
                            pubSubConnection.onMessage((PubSubStatusMessage)result);
                        } else if (result instanceof PubSubMessage) {
                            pubSubConnection.onMessage((PubSubMessage)result);
                        } else if (result instanceof PubSubPatternMessage) {
                            pubSubConnection.onMessage((PubSubPatternMessage)result);
                        }
                    }
                });
            }
        } else if (data != null && data.getCommand().getName().equals("PING")) {
            super.decodeResult(data, parts, channel, result);
        }
    }

    private void enqueueMessage(Object result, final RedisPubSubConnection pubSubConnection, final PubSubEntry entry) {
        if (result != null) {
            entry.getQueue().add((Message)result);
        }
        if (entry.getSent().compareAndSet(false, true)) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Message result;
                        while ((result = entry.getQueue().poll()) != null) {
                            if (result instanceof PubSubStatusMessage) {
                                pubSubConnection.onMessage((PubSubStatusMessage)result);
                                continue;
                            }
                            if (result instanceof PubSubMessage) {
                                pubSubConnection.onMessage((PubSubMessage)result);
                                continue;
                            }
                            if (!(result instanceof PubSubPatternMessage)) continue;
                            pubSubConnection.onMessage((PubSubPatternMessage)result);
                        }
                    }
                    finally {
                        entry.getSent().set(false);
                        if (!entry.getQueue().isEmpty()) {
                            CommandPubSubDecoder.this.enqueueMessage(null, pubSubConnection, entry);
                        }
                    }
                }
            });
        }
    }

    @Override
    protected MultiDecoder<Object> messageDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (parts.isEmpty()) {
            return null;
        }
        String command = parts.get(0).toString();
        if (MESSAGES.contains(command)) {
            ChannelName channelName = new ChannelName((byte[])parts.get(1));
            PubSubKey key = new PubSubKey(channelName, command);
            CommandData<Object, Object> commandData = this.commands.get(key);
            if (commandData == null) {
                return null;
            }
            return commandData.getCommand().getReplayMultiDecoder();
        }
        if (command.equals("message")) {
            byte[] channelName = (byte[])parts.get(1);
            return this.entries.get(new ChannelName(channelName)).getDecoder();
        }
        if (command.equals("pmessage")) {
            byte[] patternName = (byte[])parts.get(1);
            return this.entries.get(new ChannelName(patternName)).getDecoder();
        }
        if (command.equals("pong")) {
            return new ListObjectDecoder<Object>(0);
        }
        return data.getCommand().getReplayMultiDecoder();
    }

    @Override
    protected Decoder<Object> selectDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (parts != null) {
            if (data != null && parts.size() == 1 && "pong".equals(parts.get(0))) {
                return data.getCodec().getValueDecoder();
            }
            if (parts.size() == 1) {
                return ByteArrayCodec.INSTANCE.getValueDecoder();
            }
            if (parts.size() == 2 && "pmessage".equals(parts.get(0))) {
                return ByteArrayCodec.INSTANCE.getValueDecoder();
            }
            if (parts.size() == 2 && "message".equals(parts.get(0))) {
                byte[] channelName = (byte[])parts.get(1);
                return this.getDecoder(parts, channelName);
            }
            if (parts.size() == 3 && "pmessage".equals(parts.get(0))) {
                byte[] patternName = (byte[])parts.get(1);
                return this.getDecoder(parts, patternName);
            }
        }
        if (data != null && data.getCommand().getName().equals(RedisCommands.PING.getName())) {
            return data.getCodec().getValueDecoder();
        }
        return super.selectDecoder(data, parts);
    }

    private Decoder<Object> getDecoder(List<Object> parts, byte[] name) {
        PubSubEntry entry = this.entries.get(new ChannelName(name));
        if (entry != null) {
            return entry.getDecoder().getDecoder(parts.size(), (State)this.state());
        }
        return ByteArrayCodec.INSTANCE.getValueDecoder();
    }
}

