/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisOutOfMemoryException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.RedisTryAgainException;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.misc.LogHelper;
import org.redisson.misc.RPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandDecoder
extends ReplayingDecoder<State> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char ZERO = '0';
    final ExecutorService executor;
    private final boolean decodeInExecutor;
    private final ThreadLocal<Status> decoderStatus = new ThreadLocal<Status>(){

        @Override
        protected Status initialValue() {
            return Status.NORMAL;
        }
    };
    private final ThreadLocal<State> state = new ThreadLocal();

    public CommandDecoder(ExecutorService executor, boolean decodeInExecutor) {
        this.decodeInExecutor = decodeInExecutor;
        this.executor = executor;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        final QueueCommand data = ctx.channel().attr(CommandsQueue.CURRENT_COMMAND).get();
        if (this.log.isTraceEnabled()) {
            this.log.trace("reply: {}, channel: {}, command: {}", in.toString(0, in.writerIndex(), CharsetUtil.UTF_8), ctx.channel(), data);
        }
        if (this.state.get() == null) {
            this.state.set(new State());
        }
        this.state.get().setDecoderState(null);
        in.markReaderIndex();
        this.decodeCommand(ctx.channel(), in, data);
        if (this.decoderStatus.get() == Status.FILL_BUFFER) {
            in.resetReaderIndex();
            final ByteBuf copy = ByteBufAllocator.DEFAULT.buffer(in.writerIndex());
            in.readBytes(copy);
            this.state.set(null);
            this.decoderStatus.set(Status.NORMAL);
            final Channel channel = ctx.channel();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    CommandDecoder.this.decoderStatus.set(Status.DECODE_BUFFER);
                    CommandDecoder.this.state.set(new State());
                    ((State)CommandDecoder.this.state.get()).setDecoderState(null);
                    try {
                        CommandDecoder.this.decodeCommand(channel, copy, data);
                    }
                    catch (Exception e) {
                        CommandDecoder.this.log.error("Unable to decode data in separate thread: " + LogHelper.toString(data), e);
                    }
                    finally {
                        copy.release();
                        CommandDecoder.this.decoderStatus.remove();
                        CommandDecoder.this.state.remove();
                    }
                }
            });
        }
    }

    protected void sendNext(Channel channel, QueueCommand data) {
        if (data != null) {
            if (this.decoderStatus.get() == Status.FILL_BUFFER || data.isExecuted()) {
                this.sendNext(channel);
            }
        } else {
            this.sendNext(channel);
        }
    }

    protected void decodeCommand(Channel channel, ByteBuf in, QueueCommand data) throws Exception {
        if (data instanceof CommandData) {
            CommandData cmd = (CommandData)data;
            try {
                this.decode(in, cmd, null, channel, false, null);
                this.sendNext(channel, data);
            }
            catch (Exception e) {
                this.log.error("Unable to decode data. channel: " + channel + ", reply: " + LogHelper.toString(in) + ", command: " + LogHelper.toString(data), e);
                cmd.tryFailure(e);
                this.decoderStatus.set(Status.NORMAL);
                this.sendNext(channel);
                throw e;
            }
        }
        if (data instanceof CommandsData) {
            CommandsData commands = (CommandsData)data;
            try {
                this.decodeCommandBatch(channel, in, data, commands);
            }
            catch (Exception e) {
                commands.getPromise().tryFailure(e);
                this.decoderStatus.set(Status.NORMAL);
                this.sendNext(channel);
                throw e;
            }
        }
        try {
            while (in.writerIndex() > in.readerIndex()) {
                this.decode(in, null, null, channel, false, null);
            }
            this.sendNext(channel);
        }
        catch (Exception e) {
            this.log.error("Unable to decode data. channel: " + channel + ", reply: " + LogHelper.toString(in), e);
            this.decoderStatus.set(Status.NORMAL);
            this.sendNext(channel);
            throw e;
        }
    }

    protected void sendNext(Channel channel) {
        if (this.decoderStatus.get() != Status.DECODE_BUFFER) {
            channel.pipeline().get(CommandsQueue.class).sendNextCommand(channel);
            this.state.set(null);
        }
    }

    private void decodeCommandBatch(Channel channel, ByteBuf in, QueueCommand data, CommandsData commandBatch) throws Exception {
        int i = 0;
        if (this.decoderStatus.get() != Status.DECODE_BUFFER) {
            i = this.state.get().getBatchIndex();
        }
        Throwable error = null;
        while (in.writerIndex() > in.readerIndex()) {
            CommandData<Object, Object> commandData;
            block20: {
                commandData = null;
                try {
                    if (this.decoderStatus.get() != Status.DECODE_BUFFER) {
                        this.checkpoint();
                        this.state.get().setBatchIndex(i);
                    }
                    RedisCommand<?> cmd = commandBatch.getCommands().get(i).getCommand();
                    boolean skipConvertor = commandBatch.isQueued();
                    List<CommandData<?, ?>> commandsData = null;
                    if (!commandBatch.isAtomic() || RedisCommands.EXEC.getName().equals(cmd.getName()) || RedisCommands.WAIT.getName().equals(cmd.getName())) {
                        commandData = commandBatch.getCommands().get(i);
                        if (RedisCommands.EXEC.getName().equals(cmd.getName())) {
                            skipConvertor = false;
                            commandsData = commandBatch.getAttachedCommands() != null ? commandBatch.getAttachedCommands() : commandBatch.getCommands();
                        }
                    }
                    this.decode(in, commandData, null, channel, skipConvertor, commandsData);
                    if (commandData == null || !RedisCommands.EXEC.getName().equals(commandData.getCommand().getName()) || !commandData.getPromise().isSuccess()) break block20;
                    List objects = (List)commandData.getPromise().getNow();
                    Iterator iter = objects.iterator();
                    boolean multiFound = false;
                    for (CommandData<Object, Object> commandData2 : commandBatch.getCommands()) {
                        if (multiFound) {
                            if (!iter.hasNext()) break;
                            Object res = iter.next();
                            this.completeResponse(commandData2, res, channel);
                        }
                        if (!RedisCommands.MULTI.getName().equals(commandData2.getCommand().getName())) continue;
                        multiFound = true;
                    }
                }
                catch (Exception e) {
                    if (commandData != null) {
                        commandData.tryFailure(e);
                    }
                    throw e;
                }
            }
            ++i;
            if (commandData == null || commandData.isSuccess()) continue;
            error = commandData.cause();
        }
        if (commandBatch.isSkipResult() || i == commandBatch.getCommands().size()) {
            if (this.decoderStatus.get() != Status.FILL_BUFFER) {
                RPromise<Void> promise = commandBatch.getPromise();
                if (error != null) {
                    if (!promise.tryFailure(error) && promise.cause() instanceof RedisTimeoutException) {
                        this.log.warn("response has been skipped due to timeout! channel: {}, command: {}", (Object)channel, (Object)LogHelper.toString(data));
                    }
                } else if (!promise.trySuccess(null) && promise.cause() instanceof RedisTimeoutException) {
                    this.log.warn("response has been skipped due to timeout! channel: {}, command: {}", (Object)channel, (Object)LogHelper.toString(data));
                }
            }
            this.sendNext(channel);
        } else if (this.decoderStatus.get() != Status.DECODE_BUFFER) {
            this.checkpoint();
            this.state.get().setBatchIndex(i);
        }
    }

    protected void decode(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, Channel channel, boolean skipConvertor, List<CommandData<?, ?>> commandsData) throws IOException {
        byte code = in.readByte();
        if (code == 43) {
            String result = this.readString(in);
            this.handleResult(data, parts, result, skipConvertor, channel);
        } else if (code == 45) {
            String error = this.readString(in);
            if (error.startsWith("MOVED")) {
                String[] errorParts = error.split(" ");
                int slot = Integer.valueOf(errorParts[1]);
                String addr = errorParts[2];
                data.tryFailure(new RedisMovedException(slot, addr));
            } else if (error.startsWith("ASK")) {
                String[] errorParts = error.split(" ");
                int slot = Integer.valueOf(errorParts[1]);
                String addr = errorParts[2];
                data.tryFailure(new RedisAskException(slot, addr));
            } else if (error.startsWith("TRYAGAIN")) {
                data.tryFailure(new RedisTryAgainException(error + ". channel: " + channel + " data: " + data));
            } else if (error.startsWith("LOADING")) {
                data.tryFailure(new RedisLoadingException(error + ". channel: " + channel + " data: " + data));
            } else if (error.startsWith("OOM")) {
                data.tryFailure(new RedisOutOfMemoryException(error.split("OOM ")[1] + ". channel: " + channel + " data: " + data));
            } else if (error.contains("-OOM ")) {
                data.tryFailure(new RedisOutOfMemoryException(error.split("-OOM ")[1] + ". channel: " + channel + " data: " + data));
            } else if (data != null) {
                data.tryFailure(new RedisException(error + ". channel: " + channel + " command: " + LogHelper.toString(data)));
            } else {
                this.log.error("Error message from Redis: {} channel: {}", (Object)error, (Object)channel);
            }
        } else if (code == 58) {
            Long result = this.readLong(in);
            this.handleResult(data, parts, result, false, channel);
        } else if (code == 36) {
            ByteBuf buf = this.readBytes(in);
            Object result = null;
            if (buf != null) {
                Decoder<Object> decoder = this.selectDecoder(data, parts);
                result = decoder.decode(buf, this.state.get());
            }
            this.handleResult(data, parts, result, false, channel);
        } else if (code == 42) {
            long size = this.readLong(in);
            ArrayList<Object> respParts = new ArrayList<Object>(Math.max((int)size, 0));
            this.state.get().incLevel();
            this.decodeList(in, data, parts, channel, size, respParts, skipConvertor, commandsData);
            this.state.get().decLevel();
        } else {
            String dataStr = in.toString(0, in.writerIndex(), CharsetUtil.UTF_8);
            throw new IllegalStateException("Can't decode replay: " + dataStr);
        }
    }

    private String readString(ByteBuf in) {
        int len = in.bytesBefore((byte)13);
        String result = in.toString(in.readerIndex(), len, CharsetUtil.UTF_8);
        in.skipBytes(len + 2);
        return result;
    }

    private void decodeList(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, Channel channel, long size, List<Object> respParts, boolean skipConvertor, List<CommandData<?, ?>> commandsData) throws IOException {
        MultiDecoder<Object> decoder;
        int i;
        if (parts == null && commandsData != null) {
            i = respParts.size();
            while ((long)i < size) {
                int suffix = 0;
                if (RedisCommands.MULTI.getName().equals(commandsData.get(0).getCommand().getName())) {
                    suffix = 1;
                }
                CommandData<Object, Object> commandData = commandsData.get(i + suffix);
                this.decode(in, commandData, respParts, channel, skipConvertor, commandsData);
                if (commandData.getPromise().isDone() && !commandData.getPromise().isSuccess()) {
                    data.tryFailure(commandData.cause());
                }
                ++i;
            }
        } else {
            i = respParts.size();
            while ((long)i < size) {
                this.decode(in, data, respParts, channel, skipConvertor, null);
                ++i;
            }
        }
        if ((decoder = this.messageDecoder(data, respParts)) == null) {
            return;
        }
        if (this.decoderStatus.get() == Status.FILL_BUFFER) {
            return;
        }
        Object result = decoder.decode(respParts, this.state.get());
        this.decodeResult(data, parts, channel, result);
    }

    protected void decodeResult(CommandData<Object, Object> data, List<Object> parts, Channel channel, Object result) throws IOException {
        if (data != null) {
            this.handleResult(data, parts, result, true, channel);
        }
    }

    private void handleResult(CommandData<Object, Object> data, List<Object> parts, Object result, boolean skipConvertor, Channel channel) {
        if (data != null && !skipConvertor && this.decoderStatus.get() != Status.FILL_BUFFER) {
            result = data.getCommand().getConvertor().convert(result);
        }
        if (parts != null) {
            parts.add(result);
        } else {
            this.completeResponse(data, result, channel);
        }
    }

    protected void completeResponse(CommandData<Object, Object> data, Object result, Channel channel) {
        if (this.decoderStatus.get() == Status.FILL_BUFFER) {
            return;
        }
        if (data != null && !data.getPromise().trySuccess(result) && data.cause() instanceof RedisTimeoutException) {
            this.log.warn("response has been skipped due to timeout! channel: {}, command: {}, result: {}", channel, LogHelper.toString(data), LogHelper.toString(result));
        }
    }

    protected MultiDecoder<Object> messageDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (data == null && parts.isEmpty()) {
            return null;
        }
        return data.getCommand().getReplayMultiDecoder();
    }

    protected Decoder<Object> selectDecoder(CommandData<Object, Object> data, List<Object> parts) {
        Decoder<Object> decoder;
        Decoder<Object> mDecoder;
        MultiDecoder<Object> multiDecoder;
        if (data == null) {
            return StringCodec.INSTANCE.getValueDecoder();
        }
        if (parts != null && (multiDecoder = data.getCommand().getReplayMultiDecoder()) != null && (mDecoder = multiDecoder.getDecoder(parts.size(), this.state.get())) != null) {
            return mDecoder;
        }
        Codec codec = data.getCodec();
        if (this.decodeInExecutor && !(codec instanceof StringCodec) && !(codec instanceof ByteArrayCodec)) {
            if (this.decoderStatus.get() == Status.NORMAL) {
                this.decoderStatus.set(Status.FILL_BUFFER);
                codec = NullCodec.INSTANCE;
            } else if (this.decoderStatus.get() == Status.FILL_BUFFER) {
                codec = NullCodec.INSTANCE;
            }
        }
        if ((decoder = data.getCommand().getReplayDecoder()) == null) {
            if (codec == null) {
                return StringCodec.INSTANCE.getValueDecoder();
            }
            if (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP) {
                if (parts != null && parts.size() % 2 != 0) {
                    return codec.getMapValueDecoder();
                }
                return codec.getMapKeyDecoder();
            }
            if (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP_KEY) {
                return codec.getMapKeyDecoder();
            }
            if (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP_VALUE) {
                return codec.getMapValueDecoder();
            }
            return codec.getValueDecoder();
        }
        return decoder;
    }

    private ByteBuf readBytes(ByteBuf is) throws IOException {
        long l = this.readLong(is);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        int size = (int)l;
        if (size == -1) {
            return null;
        }
        ByteBuf buffer = is.readSlice(size);
        byte cr = is.readByte();
        byte lf = is.readByte();
        if (cr != 13 || lf != 10) {
            throw new IOException("Improper line ending: " + cr + ", " + lf);
        }
        return buffer;
    }

    private long readLong(ByteBuf is) throws IOException {
        long size = 0L;
        int sign = 1;
        byte read = is.readByte();
        if (read == 45) {
            read = is.readByte();
            sign = -1;
        }
        while (read != 13 || is.readByte() != 10) {
            int value = read - 48;
            if (value >= 0 && value < 10) {
                size *= 10L;
                size += (long)value;
            } else {
                throw new IOException("Invalid character in integer");
            }
            read = is.readByte();
        }
        return size * (long)sign;
    }

    public static enum Status {
        NORMAL,
        FILL_BUFFER,
        DECODE_BUFFER;

    }

    public static class NullCodec
    extends BaseCodec {
        public static final NullCodec INSTANCE = new NullCodec();
        private final Decoder<Object> decoder = new Decoder<Object>(){

            @Override
            public Object decode(ByteBuf buf, State state) {
                return new Object();
            }
        };

        @Override
        public Decoder<Object> getValueDecoder() {
            return this.decoder;
        }

        @Override
        public Encoder getValueEncoder() {
            throw new UnsupportedOperationException();
        }
    }
}

