/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import io.netty.buffer.ByteBuf;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.redisson.RedissonLocalCachedMap;
import org.redisson.RedissonObject;
import org.redisson.cache.Cache;
import org.redisson.cache.CacheKey;

public class LocalCacheView<K, V> {
    private final RedissonObject object;
    private final Cache<CacheKey, RedissonLocalCachedMap.CacheValue> cache;

    public LocalCacheView(Cache<CacheKey, RedissonLocalCachedMap.CacheValue> cache, RedissonObject object) {
        this.cache = cache;
        this.object = object;
    }

    public Set<K> cachedKeySet() {
        return new LocalKeySet();
    }

    public Collection<V> cachedValues() {
        return new LocalValues();
    }

    public Set<Map.Entry<K, V>> cachedEntrySet() {
        return new LocalEntrySet();
    }

    public Map<K, V> getCachedMap() {
        return new LocalMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey toCacheKey(Object key) {
        ByteBuf encoded = this.object.encodeMapKey(key);
        try {
            CacheKey cacheKey = this.toCacheKey(encoded);
            return cacheKey;
        }
        finally {
            encoded.release();
        }
    }

    final class LocalMap
    extends AbstractMap<K, V> {
        LocalMap() {
        }

        @Override
        public V get(Object key) {
            CacheKey cacheKey = LocalCacheView.this.toCacheKey(key);
            RedissonLocalCachedMap.CacheValue e = (RedissonLocalCachedMap.CacheValue)LocalCacheView.this.cache.get(cacheKey);
            if (e != null) {
                return e.getValue();
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            CacheKey cacheKey = LocalCacheView.this.toCacheKey(key);
            return LocalCacheView.this.cache.containsKey(cacheKey);
        }

        @Override
        public boolean containsValue(Object value) {
            RedissonLocalCachedMap.CacheValue cacheValue = new RedissonLocalCachedMap.CacheValue(null, value);
            return LocalCacheView.this.cache.containsValue(cacheValue);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return LocalCacheView.this.cachedEntrySet();
        }
    }

    final class LocalEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        LocalEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<RedissonLocalCachedMap.CacheValue> iter;
                {
                    this.iter = LocalCacheView.this.cache.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    RedissonLocalCachedMap.CacheValue e = this.iter.next();
                    return new AbstractMap.SimpleEntry<Object, Object>(e.getKey(), e.getValue());
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            CacheKey cacheKey = LocalCacheView.this.toCacheKey(e.getKey());
            RedissonLocalCachedMap.CacheValue entry = (RedissonLocalCachedMap.CacheValue)LocalCacheView.this.cache.get(cacheKey);
            return entry != null && entry.getValue().equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                CacheKey cacheKey = LocalCacheView.this.toCacheKey(e.getKey());
                return LocalCacheView.this.cache.remove(cacheKey) != null;
            }
            return false;
        }

        @Override
        public int size() {
            return LocalCacheView.this.cache.size();
        }

        @Override
        public void clear() {
            LocalCacheView.this.cache.clear();
        }
    }

    final class LocalValues
    extends AbstractCollection<V> {
        LocalValues() {
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                Iterator<RedissonLocalCachedMap.CacheValue> iter;
                {
                    this.iter = LocalCacheView.this.cache.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public V next() {
                    return this.iter.next().getValue();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            RedissonLocalCachedMap.CacheValue cacheValue = new RedissonLocalCachedMap.CacheValue(null, o);
            return LocalCacheView.this.cache.containsValue(cacheValue);
        }

        @Override
        public int size() {
            return LocalCacheView.this.cache.size();
        }

        @Override
        public void clear() {
            LocalCacheView.this.cache.clear();
        }
    }

    class LocalKeySet
    extends AbstractSet<K> {
        LocalKeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                Iterator<RedissonLocalCachedMap.CacheValue> iter;
                {
                    this.iter = LocalCacheView.this.cache.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public K next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            CacheKey cacheKey = LocalCacheView.this.toCacheKey(o);
            return LocalCacheView.this.cache.containsKey(cacheKey);
        }

        @Override
        public boolean remove(Object o) {
            CacheKey cacheKey = LocalCacheView.this.toCacheKey(o);
            return LocalCacheView.this.cache.remove(cacheKey) != null;
        }

        @Override
        public int size() {
            return LocalCacheView.this.cache.size();
        }

        @Override
        public void clear() {
            LocalCacheView.this.cache.clear();
        }
    }
}

