/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.redisson.config.BaseConfig;
import org.redisson.misc.URIBuilder;

public class SingleServerConfig
extends BaseConfig<SingleServerConfig> {
    private List<URI> address;
    private int subscriptionConnectionMinimumIdleSize = 1;
    private int subscriptionConnectionPoolSize = 50;
    private int connectionMinimumIdleSize = 5;
    private int connectionPoolSize = 250;
    private int database = 0;
    private boolean dnsMonitoring = false;
    private long dnsMonitoringInterval = 5000L;

    SingleServerConfig() {
    }

    SingleServerConfig(SingleServerConfig config) {
        super(config);
        this.setAddress(config.getAddress());
        this.setConnectionPoolSize(config.getConnectionPoolSize());
        this.setSubscriptionConnectionPoolSize(config.getSubscriptionConnectionPoolSize());
        this.setDnsMonitoring(config.isDnsMonitoring());
        this.setDnsMonitoringInterval(config.getDnsMonitoringInterval());
        this.setSubscriptionConnectionMinimumIdleSize(config.getSubscriptionConnectionMinimumIdleSize());
        this.setConnectionMinimumIdleSize(config.getConnectionMinimumIdleSize());
        this.setDatabase(config.getDatabase());
    }

    public SingleServerConfig setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public SingleServerConfig setSubscriptionConnectionPoolSize(int subscriptionConnectionPoolSize) {
        this.subscriptionConnectionPoolSize = subscriptionConnectionPoolSize;
        return this;
    }

    public int getSubscriptionConnectionPoolSize() {
        return this.subscriptionConnectionPoolSize;
    }

    public SingleServerConfig setAddress(String address) {
        if (address != null) {
            this.address = Collections.singletonList(URIBuilder.create(address));
        }
        return this;
    }

    public URI getAddress() {
        if (this.address != null) {
            return this.address.get(0);
        }
        return null;
    }

    void setAddress(URI address) {
        if (address != null) {
            this.address = Collections.singletonList(address);
        }
    }

    public SingleServerConfig setDnsMonitoring(boolean dnsMonitoring) {
        this.dnsMonitoring = dnsMonitoring;
        return this;
    }

    public boolean isDnsMonitoring() {
        return this.dnsMonitoring;
    }

    public SingleServerConfig setDnsMonitoringInterval(long dnsMonitoringInterval) {
        this.dnsMonitoringInterval = dnsMonitoringInterval;
        return this;
    }

    public long getDnsMonitoringInterval() {
        return this.dnsMonitoringInterval;
    }

    public SingleServerConfig setSubscriptionConnectionMinimumIdleSize(int subscriptionConnectionMinimumIdleSize) {
        this.subscriptionConnectionMinimumIdleSize = subscriptionConnectionMinimumIdleSize;
        return this;
    }

    public int getSubscriptionConnectionMinimumIdleSize() {
        return this.subscriptionConnectionMinimumIdleSize;
    }

    public SingleServerConfig setConnectionMinimumIdleSize(int connectionMinimumIdleSize) {
        this.connectionMinimumIdleSize = connectionMinimumIdleSize;
        return this;
    }

    public int getConnectionMinimumIdleSize() {
        return this.connectionMinimumIdleSize;
    }

    public SingleServerConfig setDatabase(int database) {
        this.database = database;
        return this;
    }

    public int getDatabase() {
        return this.database;
    }
}

