/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.ElasticacheServersConfig;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.misc.RPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticacheConnectionManager
extends MasterSlaveConnectionManager {
    private static final String ROLE_KEY = "role:";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AtomicReference<URI> currentMaster = new AtomicReference();
    private final Map<URI, RedisConnection> nodeConnections = new HashMap<URI, RedisConnection>();
    private ScheduledFuture<?> monitorFuture;

    public ElasticacheConnectionManager(ElasticacheServersConfig cfg, Config config) {
        super(config);
        this.config = this.create(cfg);
        this.initTimer(this.config);
        for (URI addr : cfg.getNodeAddresses()) {
            RedisConnection connection = this.connect(cfg, addr);
            if (connection == null) continue;
            Role role = this.determineRole(connection.sync(RedisCommands.INFO_REPLICATION, new Object[0]));
            if (Role.master.equals((Object)role)) {
                if (this.currentMaster.get() != null) {
                    throw new RedisException("Multiple masters detected");
                }
                this.currentMaster.set(addr);
                this.log.info("{} is the master", (Object)addr);
                this.config.setMasterAddress(addr);
                continue;
            }
            this.log.info("{} is a slave", (Object)addr);
            this.config.addSlaveAddress(addr);
        }
        if (this.currentMaster.get() == null) {
            throw new RedisConnectionException("Can't connect to servers!");
        }
        this.init(this.config);
        this.monitorRoleChange(cfg);
    }

    @Override
    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig res = super.create(cfg);
        res.setDatabase(((ElasticacheServersConfig)cfg).getDatabase());
        return res;
    }

    private RedisConnection connect(ElasticacheServersConfig cfg, URI addr) {
        RedisConnection connection = this.nodeConnections.get(addr);
        if (connection != null) {
            return connection;
        }
        RedisClient client = this.createClient(addr.getHost(), addr.getPort(), cfg.getConnectTimeout(), cfg.getRetryInterval() * cfg.getRetryAttempts());
        try {
            connection = client.connect();
            RPromise future = this.newPromise();
            this.connectListener.onConnect(future, connection, null, this.config);
            future.syncUninterruptibly();
            this.nodeConnections.put(addr, connection);
        }
        catch (RedisConnectionException e) {
            this.log.warn(e.getMessage(), e);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return connection;
    }

    private void monitorRoleChange(final ElasticacheServersConfig cfg) {
        this.monitorFuture = GlobalEventExecutor.INSTANCE.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    URI master = (URI)ElasticacheConnectionManager.this.currentMaster.get();
                    ElasticacheConnectionManager.this.log.debug("Current master: {}", (Object)master);
                    for (URI addr : cfg.getNodeAddresses()) {
                        RedisConnection connection = ElasticacheConnectionManager.this.connect(cfg, addr);
                        String replInfo = connection.sync(RedisCommands.INFO_REPLICATION, new Object[0]);
                        ElasticacheConnectionManager.this.log.trace("{} repl info: {}", (Object)addr, (Object)replInfo);
                        Role role = ElasticacheConnectionManager.this.determineRole(replInfo);
                        ElasticacheConnectionManager.this.log.debug("node {} is {}", (Object)addr, (Object)role);
                        if (Role.master.equals((Object)role) && master.equals(addr)) {
                            ElasticacheConnectionManager.this.log.debug("Current master {} unchanged", (Object)master);
                            continue;
                        }
                        if (!Role.master.equals((Object)role) || master.equals(addr) || !ElasticacheConnectionManager.this.currentMaster.compareAndSet(master, addr)) continue;
                        ElasticacheConnectionManager.this.log.info("Master has changed from {} to {}", (Object)master, (Object)addr);
                        ElasticacheConnectionManager.this.changeMaster(ElasticacheConnectionManager.this.singleSlotRange.getStartSlot(), addr.getHost(), addr.getPort());
                        break;
                    }
                }
                catch (Exception e) {
                    ElasticacheConnectionManager.this.log.error(e.getMessage(), e);
                }
            }
        }, cfg.getScanInterval(), cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private Role determineRole(String data) {
        for (String s : data.split("\\r\\n")) {
            if (!s.startsWith(ROLE_KEY)) continue;
            return Role.valueOf(s.substring(ROLE_KEY.length()));
        }
        throw new RedisException("Cannot determine node role from provided 'INFO replication' data");
    }

    @Override
    public void shutdown() {
        this.monitorFuture.cancel(true);
        super.shutdown();
        for (RedisConnection connection : this.nodeConnections.values()) {
            connection.getRedisClient().shutdown();
        }
    }

    private static enum Role {
        master,
        slave;

    }
}

