/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonSubList;
import org.redisson.api.RFuture;
import org.redisson.api.RList;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanNumberReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonListMultimapValues<V>
extends RedissonExpirable
implements RList<V> {
    private static final RedisCommand<Integer> LAST_INDEX = new RedisCommand<Integer>("EVAL", new IntegerReplayConvertor(), 4, Arrays.asList(RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE));
    private static final RedisCommand<Integer> EVAL_SIZE = new RedisCommand<Integer>("EVAL", new IntegerReplayConvertor(), 6, RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Integer> EVAL_GET = new RedisCommand("EVAL", 7, RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Set<Object>> EVAL_READALL = new RedisCommand("EVAL", new ObjectSetReplayDecoder(), 6, RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Boolean> EVAL_CONTAINS_VALUE = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 7, Arrays.asList(RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE));
    private static final RedisCommand<Boolean> EVAL_CONTAINS_ALL_WITH_VALUES = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 7, RedisCommand.ValueType.OBJECTS);
    public static final RedisCommand<Boolean> EVAL_BOOLEAN_ARGS2 = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 5, RedisCommand.ValueType.OBJECTS);
    private final Object key;
    private final String timeoutSetName;

    public RedissonListMultimapValues(Codec codec, CommandAsyncExecutor commandExecutor, String name, String timeoutSetName, Object key) {
        super(codec, commandExecutor, name);
        this.timeoutSetName = timeoutSetName;
        this.key = key;
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync() {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Void> renameAsync(String newName) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String newName) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local res = redis.call('zrem', KEYS[1], ARGV[2]); if res > 0 then redis.call('del', KEYS[2]); end; return res; ", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_SIZE, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('llen', KEYS[2]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public Iterator<V> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        List<V> list = this.readAll();
        return list.toArray();
    }

    @Override
    public List<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<List<V>> readAllAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_READALL, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return {};end; return redis.call('lrange', KEYS[2], 0, -1);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List<V> list = this.readAll();
        return list.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.RPUSH_BOOLEAN, this.getName(), e);
    }

    @Override
    public boolean remove(Object o) {
        return this.get(this.removeAsync(o));
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.removeAsync(o, 1);
    }

    protected RFuture<Boolean> removeAsync(Object o, int count) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_CONTAINS_VALUE, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('lrem', KEYS[2], ARGV[2], ARGV[4]) > 0 and 1 or 0;", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), count, this.key, o);
    }

    protected boolean remove(Object o, int count) {
        return this.get(this.removeAsync(o, count));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(this.key);
            args.add(System.currentTimeMillis());
            args.add(keyState);
            args.addAll(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_CONTAINS_ALL_WITH_VALUES, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local items = redis.call('lrange', KEYS[2], 0, -1);for i = 1, #items, 1 do for j = 2, #ARGV, 1 do if ARGV[j] == items[i] then table.remove(ARGV, j) end end; end;return #ARGV == 2 and 1 or 0; ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        ArrayList<String> args = new ArrayList<String>(c.size() + 1);
        args.add(this.getName());
        args.addAll(c);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.RPUSH_BOOLEAN, args.toArray());
    }

    @Override
    public RFuture<Boolean> addAllAsync(int index, Collection<? extends V> coll) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        if (coll.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        if (index == 0) {
            ArrayList<V> elements = new ArrayList<V>(coll);
            Collections.reverse(elements);
            elements.add(0, this.getName());
            return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LPUSH_BOOLEAN, elements.toArray());
        }
        ArrayList<Integer> args = new ArrayList<Integer>(coll.size() + 1);
        args.add(index);
        args.addAll(coll);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_BOOLEAN_ARGS2, "local ind = table.remove(ARGV, 1); local size = redis.call('llen', KEYS[1]); assert(tonumber(ind) <= size, 'index: ' .. ind .. ' but current size: ' .. size); local tail = redis.call('lrange', KEYS[1], ind, -1); redis.call('ltrim', KEYS[1], 0, ind - 1); for i=1, #ARGV, 5000 do redis.call('rpush', KEYS[1], unpack(ARGV, i, math.min(i+4999, #ARGV))); end if #tail > 0 then for i=1, #tail, 5000 do redis.call('rpush', KEYS[1], unpack(tail, i, math.min(i+4999, #tail))); end end;return 1;", Collections.singletonList(this.getName()), args.toArray());
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> coll) {
        return this.get(this.addAllAsync(index, coll));
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(this.key);
            args.add(System.currentTimeMillis());
            args.add(keyState);
            args.addAll(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_CONTAINS_ALL_WITH_VALUES, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local v = 0 for i = 2, #ARGV, 1 do if redis.call('lrem', KEYS[2], 0, ARGV[i]) == 1 then v = 1 end end return v ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(this.key);
            args.add(System.currentTimeMillis());
            args.add(keyState);
            args.addAll(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_CONTAINS_ALL_WITH_VALUES, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local changed = 0; local s = redis.call('lrange', KEYS[2], 0, -1); local i = 1; while i <= #s do local element = s[i]; local isInAgrs = false; for j = 2, #ARGV, 1 do if ARGV[j] == element then isInAgrs = true; break; end; end; if isInAgrs == false then redis.call('lrem', KEYS[2], 0, element); changed = 1; end; i = i + 1; end; return changed; ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public RFuture<V> getAsync(int index) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_GET, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return nil;end; return redis.call('lindex', KEYS[2], ARGV[2]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), index, this.key);
    }

    @Override
    public V get(int index) {
        this.checkIndex(index);
        return this.getValue(index);
    }

    V getValue(int index) {
        return this.get(this.getAsync(index));
    }

    private void checkIndex(int index) {
        int size = this.size();
        if (!this.isInRange(index, size)) {
            throw new IndexOutOfBoundsException("index: " + index + " but current size: " + size);
        }
    }

    private boolean isInRange(int index, int size) {
        return index >= 0 && index < size;
    }

    @Override
    public V set(int index, V element) {
        this.checkIndex(index);
        return this.get(this.setAsync(index, element));
    }

    @Override
    public RFuture<V> setAsync(int index, V element) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand("EVAL", 5), "local v = redis.call('lindex', KEYS[1], ARGV[1]); redis.call('lset', KEYS[1], ARGV[1], ARGV[2]); return v", Collections.singletonList(this.getName()), index, element);
    }

    @Override
    public void fastSet(int index, V element) {
        this.get(this.fastSetAsync(index, element));
    }

    @Override
    public RFuture<Void> fastSetAsync(int index, V element) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LSET, this.getName(), index, element);
    }

    @Override
    public void add(int index, V element) {
        this.addAll(index, (Collection<? extends V>)Collections.singleton(element));
    }

    @Override
    public V remove(int index) {
        return this.get(this.removeAsync(index));
    }

    @Override
    public RFuture<V> removeAsync(long index) {
        if (index == 0L) {
            return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LPOP, this.getName());
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('lindex', KEYS[1], ARGV[1]); redis.call('lset', KEYS[1], ARGV[1], 'DELETED_BY_REDISSON');redis.call('lrem', KEYS[1], 1, 'DELETED_BY_REDISSON');return v", Collections.singletonList(this.getName()), index);
    }

    @Override
    public void fastRemove(int index) {
        this.get(this.fastRemoveAsync(index));
    }

    @Override
    public RFuture<Void> fastRemoveAsync(long index) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_VOID, "redis.call('lset', KEYS[1], ARGV[1], 'DELETED_BY_REDISSON');redis.call('lrem', KEYS[1], 1, 'DELETED_BY_REDISSON');", Collections.singletonList(this.getName()), index);
    }

    @Override
    public int indexOf(Object o) {
        return this.get(this.indexOfAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.indexOfAsync(o, new BooleanNumberReplayConvertor(-1L));
    }

    private <R> RFuture<R> indexOfAsync(Object o, Convertor<R> convertor) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, new RedisCommand<R>("EVAL", convertor, 6, Arrays.asList(RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE)), "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return -1;end; local items = redis.call('lrange', KEYS[2], 0, -1); for i=1,#items do if items[i] == ARGV[3] then return i - 1; end; end; return -1;", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key, o);
    }

    @Override
    public RFuture<Integer> indexOfAsync(Object o) {
        return this.indexOfAsync(o, new IntegerReplayConvertor());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.get(this.lastIndexOfAsync(o));
    }

    @Override
    public RFuture<Integer> lastIndexOfAsync(Object o) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, LAST_INDEX, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return -1;end; local items = redis.call('lrange', KEYS[1], 0, -1) for i = #items, 1, -1 do if items[i] == ARGV[1] then return i - 1 end end return -1", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key, o);
    }

    @Override
    public void trim(int fromIndex, int toIndex) {
        this.get(this.trimAsync(fromIndex, toIndex));
    }

    @Override
    public RFuture<Void> trimAsync(long fromIndex, long toIndex) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LTRIM, this.getName(), fromIndex, toIndex);
    }

    @Override
    public ListIterator<V> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<V> listIterator(final int ind) {
        return new ListIterator<V>(){
            private V prevCurrentValue;
            private V nextCurrentValue;
            private V currentValueHasRead;
            private int currentIndex;
            private boolean hasBeenModified;
            {
                this.currentIndex = ind - 1;
                this.hasBeenModified = true;
            }

            @Override
            public boolean hasNext() {
                Object val = RedissonListMultimapValues.this.getValue(this.currentIndex + 1);
                if (val != null) {
                    this.nextCurrentValue = val;
                }
                return val != null;
            }

            @Override
            public V next() {
                if (this.nextCurrentValue == null && !this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                ++this.currentIndex;
                this.currentValueHasRead = this.nextCurrentValue;
                this.nextCurrentValue = null;
                this.hasBeenModified = false;
                return this.currentValueHasRead;
            }

            @Override
            public void remove() {
                if (this.currentValueHasRead == null) {
                    throw new IllegalStateException("Neither next nor previous have been called");
                }
                if (this.hasBeenModified) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonListMultimapValues.this.remove(this.currentIndex);
                --this.currentIndex;
                this.hasBeenModified = true;
                this.currentValueHasRead = null;
            }

            @Override
            public boolean hasPrevious() {
                if (this.currentIndex < 0) {
                    return false;
                }
                Object val = RedissonListMultimapValues.this.getValue(this.currentIndex);
                if (val != null) {
                    this.prevCurrentValue = val;
                }
                return val != null;
            }

            @Override
            public V previous() {
                if (this.prevCurrentValue == null && !this.hasPrevious()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                --this.currentIndex;
                this.hasBeenModified = false;
                this.currentValueHasRead = this.prevCurrentValue;
                this.prevCurrentValue = null;
                return this.currentValueHasRead;
            }

            @Override
            public int nextIndex() {
                return this.currentIndex + 1;
            }

            @Override
            public int previousIndex() {
                return this.currentIndex;
            }

            @Override
            public void set(V e) {
                if (this.hasBeenModified) {
                    throw new IllegalStateException();
                }
                RedissonListMultimapValues.this.fastSet(this.currentIndex, e);
            }

            @Override
            public void add(V e) {
                RedissonListMultimapValues.this.add(this.currentIndex + 1, e);
                ++this.currentIndex;
                this.hasBeenModified = true;
            }
        };
    }

    @Override
    public RList<V> subList(int fromIndex, int toIndex) {
        int size = this.size();
        if (fromIndex < 0 || toIndex > size) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + " size: " + size);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex: " + fromIndex + " toIndex: " + toIndex);
        }
        return new RedissonSubList(this.codec, this.commandExecutor, this.getName(), fromIndex, toIndex);
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        Iterator<V> e1 = this.iterator();
        Iterator e2 = ((List)o).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            V o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (V e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public RFuture<Integer> addAfterAsync(V elementToFind, V element) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LINSERT, this.getName(), "AFTER", elementToFind, element);
    }

    @Override
    public RFuture<Integer> addBeforeAsync(V elementToFind, V element) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LINSERT, this.getName(), "BEFORE", elementToFind, element);
    }

    @Override
    public Integer addAfter(V elementToFind, V element) {
        return this.get(this.addAfterAsync(elementToFind, element));
    }

    @Override
    public Integer addBefore(V elementToFind, V element) {
        return this.get(this.addBeforeAsync(elementToFind, element));
    }
}

