/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.avro.AvroFactory;
import com.fasterxml.jackson.dataformat.avro.AvroMapper;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import java.io.IOException;
import java.io.InputStream;
import org.redisson.codec.JsonJacksonCodec;

public class AvroJacksonCodec
extends JsonJacksonCodec {
    public AvroJacksonCodec(Class<?> type, AvroSchema schema) {
        super((ObjectMapper)((Object)new AvroExtendedMapper(type, schema)));
    }

    public AvroJacksonCodec(ClassLoader classLoader) {
        super(AvroJacksonCodec.createObjectMapper(classLoader, new ObjectMapper((JsonFactory)new AvroFactory())));
    }

    @Override
    protected void initTypeInclusion(ObjectMapper mapObjectMapper) {
    }

    public static class AvroExtendedMapper
    extends AvroMapper {
        private static final long serialVersionUID = -560070554221164163L;
        private final AvroSchema schema;
        private final Class<?> type;

        public AvroExtendedMapper(Class<?> type, AvroSchema schema) {
            this.type = type;
            this.schema = schema;
        }

        public byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
            return this.writerFor(this.type).with((FormatSchema)this.schema).writeValueAsBytes(value);
        }

        public <T> T readValue(InputStream src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
            return this.readerFor(this.type).with((FormatSchema)this.schema).readValue(src);
        }
    }
}

