/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.PubSubEntry;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RFuture;
import org.redisson.api.RSemaphore;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.misc.RPromise;
import org.redisson.pubsub.SemaphorePubSub;

public class RedissonSemaphore
extends RedissonExpirable
implements RSemaphore {
    private final SemaphorePubSub semaphorePubSub;
    final CommandExecutor commandExecutor;

    protected RedissonSemaphore(CommandExecutor commandExecutor, String name, SemaphorePubSub semaphorePubSub) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.semaphorePubSub = semaphorePubSub;
    }

    String getChannelName() {
        return RedissonSemaphore.getChannelName(this.getName());
    }

    public static String getChannelName(String name) {
        if (name.contains("{")) {
            return "redisson_sc:" + name;
        }
        return "redisson_sc:{" + name + "}";
    }

    @Override
    public void acquire() throws InterruptedException {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        if (this.tryAcquire(permits)) {
            return;
        }
        RFuture<RedissonLockEntry> future = this.subscribe();
        this.commandExecutor.syncSubscription(future);
        try {
            while (true) {
                if (this.tryAcquire(permits)) {
                    return;
                }
                this.getEntry().getLatch().acquire(permits);
            }
        }
        finally {
            this.unsubscribe(future);
        }
    }

    @Override
    public RFuture<Void> acquireAsync() {
        return this.acquireAsync(1);
    }

    @Override
    public RFuture<Void> acquireAsync(final int permits) {
        final RPromise<Void> result = this.newPromise();
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    if (!result.trySuccess(null)) {
                        RedissonSemaphore.this.releaseAsync(permits);
                    }
                    return;
                }
                final RFuture subscribeFuture = RedissonSemaphore.this.subscribe();
                subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                    @Override
                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        RedissonSemaphore.this.acquireAsync(permits, subscribeFuture, result);
                    }
                });
            }
        });
        return result;
    }

    private void tryAcquireAsync(final AtomicLong time, final int permits, final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<Boolean> result) {
        if (result.isDone()) {
            this.unsubscribe(subscribeFuture);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(subscribeFuture);
            result.trySuccess(false);
            return;
        }
        final long current = System.currentTimeMillis();
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.addListener(new FutureListener<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                RedissonLockEntry entry;
                if (!future.isSuccess()) {
                    RedissonSemaphore.this.unsubscribe(subscribeFuture);
                    result.tryFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RedissonSemaphore.this.unsubscribe(subscribeFuture);
                    if (!result.trySuccess(true)) {
                        RedissonSemaphore.this.releaseAsync(permits);
                    }
                    return;
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                if (time.get() <= 0L) {
                    RedissonSemaphore.this.unsubscribe(subscribeFuture);
                    result.trySuccess(false);
                    return;
                }
                final long current2 = System.currentTimeMillis();
                RedissonLockEntry redissonLockEntry = entry = RedissonSemaphore.this.getEntry();
                synchronized (redissonLockEntry) {
                    if (entry.getLatch().tryAcquire()) {
                        RedissonSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result);
                    } else {
                        final AtomicBoolean executed = new AtomicBoolean();
                        final AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                        final Runnable listener = new Runnable(){

                            @Override
                            public void run() {
                                executed.set(true);
                                if (futureRef.get() != null && !((Timeout)futureRef.get()).cancel()) {
                                    entry.getLatch().release();
                                    return;
                                }
                                long elapsed = System.currentTimeMillis() - current2;
                                time.addAndGet(-elapsed);
                                RedissonSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result);
                            }
                        };
                        entry.addListener(listener);
                        long t = time.get();
                        if (!executed.get()) {
                            Timeout scheduledFuture = RedissonSemaphore.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run(Timeout timeout) throws Exception {
                                    RedissonLockEntry redissonLockEntry = entry;
                                    synchronized (redissonLockEntry) {
                                        if (entry.removeListener(listener)) {
                                            long elapsed = System.currentTimeMillis() - current2;
                                            time.addAndGet(-elapsed);
                                            RedissonSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result);
                                        }
                                    }
                                }
                            }, t, TimeUnit.MILLISECONDS);
                            futureRef.set(scheduledFuture);
                        }
                    }
                }
            }
        });
    }

    private void acquireAsync(final int permits, final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<Void> result) {
        if (result.isDone()) {
            this.unsubscribe(subscribeFuture);
            return;
        }
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.addListener(new FutureListener<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                RedissonLockEntry entry;
                if (!future.isSuccess()) {
                    RedissonSemaphore.this.unsubscribe(subscribeFuture);
                    result.tryFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RedissonSemaphore.this.unsubscribe(subscribeFuture);
                    if (!result.trySuccess(null)) {
                        RedissonSemaphore.this.releaseAsync(permits);
                    }
                    return;
                }
                RedissonLockEntry redissonLockEntry = entry = RedissonSemaphore.this.getEntry();
                synchronized (redissonLockEntry) {
                    if (entry.getLatch().tryAcquire(permits)) {
                        RedissonSemaphore.this.acquireAsync(permits, subscribeFuture, result);
                    } else {
                        Runnable listener = new Runnable(){

                            @Override
                            public void run() {
                                RedissonSemaphore.this.acquireAsync(permits, subscribeFuture, result);
                            }
                        };
                        entry.addListener(listener);
                    }
                }
            }
        });
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryAcquire(int permits) {
        return this.get(this.tryAcquireAsync(permits));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync() {
        return this.tryAcquireAsync(1);
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits amount can't be negative");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value ~= false and tonumber(value) >= tonumber(ARGV[1])) then local val = redis.call('decrby', KEYS[1], ARGV[1]); return 1; end; return 0;", Collections.singletonList(this.getName()), permits);
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long waitTime, TimeUnit unit) {
        return this.tryAcquireAsync(1, waitTime, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAcquire(int permits, long waitTime, TimeUnit unit) throws InterruptedException {
        long time = unit.toMillis(waitTime);
        long current = System.currentTimeMillis();
        if (this.tryAcquire(permits)) {
            return true;
        }
        if ((time -= System.currentTimeMillis() - current) <= 0L) {
            return false;
        }
        current = System.currentTimeMillis();
        RFuture<RedissonLockEntry> future = this.subscribe();
        if (!this.await(future, time, TimeUnit.MILLISECONDS)) {
            return false;
        }
        try {
            if ((time -= System.currentTimeMillis() - current) <= 0L) {
                boolean bl = false;
                return bl;
            }
            do {
                current = System.currentTimeMillis();
                if (this.tryAcquire(permits)) {
                    boolean bl = true;
                    return bl;
                }
                if ((time -= System.currentTimeMillis() - current) <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                current = System.currentTimeMillis();
                this.getEntry().getLatch().tryAcquire(permits, time, TimeUnit.MILLISECONDS);
            } while ((time -= System.currentTimeMillis() - current) > 0L);
            boolean bl = false;
            return bl;
        }
        finally {
            this.unsubscribe(future);
        }
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(final int permits, long waitTime, TimeUnit unit) {
        final RPromise<Boolean> result = this.newPromise();
        final AtomicLong time = new AtomicLong(unit.toMillis(waitTime));
        final long current = System.currentTimeMillis();
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    if (!result.trySuccess(true)) {
                        RedissonSemaphore.this.releaseAsync(permits);
                    }
                    return;
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                if (time.get() <= 0L) {
                    result.trySuccess(false);
                    return;
                }
                final long current2 = System.currentTimeMillis();
                final AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                final RFuture subscribeFuture = RedissonSemaphore.this.subscribe();
                subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                    @Override
                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        if (futureRef.get() != null) {
                            ((Timeout)futureRef.get()).cancel();
                        }
                        long elapsed = System.currentTimeMillis() - current2;
                        time.addAndGet(-elapsed);
                        if (time.get() < 0L) {
                            RedissonSemaphore.this.unsubscribe(subscribeFuture);
                            result.trySuccess(false);
                            return;
                        }
                        RedissonSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result);
                    }
                });
                if (!subscribeFuture.isDone()) {
                    Timeout scheduledFuture = RedissonSemaphore.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            if (!subscribeFuture.isDone()) {
                                result.trySuccess(false);
                            }
                        }
                    }, time.get(), TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
        return result;
    }

    private RedissonLockEntry getEntry() {
        return (RedissonLockEntry)this.semaphorePubSub.getEntry(this.getName());
    }

    private RFuture<RedissonLockEntry> subscribe() {
        return this.semaphorePubSub.subscribe(this.getName(), this.getChannelName(), this.commandExecutor.getConnectionManager());
    }

    private void unsubscribe(RFuture<RedissonLockEntry> future) {
        this.semaphorePubSub.unsubscribe((PubSubEntry)future.getNow(), this.getName(), this.getChannelName(), this.commandExecutor.getConnectionManager());
    }

    @Override
    public boolean tryAcquire(long time, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, time, unit);
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        this.get(this.releaseAsync(permits));
    }

    @Override
    public RFuture<Void> releaseAsync() {
        return this.releaseAsync(1);
    }

    @Override
    public RFuture<Void> releaseAsync(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits amount can't be negative");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('incrby', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], value); ", Arrays.asList(this.getName(), this.getChannelName()), permits);
    }

    @Override
    public int drainPermits() {
        Long res = (Long)this.commandExecutor.evalWrite(this.getName(), LongCodec.INSTANCE, RedisCommands.EVAL_LONG, "local value = redis.call('get', KEYS[1]); if (value == false or value == 0) then return 0; end; redis.call('set', KEYS[1], 0); return value;", Collections.singletonList(this.getName()), new Object[0]);
        return res.intValue();
    }

    @Override
    public int availablePermits() {
        Long res = (Long)this.commandExecutor.write(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.GET_LONG, this.getName());
        return res.intValue();
    }

    @Override
    public void setPermits(int permits) {
        this.get(this.setPermitsAsync(permits));
    }

    @Override
    public RFuture<Void> setPermitsAsync(int permits) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('get', KEYS[1]); if (value == false or value == 0) then redis.call('set', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], ARGV[1]); end;", Arrays.asList(this.getName(), this.getChannelName()), permits);
    }

    @Override
    public boolean trySetPermits(int permits) {
        return this.get(this.trySetPermitsAsync(permits));
    }

    @Override
    public RFuture<Boolean> trySetPermitsAsync(int permits) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value == false or value == 0) then redis.call('set', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getName(), this.getChannelName()), permits);
    }

    @Override
    public void reducePermits(int permits) {
        this.get(this.reducePermitsAsync(permits));
    }

    @Override
    public RFuture<Void> reducePermitsAsync(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('get', KEYS[1]); if (value == false) then value = 0;end;redis.call('set', KEYS[1], value - ARGV[1]); ", Arrays.asList(this.getName(), this.getChannelName()), permits);
    }
}

