/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.RedissonCache;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class RedissonSpringCacheManager
implements CacheManager,
ResourceLoaderAware,
InitializingBean {
    private ResourceLoader resourceLoader;
    private boolean dynamic = true;
    private boolean allowNullValues = true;
    private Codec codec;
    private RedissonClient redisson;
    private Map<String, CacheConfig> configMap = new ConcurrentHashMap<String, CacheConfig>();
    private ConcurrentMap<String, Cache> instanceMap = new ConcurrentHashMap<String, Cache>();
    private String configLocation;

    public RedissonSpringCacheManager(RedissonClient redisson) {
        this(redisson, (String)null, null);
    }

    public RedissonSpringCacheManager(RedissonClient redisson, Map<String, CacheConfig> config) {
        this(redisson, config, null);
    }

    public RedissonSpringCacheManager(RedissonClient redisson, Map<String, CacheConfig> config, Codec codec) {
        this.redisson = redisson;
        this.configMap = config;
        this.codec = codec;
    }

    public RedissonSpringCacheManager(RedissonClient redisson, String configLocation) {
        this(redisson, configLocation, null);
    }

    public RedissonSpringCacheManager(RedissonClient redisson, String configLocation, Codec codec) {
        this.redisson = redisson;
        this.configLocation = configLocation;
        this.codec = codec;
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public void setCacheNames(Collection<String> names) {
        if (names != null) {
            for (String name : names) {
                this.getCache(name);
            }
            this.dynamic = false;
        } else {
            this.dynamic = true;
        }
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setConfig(Map<String, CacheConfig> config) {
        this.configMap = config;
    }

    public void setRedisson(RedissonClient redisson) {
        this.redisson = redisson;
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }

    public Cache getCache(String name) {
        Cache cache = (Cache)this.instanceMap.get(name);
        if (cache != null) {
            return cache;
        }
        if (!this.dynamic) {
            return cache;
        }
        CacheConfig config = this.configMap.get(name);
        if (config == null) {
            config = new CacheConfig();
            this.configMap.put(name, config);
            return this.createMap(name);
        }
        if (config.getMaxIdleTime() == 0L && config.getTTL() == 0L) {
            return this.createMap(name);
        }
        return this.createMapCache(name, config);
    }

    private Cache createMap(String name) {
        RMap<Object, Object> map = this.codec != null ? this.redisson.getMap(name, this.codec) : this.redisson.getMap(name);
        RedissonCache cache = new RedissonCache(map, this.allowNullValues);
        Cache oldCache = this.instanceMap.putIfAbsent(name, cache);
        if (oldCache != null) {
            cache = oldCache;
        }
        return cache;
    }

    private Cache createMapCache(String name, CacheConfig config) {
        RMapCache<Object, Object> map = this.codec != null ? this.redisson.getMapCache(name, this.codec) : this.redisson.getMapCache(name);
        RedissonCache cache = new RedissonCache(map, config, this.allowNullValues);
        Cache oldCache = this.instanceMap.putIfAbsent(name, cache);
        if (oldCache != null) {
            cache = oldCache;
        }
        return cache;
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.configMap.keySet());
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.configLocation == null) {
            return;
        }
        Resource resource = this.resourceLoader.getResource(this.configLocation);
        try {
            this.configMap = CacheConfig.fromJSON(resource.getInputStream());
        }
        catch (IOException e) {
            try {
                this.configMap = CacheConfig.fromYAML(resource.getInputStream());
            }
            catch (IOException e1) {
                throw new BeanDefinitionStoreException("Could not parse cache configuration at [" + this.configLocation + "]", (Throwable)e1);
            }
        }
    }
}

