/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.ReconnectListener;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.misc.RPromise;
import org.redisson.pubsub.AsyncSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionsEntry {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Queue<RedisPubSubConnection> allSubscribeConnections = new ConcurrentLinkedQueue<RedisPubSubConnection>();
    private final Queue<RedisPubSubConnection> freeSubscribeConnections = new ConcurrentLinkedQueue<RedisPubSubConnection>();
    private final AsyncSemaphore freeSubscribeConnectionsCounter;
    private final Queue<RedisConnection> freeConnections = new ConcurrentLinkedQueue<RedisConnection>();
    private final AsyncSemaphore freeConnectionsCounter;
    private volatile boolean freezed;
    private FreezeReason freezeReason;
    final RedisClient client;
    private final NodeType nodeType;
    private ConnectionManager connectionManager;
    private final AtomicInteger failedAttempts = new AtomicInteger();

    public ClientConnectionsEntry(RedisClient client, int poolMinSize, int poolMaxSize, int subscribePoolMinSize, int subscribePoolMaxSize, ConnectionManager connectionManager, NodeType serverMode) {
        this.client = client;
        this.freeConnectionsCounter = new AsyncSemaphore(poolMaxSize);
        this.connectionManager = connectionManager;
        this.nodeType = serverMode;
        this.freeSubscribeConnectionsCounter = new AsyncSemaphore(subscribePoolMaxSize);
        if (subscribePoolMaxSize > 0) {
            connectionManager.getConnectionWatcher().add(subscribePoolMinSize, subscribePoolMaxSize, this.freeSubscribeConnections, this.freeSubscribeConnectionsCounter);
        }
        connectionManager.getConnectionWatcher().add(poolMinSize, poolMaxSize, this.freeConnections, this.freeConnectionsCounter);
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void resetFailedAttempts() {
        this.failedAttempts.set(0);
    }

    public int getFailedAttempts() {
        return this.failedAttempts.get();
    }

    public int incFailedAttempts() {
        return this.failedAttempts.incrementAndGet();
    }

    public RedisClient getClient() {
        return this.client;
    }

    public boolean isFreezed() {
        return this.freezed;
    }

    public void setFreezeReason(FreezeReason freezeReason) {
        this.freezeReason = freezeReason;
    }

    public FreezeReason getFreezeReason() {
        return this.freezeReason;
    }

    public void setFreezed(boolean freezed) {
        this.freezed = freezed;
    }

    public int getFreeAmount() {
        return this.freeConnectionsCounter.getCounter();
    }

    public void acquireConnection(Runnable runnable) {
        this.freeConnectionsCounter.acquire(runnable);
    }

    public void removeConnection(Runnable runnable) {
        this.freeConnectionsCounter.remove(runnable);
    }

    public void releaseConnection() {
        this.freeConnectionsCounter.release();
    }

    public RedisConnection pollConnection() {
        return this.freeConnections.poll();
    }

    public void releaseConnection(RedisConnection connection) {
        connection.setLastUsageTime(System.currentTimeMillis());
        this.freeConnections.add(connection);
    }

    public RFuture<RedisConnection> connect() {
        final RPromise<RedisConnection> connectionFuture = this.connectionManager.newPromise();
        RFuture<RedisConnection> future = this.client.connectAsync();
        future.addListener(new FutureListener<RedisConnection>(){

            @Override
            public void operationComplete(Future<RedisConnection> future) throws Exception {
                if (!future.isSuccess()) {
                    connectionFuture.tryFailure(future.cause());
                    return;
                }
                RedisConnection conn = future.getNow();
                ClientConnectionsEntry.this.log.debug("new connection created: {}", (Object)conn);
                ClientConnectionsEntry.this.addReconnectListener(connectionFuture, conn);
            }
        });
        return connectionFuture;
    }

    private <T extends RedisConnection> void addReconnectListener(RPromise<T> connectionFuture, T conn) {
        this.addFireEventListener(conn, connectionFuture);
        conn.setReconnectListener(new ReconnectListener(){

            @Override
            public void onReconnect(RedisConnection conn, RPromise<RedisConnection> connectionFuture) {
                ClientConnectionsEntry.this.addFireEventListener(conn, connectionFuture);
            }
        });
    }

    private <T extends RedisConnection> void addFireEventListener(T conn, RPromise<T> connectionFuture) {
        this.connectionManager.getConnectListener().onConnect(connectionFuture, conn, this.nodeType, this.connectionManager.getConfig());
        if (connectionFuture.isSuccess()) {
            this.connectionManager.getConnectionEventsHub().fireConnect(((RedisConnection)connectionFuture.getNow()).getRedisClient().getAddr());
            return;
        }
        connectionFuture.addListener(new FutureListener<T>(){

            @Override
            public void operationComplete(Future<T> future) throws Exception {
                if (future.isSuccess()) {
                    ClientConnectionsEntry.this.connectionManager.getConnectionEventsHub().fireConnect(((RedisConnection)future.getNow()).getRedisClient().getAddr());
                }
            }
        });
    }

    public MasterSlaveServersConfig getConfig() {
        return this.connectionManager.getConfig();
    }

    public RFuture<RedisPubSubConnection> connectPubSub() {
        final RPromise<RedisPubSubConnection> connectionFuture = this.connectionManager.newPromise();
        RFuture<RedisPubSubConnection> future = this.client.connectPubSubAsync();
        future.addListener(new FutureListener<RedisPubSubConnection>(){

            @Override
            public void operationComplete(Future<RedisPubSubConnection> future) throws Exception {
                if (!future.isSuccess()) {
                    connectionFuture.tryFailure(future.cause());
                    return;
                }
                RedisPubSubConnection conn = future.getNow();
                ClientConnectionsEntry.this.log.debug("new pubsub connection created: {}", (Object)conn);
                ClientConnectionsEntry.this.addReconnectListener(connectionFuture, conn);
                ClientConnectionsEntry.this.allSubscribeConnections.add(conn);
            }
        });
        return connectionFuture;
    }

    public Queue<RedisPubSubConnection> getAllSubscribeConnections() {
        return this.allSubscribeConnections;
    }

    public RedisPubSubConnection pollSubscribeConnection() {
        return this.freeSubscribeConnections.poll();
    }

    public void releaseSubscribeConnection(RedisPubSubConnection connection) {
        connection.setLastUsageTime(System.currentTimeMillis());
        this.freeSubscribeConnections.add(connection);
    }

    public void acquireSubscribeConnection(Runnable runnable) {
        this.freeSubscribeConnectionsCounter.acquire(runnable);
    }

    public void releaseSubscribeConnection() {
        this.freeSubscribeConnectionsCounter.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean freezeMaster(FreezeReason reason) {
        ClientConnectionsEntry clientConnectionsEntry = this;
        synchronized (clientConnectionsEntry) {
            this.setFreezed(true);
            if (this.getFreezeReason() == null || this.getFreezeReason() == FreezeReason.RECONNECT) {
                this.setFreezeReason(reason);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "[freeSubscribeConnectionsAmount=" + this.freeSubscribeConnections.size() + ", freeSubscribeConnectionsCounter=" + this.freeSubscribeConnectionsCounter + ", freeConnectionsAmount=" + this.freeConnections.size() + ", freeConnectionsCounter=" + this.freeConnectionsCounter + ", freezed=" + this.freezed + ", freezeReason=" + (Object)((Object)this.freezeReason) + ", client=" + this.client + ", nodeType=" + (Object)((Object)this.nodeType) + ", failedAttempts=" + this.failedAttempts + "]";
    }

    public static enum FreezeReason {
        MANAGER,
        RECONNECT,
        SYSTEM;

    }
}

