/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mapreduce;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RExecutorService;
import org.redisson.api.RFuture;
import org.redisson.mapreduce.MapReduceTimeoutException;

public class SubTasksExecutor {
    private final List<RFuture<?>> futures = new ArrayList();
    private final CountDownLatch latch;
    private final RExecutorService executor;
    private final long startTime;
    private final long timeout;

    public SubTasksExecutor(RExecutorService executor, int workersAmount, long startTime, long timeout) {
        this.executor = executor;
        this.latch = new CountDownLatch(workersAmount);
        this.startTime = startTime;
        this.timeout = timeout;
    }

    public void submit(Runnable runnable) {
        RFuture<?> future = this.executor.submitAsync(runnable);
        future.addListener(new LatchListener(this.latch));
        this.futures.add(future);
    }

    private void cancel(List<RFuture<?>> futures) {
        for (RFuture<?> future : futures) {
            future.cancel(true);
        }
    }

    private boolean isTimeoutExpired(long timeSpent) {
        return timeSpent > this.timeout && this.timeout > 0L;
    }

    public boolean await() throws Exception {
        if (Thread.currentThread().isInterrupted()) {
            this.cancel(this.futures);
            return false;
        }
        long timeSpent = System.currentTimeMillis() - this.startTime;
        if (this.isTimeoutExpired(timeSpent)) {
            this.cancel(this.futures);
            throw new MapReduceTimeoutException();
        }
        try {
            if (this.timeout > 0L && !this.latch.await(this.timeout - timeSpent, TimeUnit.MILLISECONDS)) {
                this.cancel(this.futures);
                throw new MapReduceTimeoutException();
            }
            if (this.timeout == 0L) {
                this.latch.await();
            }
        }
        catch (InterruptedException e) {
            this.cancel(this.futures);
            return false;
        }
        for (RFuture<?> rFuture : this.futures) {
            if (rFuture.isSuccess()) continue;
            throw (Exception)rFuture.cause();
        }
        return true;
    }

    public static class LatchListener
    implements FutureListener<Object> {
        private CountDownLatch latch;

        public LatchListener() {
        }

        public LatchListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void operationComplete(Future<Object> future) throws Exception {
            this.latch.countDown();
        }
    }
}

