/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mapreduce;

import java.io.IOException;
import java.util.BitSet;
import java.util.concurrent.TimeUnit;
import net.openhft.hashing.LongHashFunction;
import org.redisson.api.RListMultimap;
import org.redisson.api.RedissonClient;
import org.redisson.api.mapreduce.RCollector;
import org.redisson.client.codec.Codec;

public class Collector<K, V>
implements RCollector<K, V> {
    private RedissonClient client;
    private String name;
    private int parts;
    private Codec codec;
    private long timeout;
    private BitSet expirationsBitSet = new BitSet();

    public Collector(Codec codec, RedissonClient client, String name, int parts, long timeout) {
        this.client = client;
        this.name = name;
        this.parts = parts;
        this.codec = codec;
        this.timeout = timeout;
        this.expirationsBitSet = new BitSet(parts);
    }

    @Override
    public void emit(K key, V value) {
        try {
            byte[] encodedKey = this.codec.getValueEncoder().encode(key);
            long hash = LongHashFunction.xx_r39().hashBytes(encodedKey);
            int part = (int)Math.abs(hash % (long)this.parts);
            String partName = this.name + ":" + part;
            RListMultimap<K, V> multimap = this.client.getListMultimap(partName, this.codec);
            multimap.put(key, value);
            if (this.timeout > 0L && !this.expirationsBitSet.get(part)) {
                multimap.expire(this.timeout, TimeUnit.MILLISECONDS);
                this.expirationsBitSet.set(part);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

