/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.support;

import org.redisson.spring.support.AbstractRedissonNamespaceDefinitionParser;
import org.redisson.spring.support.RedissonNamespaceDecorator;
import org.redisson.spring.support.RedissonNamespaceParserSupport;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class RedissonRPCClientDefinitionParser
extends AbstractRedissonNamespaceDefinitionParser {
    public RedissonRPCClientDefinitionParser(RedissonNamespaceParserSupport helper, RedissonNamespaceDecorator decorator) {
        super(helper, "remote-service-ref", decorator);
    }

    @Override
    protected void parseNested(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, BeanDefinition bd) {
        Class<?> apiClass;
        try {
            apiClass = Class.forName(this.helper.getAttribute(element, "api-class"));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("The class [" + this.helper.getAttribute(element, "api-class") + "] specified in \"" + "api-class" + "\" attribute has not " + "found. Please check the class path.", ex);
        }
        builder.addPropertyValue("targetObject", (Object)new RuntimeBeanReference(this.helper.getAttribute(element, "remote-service-ref")));
        builder.addPropertyValue("targetMethod", (Object)"get");
        builder.addPropertyValue("arguments", (Object)new Object[]{apiClass});
    }

    protected Class<?> getBeanClass(Element element) {
        return MethodInvokingFactoryBean.class;
    }
}

