/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.redisson.client.handler.StateLevel;
import org.redisson.client.protocol.decoder.DecoderState;

public class State {
    private int batchIndex;
    private DecoderState decoderState;
    private int level = -1;
    private List<StateLevel> levels;
    private DecoderState decoderStateCopy;
    private final boolean makeCheckpoint;

    public State(boolean makeCheckpoint) {
        this.makeCheckpoint = makeCheckpoint;
    }

    public boolean isMakeCheckpoint() {
        return this.makeCheckpoint;
    }

    public void resetLevel() {
        this.level = -1;
    }

    public int decLevel() {
        return --this.level;
    }

    public int incLevel() {
        return ++this.level;
    }

    public void addLevel(StateLevel stateLevel) {
        if (this.levels == null) {
            this.levels = new ArrayList<StateLevel>(2);
        }
        this.levels.add(stateLevel);
    }

    public List<StateLevel> getLevels() {
        if (this.levels == null) {
            return Collections.emptyList();
        }
        return this.levels;
    }

    public void setBatchIndex(int index) {
        this.batchIndex = index;
    }

    public int getBatchIndex() {
        return this.batchIndex;
    }

    public <T extends DecoderState> T getDecoderState() {
        return (T)this.decoderState;
    }

    public void setDecoderState(DecoderState decoderState) {
        this.decoderState = decoderState;
    }

    public DecoderState getDecoderStateCopy() {
        return this.decoderStateCopy;
    }

    public void setDecoderStateCopy(DecoderState decoderStateCopy) {
        this.decoderStateCopy = decoderStateCopy;
    }

    public String toString() {
        return "State [batchIndex=" + this.batchIndex + ", decoderState=" + this.decoderState + ", level=" + this.level + ", levels=" + this.levels + ", decoderStateCopy=" + this.decoderStateCopy + "]";
    }
}

