/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cluster;

import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.misc.URLBuilder;

public class ClusterPartition {
    private final String nodeId;
    private boolean masterFail;
    private URL masterAddress;
    private final Set<URL> slaveAddresses = new HashSet<URL>();
    private final Set<URL> failedSlaves = new HashSet<URL>();
    private final Set<Integer> slots = new HashSet<Integer>();
    private final Set<ClusterSlotRange> slotRanges = new HashSet<ClusterSlotRange>();

    public ClusterPartition(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setMasterFail(boolean masterFail) {
        this.masterFail = masterFail;
    }

    public boolean isMasterFail() {
        return this.masterFail;
    }

    public void addSlots(Set<Integer> slots) {
        this.slots.addAll(slots);
    }

    public void removeSlots(Set<Integer> slots) {
        this.slots.removeAll(slots);
    }

    public void addSlotRanges(Set<ClusterSlotRange> ranges) {
        for (ClusterSlotRange clusterSlotRange : ranges) {
            for (int i = clusterSlotRange.getStartSlot(); i < clusterSlotRange.getEndSlot() + 1; ++i) {
                this.slots.add(i);
            }
        }
        this.slotRanges.addAll(ranges);
    }

    public void removeSlotRanges(Set<ClusterSlotRange> ranges) {
        for (ClusterSlotRange clusterSlotRange : ranges) {
            for (int i = clusterSlotRange.getStartSlot(); i < clusterSlotRange.getEndSlot() + 1; ++i) {
                this.slots.remove(i);
            }
        }
        this.slotRanges.removeAll(ranges);
    }

    public Set<ClusterSlotRange> getSlotRanges() {
        return this.slotRanges;
    }

    public Set<Integer> getSlots() {
        return this.slots;
    }

    public InetSocketAddress getMasterAddr() {
        return new InetSocketAddress(this.masterAddress.getHost(), this.masterAddress.getPort());
    }

    public URL getMasterAddress() {
        return this.masterAddress;
    }

    public void setMasterAddress(String masterAddress) {
        this.setMasterAddress(URLBuilder.create(masterAddress));
    }

    public void setMasterAddress(URL masterAddress) {
        this.masterAddress = masterAddress;
    }

    public void addFailedSlaveAddress(URL address) {
        this.failedSlaves.add(address);
    }

    public Set<URL> getFailedSlaveAddresses() {
        return Collections.unmodifiableSet(this.failedSlaves);
    }

    public void removeFailedSlaveAddress(URL uri) {
        this.failedSlaves.remove(uri);
    }

    public void addSlaveAddress(URL address) {
        this.slaveAddresses.add(address);
    }

    public Set<URL> getSlaveAddresses() {
        return Collections.unmodifiableSet(this.slaveAddresses);
    }

    public void removeSlaveAddress(URL uri) {
        this.slaveAddresses.remove(uri);
        this.failedSlaves.remove(uri);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterPartition other = (ClusterPartition)obj;
        return !(this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId));
    }

    public String toString() {
        return "ClusterPartition [nodeId=" + this.nodeId + ", masterFail=" + this.masterFail + ", masterAddress=" + this.masterAddress + ", slaveAddresses=" + this.slaveAddresses + ", failedSlaves=" + this.failedSlaves + ", slotRanges=" + this.slotRanges + "]";
    }
}

