/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.redisson.RedissonReference;
import org.redisson.api.RLiveObject;
import org.redisson.api.RMap;
import org.redisson.api.RObject;
import org.redisson.api.RedissonClient;
import org.redisson.api.annotation.REntity;
import org.redisson.api.annotation.RId;
import org.redisson.client.codec.Codec;
import org.redisson.codec.CodecProvider;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.liveobject.misc.Introspectior;
import org.redisson.liveobject.resolver.NamingScheme;
import org.redisson.misc.RedissonObjectFactory;

public class AccessorInterceptor {
    private final RedissonClient redisson;
    private final CodecProvider codecProvider;
    private final RedissonObjectBuilder objectBuilder;

    public AccessorInterceptor(RedissonClient redisson, RedissonObjectBuilder objectBuilder) {
        this.redisson = redisson;
        this.codecProvider = redisson.getCodecProvider();
        this.objectBuilder = objectBuilder;
    }

    @RuntimeType
    public Object intercept(@Origin Method method, @SuperCall Callable<?> superMethod, @AllArguments Object[] args, @This Object me, @FieldValue(value="liveObjectLiveMap") RMap<String, Object> liveMap) throws Exception {
        if (this.isGetter(method, AccessorInterceptor.getREntityIdFieldName(me))) {
            return ((RLiveObject)me).getLiveObjectId();
        }
        if (this.isSetter(method, AccessorInterceptor.getREntityIdFieldName(me))) {
            ((RLiveObject)me).setLiveObjectId(args[0]);
            return null;
        }
        String fieldName = this.getFieldName(method);
        Class<?> fieldType = me.getClass().getSuperclass().getDeclaredField(fieldName).getType();
        if (this.isGetter(method, fieldName)) {
            RObject ar;
            Object result = liveMap.get(fieldName);
            if (result == null && (ar = this.objectBuilder.createObject(((RLiveObject)me).getLiveObjectId(), me.getClass().getSuperclass(), fieldType, fieldName)) != null) {
                this.objectBuilder.store(ar, fieldName, liveMap);
                return ar;
            }
            if (result instanceof RedissonReference) {
                return RedissonObjectFactory.fromReference(this.redisson, (RedissonReference)result);
            }
            return result;
        }
        if (this.isSetter(method, fieldName)) {
            Object arg = args[0];
            if (arg != null && arg.getClass().isAnnotationPresent(REntity.class)) {
                throw new IllegalStateException("REntity object should be attached to Redisson first");
            }
            if (arg instanceof RLiveObject) {
                RLiveObject liveObject = (RLiveObject)arg;
                Class<?> rEntity = liveObject.getClass().getSuperclass();
                REntity anno = rEntity.getAnnotation(REntity.class);
                NamingScheme ns = anno.namingScheme().getDeclaredConstructor(Codec.class).newInstance(this.codecProvider.getCodec(anno, rEntity));
                liveMap.fastPut(fieldName, new RedissonReference(rEntity, ns.getName(rEntity, fieldType, AccessorInterceptor.getREntityIdFieldName(liveObject), liveObject.getLiveObjectId())));
                return me;
            }
            if (!(arg instanceof RObject) && (arg instanceof Collection || arg instanceof Map) && REntity.TransformationMode.ANNOTATION_BASED.equals((Object)me.getClass().getSuperclass().getAnnotation(REntity.class).fieldTransformation())) {
                RObject rObject = this.objectBuilder.createObject(((RLiveObject)me).getLiveObjectId(), me.getClass().getSuperclass(), arg.getClass(), fieldName);
                if (arg != null) {
                    if (rObject instanceof Collection) {
                        Collection c = (Collection)((Object)rObject);
                        c.clear();
                        c.addAll((Collection)arg);
                    } else {
                        Map m = (Map)((Object)rObject);
                        m.clear();
                        m.putAll((Map)arg);
                    }
                }
                if (rObject != null) {
                    arg = rObject;
                }
            }
            if (arg instanceof RObject) {
                this.objectBuilder.store((RObject)arg, fieldName, liveMap);
                return me;
            }
            if (arg == null) {
                liveMap.remove(fieldName);
            } else {
                liveMap.fastPut(fieldName, arg);
            }
            return me;
        }
        return superMethod.call();
    }

    private String getFieldName(Method method) {
        return method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
    }

    private boolean isGetter(Method method, String fieldName) {
        return method.getName().equals("get" + AccessorInterceptor.getFieldNameSuffix(fieldName)) || method.getName().equals("is" + AccessorInterceptor.getFieldNameSuffix(fieldName));
    }

    private boolean isSetter(Method method, String fieldName) {
        return method.getName().equals("set" + AccessorInterceptor.getFieldNameSuffix(fieldName));
    }

    private static String getFieldNameSuffix(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static String getREntityIdFieldName(Object o) throws Exception {
        return ((FieldDescription.InDefinedShape)Introspectior.getFieldsWithAnnotation(o.getClass().getSuperclass(), RId.class).getOnly()).getName();
    }
}

