/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionWatchdog
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Timer timer;
    private final Bootstrap bootstrap;
    private final ChannelGroup channels;
    private static final int BACKOFF_CAP = 12;

    public ConnectionWatchdog(Bootstrap bootstrap, ChannelGroup channels, Timer timer) {
        this.bootstrap = bootstrap;
        this.channels = channels;
        this.timer = timer;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channels.add(ctx.channel());
        ctx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Object connection = RedisConnection.getFrom(ctx.channel());
        if (connection != null) {
            ((RedisConnection)connection).onDisconnect();
            if (!((RedisConnection)connection).isClosed()) {
                if (((RedisConnection)connection).isFastReconnect()) {
                    this.tryReconnect((RedisConnection)connection, 1);
                    ((RedisConnection)connection).clearFastReconnect();
                } else {
                    this.reconnect((RedisConnection)connection, 1);
                }
            }
        }
        ctx.fireChannelInactive();
    }

    private void reconnect(final RedisConnection connection, final int attempts) {
        int timeout = 2 << attempts;
        if (this.bootstrap.group().isShuttingDown()) {
            return;
        }
        this.timer.newTimeout(new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                ConnectionWatchdog.this.tryReconnect(connection, Math.min(12, attempts + 1));
            }
        }, timeout, TimeUnit.MILLISECONDS);
    }

    private void tryReconnect(final RedisConnection connection, final int nextAttempt) {
        if (connection.isClosed() || this.bootstrap.group().isShuttingDown()) {
            return;
        }
        this.log.debug("reconnecting {} to {} ", connection, connection.getRedisClient().getAddr(), connection);
        this.bootstrap.connect().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (connection.isClosed() || ConnectionWatchdog.this.bootstrap.group().isShuttingDown()) {
                    return;
                }
                try {
                    if (future.isSuccess()) {
                        ConnectionWatchdog.this.log.debug("{} connected to {}", (Object)connection, (Object)connection.getRedisClient().getAddr());
                        ConnectionWatchdog.this.reconnect(connection, future.channel());
                        return;
                    }
                }
                catch (RedisException e) {
                    ConnectionWatchdog.this.log.warn("Can't connect " + connection + " to " + connection.getRedisClient().getAddr(), e);
                }
                ConnectionWatchdog.this.reconnect(connection, nextAttempt);
            }
        });
    }

    private void reconnect(final RedisConnection connection, final Channel channel) {
        if (connection.getReconnectListener() != null) {
            RedisConnection rc = new RedisConnection(connection.getRedisClient(), channel);
            RedissonPromise<RedisConnection> connectionFuture = new RedissonPromise<RedisConnection>();
            connection.getReconnectListener().onReconnect(rc, connectionFuture);
            connectionFuture.addListener(new FutureListener<RedisConnection>(){

                @Override
                public void operationComplete(Future<RedisConnection> future) throws Exception {
                    if (future.isSuccess()) {
                        ConnectionWatchdog.this.refresh(connection, channel);
                    }
                }
            });
        } else {
            this.refresh(connection, channel);
        }
    }

    private void reattachPubSub(RedisConnection connection) {
        if (connection instanceof RedisPubSubConnection) {
            RedisPubSubConnection conn = (RedisPubSubConnection)connection;
            for (Map.Entry<String, Codec> entry : conn.getChannels().entrySet()) {
                conn.subscribe(entry.getValue(), entry.getKey());
            }
            for (Map.Entry<String, Codec> entry : conn.getPatternChannels().entrySet()) {
                conn.psubscribe(entry.getValue(), entry.getKey());
            }
        }
    }

    private void refresh(RedisConnection connection, Channel channel) {
        CommandData commandData = connection.getCurrentCommand();
        connection.updateChannel(channel);
        this.reattachBlockingQueue(connection, commandData);
        this.reattachPubSub(connection);
    }

    private void reattachBlockingQueue(RedisConnection connection, final CommandData<?, ?> commandData) {
        if (commandData == null || !commandData.isBlockingCommand() || commandData.getPromise().isDone()) {
            return;
        }
        ChannelFuture future = connection.send(commandData);
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ConnectionWatchdog.this.log.error("Can't reconnect blocking queue to new connection. {}", (Object)commandData);
                }
            }
        });
    }
}

