/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonMapIterator;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.MapScanCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.misc.Hash;

public class RedissonMap<K, V>
extends RedissonExpirable
implements RMap<K, V> {
    static final RedisCommand<Object> EVAL_REMOVE = new RedisCommand("EVAL", 4, RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE);
    static final RedisCommand<Object> EVAL_REPLACE = new RedisCommand("EVAL", 4, RedisCommand.ValueType.MAP, RedisCommand.ValueType.MAP_VALUE);
    static final RedisCommand<Boolean> EVAL_REPLACE_VALUE = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4, Arrays.asList(RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE, RedisCommand.ValueType.MAP_VALUE));
    static final RedisCommand<Boolean> EVAL_REMOVE_VALUE = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4, RedisCommand.ValueType.MAP);
    static final RedisCommand<Object> EVAL_PUT = EVAL_REPLACE;
    private final RedissonClient client;

    protected RedissonMap(RedissonClient client, CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.client = client;
    }

    public RedissonMap(RedissonClient client, Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.client = client;
    }

    @Override
    public RLock getLock(K key) {
        String lockName = this.getLockName(key);
        return this.client.getLock(lockName);
    }

    private String getLockName(Object key) {
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(key);
            return "{" + this.getName() + "}:" + Hash.hashToBase64(keyState) + ":key";
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HLEN, this.getName());
    }

    @Override
    public int valueSize(K key) {
        return this.get(this.valueSizeAsync(key));
    }

    @Override
    public RFuture<Integer> valueSizeAsync(K key) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HSTRLEN, this.getName(key), key);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(this.containsKeyAsync(key));
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        return this.commandExecutor.readAsync(this.getName(key), this.codec, RedisCommands.HEXISTS, this.getName(key), key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.get(this.containsValueAsync(value));
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        if (value == null) {
            throw new NullPointerException("map value can't be null");
        }
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4), "local s = redis.call('hvals', KEYS[1]);for i = 1, #s, 1 do if ARGV[1] == s[i] then return 1 end end;return 0", Collections.singletonList(this.getName()), value);
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        return this.get(this.getAllAsync(keys));
    }

    @Override
    public RFuture<Map<K, V>> getAllAsync(Set<K> keys) {
        if (keys.size() == 0) {
            return this.newSucceededFuture(Collections.emptyMap());
        }
        ArrayList<Object> args = new ArrayList<Object>(keys.size() + 1);
        args.add(this.getName());
        args.addAll(keys);
        return this.commandExecutor.readAsync(this.getName(), this.codec, new RedisCommand<Map<Object, Object>>("HMGET", new MapGetAllDecoder(args, 1), 2, RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE), args.toArray());
    }

    @Override
    public V get(Object key) {
        return this.get(this.getAsync(key));
    }

    @Override
    public V put(K key, V value) {
        return this.get(this.putAsync(key, value));
    }

    @Override
    public V remove(Object key) {
        return this.get(this.removeAsync(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.get(this.putAllAsync(map));
    }

    @Override
    public RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map) {
        if (map.isEmpty()) {
            return this.newSucceededFuture(null);
        }
        ArrayList<String> params = new ArrayList<String>(map.size() * 2 + 1);
        params.add(this.getName());
        for (Map.Entry<K, V> t : map.entrySet()) {
            params.add((String)t.getKey());
            params.add((String)t.getValue());
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.HMSET, params.toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Set<K> readAllKeySet() {
        return this.get(this.readAllKeySetAsync());
    }

    @Override
    public RFuture<Set<K>> readAllKeySetAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HKEYS, this.getName());
    }

    @Override
    public Collection<V> readAllValues() {
        return this.get(this.readAllValuesAsync());
    }

    @Override
    public RFuture<Collection<V>> readAllValuesAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HVALS, this.getName());
    }

    @Override
    public Set<Map.Entry<K, V>> readAllEntrySet() {
        return this.get(this.readAllEntrySetAsync());
    }

    @Override
    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HGETALL_ENTRY, this.getName());
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.get(this.putIfAbsentAsync(key, value));
    }

    @Override
    public RFuture<V> putIfAbsentAsync(K key, V value) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        if (value == null) {
            throw new NullPointerException("map value can't be null");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(key), this.codec, EVAL_PUT, "if redis.call('hsetnx', KEYS[1], ARGV[1], ARGV[2]) == 1 then return nil else return redis.call('hget', KEYS[1], ARGV[1]) end", Collections.singletonList(this.getName(key)), key, value);
    }

    @Override
    public boolean fastPutIfAbsent(K key, V value) {
        return this.get(this.fastPutIfAbsentAsync(key, value));
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        if (value == null) {
            throw new NullPointerException("map value can't be null");
        }
        return this.commandExecutor.writeAsync(this.getName(key), this.codec, RedisCommands.HSETNX, this.getName(key), key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.get(this.removeAsync(key, value));
    }

    @Override
    public RFuture<Boolean> removeAsync(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        if (value == null) {
            throw new NullPointerException("map value can't be null");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(key), this.codec, EVAL_REMOVE_VALUE, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then return redis.call('hdel', KEYS[1], ARGV[1]) else return 0 end", Collections.singletonList(this.getName(key)), key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.get(this.replaceAsync(key, oldValue, newValue));
    }

    @Override
    public RFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        if (oldValue == null) {
            throw new NullPointerException("map oldValue can't be null");
        }
        if (newValue == null) {
            throw new NullPointerException("map newValue can't be null");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(key), this.codec, EVAL_REPLACE_VALUE, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then redis.call('hset', KEYS[1], ARGV[1], ARGV[3]); return 1; else return 0; end", Collections.singletonList(this.getName(key)), key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.get(this.replaceAsync(key, value));
    }

    @Override
    public RFuture<V> replaceAsync(K key, V value) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        if (value == null) {
            throw new NullPointerException("map value can't be null");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(key), this.codec, EVAL_REPLACE, "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return v; else return nil; end", Collections.singletonList(this.getName(key)), key, value);
    }

    @Override
    public RFuture<V> getAsync(K key) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        return this.commandExecutor.readAsync(this.getName(key), this.codec, RedisCommands.HGET, this.getName(key), key);
    }

    protected String getName(Object key) {
        return this.getName();
    }

    @Override
    public RFuture<V> putAsync(K key, V value) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        if (value == null) {
            throw new NullPointerException("map value can't be null");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(key), this.codec, EVAL_PUT, "local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return v", Collections.singletonList(this.getName(key)), key, value);
    }

    @Override
    public RFuture<V> removeAsync(K key) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(key), this.codec, EVAL_REMOVE, "local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hdel', KEYS[1], ARGV[1]); return v", Collections.singletonList(this.getName(key)), key);
    }

    @Override
    public RFuture<Boolean> fastPutAsync(K key, V value) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        if (value == null) {
            throw new NullPointerException("map value can't be null");
        }
        return this.commandExecutor.writeAsync(this.getName(key), this.codec, RedisCommands.HSET, this.getName(key), key, value);
    }

    @Override
    public boolean fastPut(K key, V value) {
        return this.get(this.fastPutAsync(key, value));
    }

    @Override
    public RFuture<Long> fastRemoveAsync(K ... keys) {
        if (keys == null || keys.length == 0) {
            return this.newSucceededFuture(0L);
        }
        ArrayList<String> args = new ArrayList<String>(keys.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(keys));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.HDEL, args.toArray());
    }

    @Override
    public long fastRemove(K ... keys) {
        return this.get(this.fastRemoveAsync(keys));
    }

    MapScanResult<ScanObjectEntry, ScanObjectEntry> scanIterator(String name, InetSocketAddress client, long startPos) {
        RFuture f = this.commandExecutor.readAsync(client, name, (Codec)new MapScanCodec(this.codec), RedisCommands.HSCAN, name, startPos);
        return (MapScanResult)this.get(f);
    }

    @Override
    public V addAndGet(K key, Number value) {
        return this.get(this.addAndGetAsync(key, value));
    }

    @Override
    public RFuture<V> addAndGetAsync(K key, Number value) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
        if (value == null) {
            throw new NullPointerException("map value can't be null");
        }
        byte[] keyState = this.encodeMapKey(key);
        return this.commandExecutor.writeAsync(this.getName(key), (Codec)StringCodec.INSTANCE, new RedisCommand<Object>("HINCRBYFLOAT", new NumberConvertor(value.getClass())), this.getName(key), keyState, new BigDecimal(value.toString()).toPlainString());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    protected Iterator<K> keyIterator() {
        return new RedissonMapIterator<K, V, K>(this){

            @Override
            protected K getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                return entry.getKey().getObj();
            }
        };
    }

    protected Iterator<V> valueIterator() {
        return new RedissonMapIterator<K, V, V>(this){

            @Override
            protected V getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                return entry.getValue().getObj();
            }
        };
    }

    protected Iterator<Map.Entry<K, V>> entryIterator() {
        return new RedissonMapIterator(this);
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return RedissonMap.this.entryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = RedissonMap.this.get(key);
            return value != null && value.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return RedissonMap.this.remove(key, value);
            }
            return false;
        }

        @Override
        public final int size() {
            return RedissonMap.this.size();
        }

        @Override
        public final void clear() {
            RedissonMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return RedissonMap.this.valueIterator();
        }

        @Override
        public boolean contains(Object o) {
            return RedissonMap.this.containsValue(o);
        }

        @Override
        public int size() {
            return RedissonMap.this.size();
        }

        @Override
        public void clear() {
            RedissonMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return RedissonMap.this.keyIterator();
        }

        @Override
        public boolean contains(Object o) {
            return RedissonMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return RedissonMap.this.fastRemove(o) == 1L;
        }

        @Override
        public int size() {
            return RedissonMap.this.size();
        }

        @Override
        public void clear() {
            RedissonMap.this.clear();
        }
    }
}

