/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.BufferCodec;
import reactor.io.codec.Codec;

public abstract class CompressionCodec<IN, OUT>
extends BufferCodec<IN, OUT> {
    private final Codec<Buffer, IN, OUT> delegate;

    protected CompressionCodec(Codec<Buffer, IN, OUT> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Function<Buffer, IN> decoder(final Consumer<IN> next) {
        return new Function<Buffer, IN>(){

            @Override
            public IN apply(Buffer buffer) {
                try {
                    ByteArrayInputStream bin = new ByteArrayInputStream(buffer.asBytes());
                    InputStream zin = CompressionCodec.this.createInputStream(bin);
                    Buffer newBuff = new Buffer();
                    while (zin.available() > 0) {
                        newBuff.append((byte)zin.read());
                    }
                    zin.close();
                    Object in = CompressionCodec.this.delegate.decoder(null).apply(newBuff.flip());
                    if (null != next) {
                        next.accept(in);
                        return null;
                    }
                    return in;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        };
    }

    @Override
    public Buffer apply(OUT out) {
        Buffer buff = (Buffer)this.delegate.apply(out);
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStream zout = this.createOutputStream(bout);
            zout.write(buff.asBytes());
            zout.flush();
            bout.flush();
            zout.close();
            return Buffer.wrap(bout.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected abstract InputStream createInputStream(InputStream var1) throws IOException;

    protected abstract OutputStream createOutputStream(OutputStream var1) throws IOException;
}

