/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class ObjectMapDecoder
implements MultiDecoder<Map<Object, Object>> {
    private Codec codec;
    private int pos;

    public ObjectMapDecoder(Codec codec) {
        this.codec = codec;
    }

    @Override
    public Object decode(ByteBuf buf, State state) throws IOException {
        if (this.pos++ % 2 == 0) {
            return this.codec.getMapKeyDecoder().decode(buf, state);
        }
        return this.codec.getMapValueDecoder().decode(buf, state);
    }

    @Override
    public Map<Object, Object> decode(List<Object> parts, State state) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(parts.size() / 2);
        for (int i = 0; i < parts.size(); ++i) {
            if (i % 2 == 0) continue;
            result.put(parts.get(i - 1), parts.get(i));
        }
        return result;
    }

    @Override
    public boolean isApplicable(int paramNum, State state) {
        return true;
    }
}

