/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.cache;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.redisson.misc.Hash;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.NullValue;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class RedissonCache
implements Cache {
    private RMapCache<Object, Object> mapCache;
    private final RMap<Object, Object> map;
    private CacheConfig config;
    private final RedissonClient redisson;

    public RedissonCache(RedissonClient redisson, RMapCache<Object, Object> mapCache, CacheConfig config) {
        this.mapCache = mapCache;
        this.map = mapCache;
        this.config = config;
        this.redisson = redisson;
    }

    public RedissonCache(RedissonClient redisson, RMap<Object, Object> map) {
        this.map = map;
        this.redisson = redisson;
    }

    public String getName() {
        return this.map.getName();
    }

    public RMap<?, ?> getNativeCache() {
        return this.map;
    }

    public Cache.ValueWrapper get(Object key) {
        Object value = this.map.get(key);
        return this.toValueWrapper(value);
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.map.get(key);
        if (value != null) {
            if (value.getClass().getName().equals(NullValue.class.getName())) {
                return null;
            }
            if (type != null && !type.isInstance(value)) {
                throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
            }
        }
        return (T)value;
    }

    public void put(Object key, Object value) {
        if (this.mapCache != null) {
            this.mapCache.fastPut(key, value, this.config.getTTL(), TimeUnit.MILLISECONDS, this.config.getMaxIdleTime(), TimeUnit.MILLISECONDS);
        } else {
            this.map.fastPut(key, value);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object prevValue = this.mapCache != null ? this.mapCache.putIfAbsent(key, value, this.config.getTTL(), TimeUnit.MILLISECONDS, this.config.getMaxIdleTime(), TimeUnit.MILLISECONDS) : this.map.putIfAbsent(key, value);
        return this.toValueWrapper(prevValue);
    }

    public void evict(Object key) {
        this.map.fastRemove((Object[])new Object[]{key});
    }

    public void clear() {
        this.map.clear();
    }

    private Cache.ValueWrapper toValueWrapper(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().getName().equals(NullValue.class.getName())) {
            return NullValue.INSTANCE;
        }
        return new SimpleValueWrapper(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value;
        block8: {
            value = this.map.get(key);
            if (value == null) {
                String lockName = this.getLockName(key);
                RLock lock = this.redisson.getLock(lockName);
                lock.lock();
                try {
                    value = this.map.get(key);
                    if (value != null) break block8;
                    try {
                        value = this.toStoreValue(valueLoader.call());
                    }
                    catch (Exception ex) {
                        try {
                            Class<?> c = Class.forName("org.springframework.cache.Cache$ValueRetrievalException");
                            Constructor<?> constructor = c.getConstructor(Object.class, Callable.class, Throwable.class);
                            RuntimeException exception = (RuntimeException)constructor.newInstance(key, valueLoader, ex.getCause());
                            throw exception;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    this.map.put(key, value);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return (T)this.fromStoreValue(value);
    }

    private String getLockName(Object key) {
        try {
            byte[] keyState = this.redisson.getConfig().getCodec().getMapKeyEncoder().encode(key);
            return "{" + this.map.getName() + "}:" + Hash.hashToBase64(keyState) + ":key";
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Object fromStoreValue(Object storeValue) {
        if (storeValue == NullValue.INSTANCE) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(Object userValue) {
        if (userValue == null) {
            return NullValue.INSTANCE;
        }
        return userValue;
    }
}

