/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.redisson.api.RFuture;
import org.redisson.misc.RPromise;

public class RedissonPromise<T>
implements RPromise<T> {
    private final Promise<T> promise = ImmediateEventExecutor.INSTANCE.newPromise();

    public static <V> RFuture<V> newFailedFuture(Throwable cause) {
        RedissonPromise future = new RedissonPromise();
        future.tryFailure(cause);
        return future;
    }

    public static <V> RFuture<V> newSucceededFuture(V result) {
        RedissonPromise<V> future = new RedissonPromise<V>();
        future.trySuccess(result);
        return future;
    }

    public Promise<T> getInnerPromise() {
        return this.promise;
    }

    @Override
    public boolean isSuccess() {
        return this.promise.isSuccess();
    }

    @Override
    public boolean trySuccess(T result) {
        return this.promise.trySuccess(result);
    }

    @Override
    public Throwable cause() {
        return this.promise.cause();
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        return this.promise.tryFailure(cause);
    }

    @Override
    public boolean setUncancellable() {
        return this.promise.setUncancellable();
    }

    @Override
    public RPromise<T> addListener(FutureListener<? super T> listener) {
        this.promise.addListener(listener);
        return this;
    }

    @Override
    public RPromise<T> addListeners(FutureListener<? super T> ... listeners) {
        this.promise.addListeners(listeners);
        return this;
    }

    @Override
    public RPromise<T> removeListener(FutureListener<? super T> listener) {
        this.promise.removeListener(listener);
        return this;
    }

    @Override
    public RPromise<T> removeListeners(FutureListener<? super T> ... listeners) {
        this.promise.removeListeners(listeners);
        return this;
    }

    @Override
    public RPromise<T> await() throws InterruptedException {
        this.promise.await();
        return this;
    }

    @Override
    public RPromise<T> awaitUninterruptibly() {
        this.promise.awaitUninterruptibly();
        return this;
    }

    @Override
    public RPromise<T> sync() throws InterruptedException {
        this.promise.sync();
        return this;
    }

    @Override
    public RPromise<T> syncUninterruptibly() {
        this.promise.syncUninterruptibly();
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.promise.await(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        return this.promise.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.promise.isDone();
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.promise.await(timeoutMillis);
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.promise.get();
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.promise.awaitUninterruptibly(timeout, unit);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.promise.get(timeout, unit);
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.promise.awaitUninterruptibly(timeoutMillis);
    }

    @Override
    public T getNow() {
        return (T)this.promise.getNow();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.promise.cancel(mayInterruptIfRunning);
    }
}

