/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.aggregation;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import reactor.core.Dispatcher;
import reactor.fn.timer.Timer;
import reactor.rx.action.aggregation.BatchAction;

public class BufferAction<T>
extends BatchAction<T, List<T>> {
    private final List<T> values = new ArrayList<T>();

    public BufferAction(Dispatcher dispatcher, int batchsize) {
        super(dispatcher, batchsize, true, false, true);
    }

    public BufferAction(Dispatcher dispatcher, int maxSize, long timespan, TimeUnit unit, Timer timer) {
        super(dispatcher, maxSize, true, false, true, timespan, unit, timer);
    }

    @Override
    protected void doError(Throwable ev) {
        this.values.clear();
        super.doError(ev);
    }

    @Override
    public void nextCallback(T value) {
        this.values.add(value);
    }

    @Override
    public void flushCallback(T ev) {
        if (this.values.isEmpty()) {
            return;
        }
        ArrayList<T> toSend = new ArrayList<T>(this.values);
        this.values.clear();
        this.broadcastNext(toSend);
    }
}

